import { DependencyStatsOutput, InstallTarget } from 'esinstall';
import { CommandOptions, ImportMap, SnowpackConfig, SnowpackSourceFile } from '../types/snowpack';
export declare function getInstallTargets(config: SnowpackConfig, scannedFiles?: SnowpackSourceFile[]): Promise<InstallTarget[]>;
export declare function command(commandOptions: CommandOptions): Promise<void>;
interface InstallRunOptions extends CommandOptions {
    installTargets: InstallTarget[];
    shouldWriteLockfile: boolean;
    shouldPrintStats: boolean;
}
interface InstallRunResult {
    importMap: ImportMap;
    newLockfile: ImportMap | null;
    stats: DependencyStatsOutput | null;
}
export declare function run({ config, installTargets, shouldWriteLockfile, shouldPrintStats, }: InstallRunOptions): Promise<InstallRunResult>;
export {};
