"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const colors = __importStar(require("kleur/colors"));
const path_1 = __importDefault(require("path"));
const skypack_1 = require("skypack");
const logger_1 = require("../logger");
const fetchedPackages = new Set();
function logFetching(packageName) {
    if (fetchedPackages.has(packageName)) {
        return;
    }
    fetchedPackages.add(packageName);
    logger_1.logger.info(`Fetching latest ${colors.bold(packageName)} ${colors.dim(`→ ${skypack_1.SKYPACK_ORIGIN}/${packageName}`)}`, { name: 'source:skypack' });
}
function parseRawPackageImport(spec) {
    const impParts = spec.split('/');
    if (spec.startsWith('@')) {
        const [scope, name, ...rest] = impParts;
        return [`${scope}/${name}`, rest.join('/') || null];
    }
    const [name, ...rest] = impParts;
    return [name, rest.join('/') || null];
}
/**
 * Skypack Package Source: A generic interface through which
 * Snowpack interacts with the Skypack CDN. Used to load dependencies
 * from the CDN during both development and optimized building.
 */
exports.default = {
    async prepare() {
        // Skypack resolves imports on the fly, so no import map needed.
        return { imports: {} };
    },
    async modifyBuildInstallConfig({ config, lockfile, }) {
        config.installOptions.lockfile = lockfile || undefined;
        config.installOptions.rollup = config.installOptions.rollup || {};
        config.installOptions.rollup.plugins = config.installOptions.rollup.plugins || [];
        config.installOptions.rollup.plugins.push(skypack_1.rollupPluginSkypack({ installTypes: false }));
    },
    async load(spec, { config, lockfile }) {
        let body;
        if (spec.startsWith('-/') ||
            spec.startsWith('pin/') ||
            spec.startsWith('new/') ||
            spec.startsWith('error/')) {
            body = (await skypack_1.fetchCDN(`/${spec}`)).body;
        }
        else {
            const [packageName, packagePath] = parseRawPackageImport(spec);
            if (lockfile && lockfile.imports[spec]) {
                body = (await skypack_1.fetchCDN(lockfile.imports[spec])).body;
            }
            else if (lockfile && lockfile.imports[packageName + '/']) {
                body = (await skypack_1.fetchCDN(lockfile.imports[packageName + '/'] + packagePath)).body;
            }
            else {
                // TODO: When config.root is added, look up package.json "dependencies" & "devDependencies"
                // from the root and fallback to those if lockfile.dependencies[packageName] doesn't exist.
                const _packageSemver = (lockfile === null || lockfile === void 0 ? void 0 : lockfile.dependencies) && lockfile.dependencies[packageName];
                if (!_packageSemver) {
                    logFetching(packageName);
                }
                const packageSemver = _packageSemver || 'latest';
                let lookupResponse = await skypack_1.lookupBySpecifier(spec, packageSemver);
                if (!lookupResponse.error && lookupResponse.importStatus === 'NEW') {
                    const buildResponse = await skypack_1.buildNewPackage(spec, packageSemver);
                    if (!buildResponse.success) {
                        throw new Error('Package could not be built!');
                    }
                    lookupResponse = await skypack_1.lookupBySpecifier(spec, packageSemver);
                }
                if (lookupResponse.error) {
                    throw lookupResponse.error;
                }
                body = lookupResponse.body;
            }
        }
        return body
            .replace(/(from|import) \'\//g, `$1 '${config.buildOptions.webModulesUrl}/`)
            .replace(/(from|import) \"\//g, `$1 "${config.buildOptions.webModulesUrl}/`);
    },
    resolvePackageImport(missingPackage, _, config) {
        return path_1.default.posix.join(config.buildOptions.webModulesUrl, missingPackage);
    },
    async recoverMissingPackageImport() {
        throw new Error('Unexpected Error: No such thing as a "missing" package import with Skypack.');
    },
};
//# sourceMappingURL=skypack.js.map