'use strict';

var _package = require('./package.js');
require('path');
require('module');
var fs = require('fs');
var Url = require('url');
var index = require('./index4.js');
var http = require('http');

const mutable = (dir) =>
	index.sirv(dir, {
		etag: true,
		maxAge: 0
	});

function start({ port }) {
	return new Promise((fulfil) => {
		const app = _package.requireRelative_1('./.svelte/build/optimized/server/app.js');

		const static_handler = fs.existsSync(app.paths.static)
			? mutable(app.paths.static)
			: (_req, _res, next) => next();

		const assets_handler = index.sirv('.svelte/build/optimized/client', {
			maxAge: 31536000,
			immutable: true
		});

		const server = http.createServer((req, res) => {
			const parsed = Url.parse(req.url || '');

			assets_handler(req, res, () => {
				static_handler(req, res, async () => {
					const rendered = await app.render({
						host: null, // TODO
						method: req.method,
						headers: req.headers, // TODO: what about repeated headers, i.e. string[]
						path: parsed.pathname,
						body: await index.get_body(req),
						query: new Url.URLSearchParams(parsed.query || '')
					});

					if (rendered) {
						res.writeHead(rendered.status, rendered.headers);
						res.end(rendered.body);
					} else {
						res.statusCode = 404;
						res.end('Not found');
					}
				});
			});
		});

		server.listen(port, () => {
			fulfil(server);
		});
	});
}

exports.start = start;
//# sourceMappingURL=index3.js.map
