'use strict';

var path = require('path');
var Module = require('module');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var path__default = /*#__PURE__*/_interopDefaultLegacy(path);
var Module__default = /*#__PURE__*/_interopDefaultLegacy(Module);

let FORCE_COLOR, NODE_DISABLE_COLORS, NO_COLOR, TERM, isTTY=true;
if (typeof process !== 'undefined') {
	({ FORCE_COLOR, NODE_DISABLE_COLORS, NO_COLOR, TERM } = process.env);
	isTTY = process.stdout && process.stdout.isTTY;
}

const $ = {
	enabled: !NODE_DISABLE_COLORS && NO_COLOR == null && TERM !== 'dumb' && (
		FORCE_COLOR != null && FORCE_COLOR !== '0' || isTTY
	),

	// modifiers
	reset: init(0, 0),
	bold: init(1, 22),
	dim: init(2, 22),
	italic: init(3, 23),
	underline: init(4, 24),
	inverse: init(7, 27),
	hidden: init(8, 28),
	strikethrough: init(9, 29),

	// colors
	black: init(30, 39),
	red: init(31, 39),
	green: init(32, 39),
	yellow: init(33, 39),
	blue: init(34, 39),
	magenta: init(35, 39),
	cyan: init(36, 39),
	white: init(37, 39),
	gray: init(90, 39),
	grey: init(90, 39),

	// background colors
	bgBlack: init(40, 49),
	bgRed: init(41, 49),
	bgGreen: init(42, 49),
	bgYellow: init(43, 49),
	bgBlue: init(44, 49),
	bgMagenta: init(45, 49),
	bgCyan: init(46, 49),
	bgWhite: init(47, 49)
};

function run(arr, str) {
	let i=0, tmp, beg='', end='';
	for (; i < arr.length; i++) {
		tmp = arr[i];
		beg += tmp.open;
		end += tmp.close;
		if (str.includes(tmp.close)) {
			str = str.replace(tmp.rgx, tmp.close + tmp.open);
		}
	}
	return beg + str + end;
}

function chain(has, keys) {
	let ctx = { has, keys };

	ctx.reset = $.reset.bind(ctx);
	ctx.bold = $.bold.bind(ctx);
	ctx.dim = $.dim.bind(ctx);
	ctx.italic = $.italic.bind(ctx);
	ctx.underline = $.underline.bind(ctx);
	ctx.inverse = $.inverse.bind(ctx);
	ctx.hidden = $.hidden.bind(ctx);
	ctx.strikethrough = $.strikethrough.bind(ctx);

	ctx.black = $.black.bind(ctx);
	ctx.red = $.red.bind(ctx);
	ctx.green = $.green.bind(ctx);
	ctx.yellow = $.yellow.bind(ctx);
	ctx.blue = $.blue.bind(ctx);
	ctx.magenta = $.magenta.bind(ctx);
	ctx.cyan = $.cyan.bind(ctx);
	ctx.white = $.white.bind(ctx);
	ctx.gray = $.gray.bind(ctx);
	ctx.grey = $.grey.bind(ctx);

	ctx.bgBlack = $.bgBlack.bind(ctx);
	ctx.bgRed = $.bgRed.bind(ctx);
	ctx.bgGreen = $.bgGreen.bind(ctx);
	ctx.bgYellow = $.bgYellow.bind(ctx);
	ctx.bgBlue = $.bgBlue.bind(ctx);
	ctx.bgMagenta = $.bgMagenta.bind(ctx);
	ctx.bgCyan = $.bgCyan.bind(ctx);
	ctx.bgWhite = $.bgWhite.bind(ctx);

	return ctx;
}

function init(open, close) {
	let blk = {
		open: `\x1b[${open}m`,
		close: `\x1b[${close}m`,
		rgx: new RegExp(`\\x1b\\[${close}m`, 'g')
	};
	return function (txt) {
		if (this !== void 0 && this.has !== void 0) {
			this.has.includes(open) || (this.has.push(open),this.keys.push(blk));
			return txt === void 0 ? this : $.enabled ? run(this.keys, txt+'') : txt+'';
		}
		return txt === void 0 ? chain([open], [blk]) : $.enabled ? run([blk], txt+'') : txt+'';
	};
}

var modules = {};

var getModule = function(dir) {
  var rootPath = dir ? path__default['default'].resolve(dir) : process.cwd();
  var rootName = path__default['default'].join(rootPath, '@root');
  var root = modules[rootName];
  if (!root) {
    root = new Module__default['default'](rootName);
    root.filename = rootName;
    root.paths = Module__default['default']._nodeModulePaths(rootPath);
    modules[rootName] = root;
  }
  return root;
};

var requireRelative = function(requested, relativeTo) {
  var root = getModule(relativeTo);
  return root.require(requested);
};

requireRelative.resolve = function(requested, relativeTo) {
  var root = getModule(relativeTo);
  return Module__default['default']._resolveFilename(requested, root);
};

var requireRelative_1 = requireRelative;

const default_config = {
	target: null,
	paths: {
		static: 'static',
		routes: 'src/routes',
		setup: 'src/setup',
		template: 'src/app.html'
	}
};

function load_config({ cwd = process.cwd() } = {}) {
	const config = requireRelative_1('./svelte.config.js', cwd);

	return {
		...default_config,
		...config,
		paths: {
			...default_config.paths,
			...config.paths
		}
	};
}

var name = "@sveltejs/kit";
var version = "0.0.30";
var dependencies = {
	"@sveltejs/app-utils": "0.0.18",
	"cheap-watch": "^1.0.2",
	"http-proxy": "^1.18.1",
	rollup: "^2.32.0",
	"rollup-dependency-tree": "0.0.14",
	"rollup-plugin-css-chunks": "^1.2.8",
	"rollup-plugin-terser": "^7.0.2",
	sade: "^1.7.4",
	scorta: "^1.0.0",
	snowpack: "^2.17.0"
};
var devDependencies = {
	"@types/node": "^14.11.10",
	"@types/rimraf": "^3.0.0",
	"@types/sade": "^1.7.2",
	eslint: "^7.14.0",
	esm: "^3.2.25",
	"estree-walker": "^2.0.1",
	kleur: "^4.1.3",
	"magic-string": "^0.25.7",
	meriyah: "^3.0.3",
	"node-fetch": "^2.6.1",
	periscopic: "^2.0.2",
	"port-authority": "^1.1.1",
	"require-relative": "^0.8.7",
	rimraf: "^3.0.2",
	sirv: "^1.0.7",
	"source-map-support": "^0.5.19",
	svelte: "^3.29.0",
	"tiny-glob": "^0.2.8"
};
var bin = {
	"svelte-kit": "svelte-kit"
};
var files = [
	"assets",
	"dist",
	"client"
];
var scripts = {
	dev: "rollup -cw",
	build: "rollup -c",
	lint: "eslint --ignore-pattern node_modules/ --ignore-pattern dist/ --ignore-pattern assets/ \"**/*.{ts,mjs,js,svelte}\" && npm run check-format",
	format: "prettier --write . --config ../../.prettierrc --ignore-path .gitignore",
	"check-format": "prettier --check . --config ../../.prettierrc --ignore-path .gitignore",
	prepublishOnly: "npm run build",
	test: "uvu src \"(spec.js|test/index.js)\" -r esm"
};
var pkg = {
	name: name,
	version: version,
	dependencies: dependencies,
	devDependencies: devDependencies,
	bin: bin,
	files: files,
	scripts: scripts
};

exports.$ = $;
exports.load_config = load_config;
exports.pkg = pkg;
exports.requireRelative_1 = requireRelative_1;
exports.version = version;
//# sourceMappingURL=package.js.map
