import type React from "react"
import type { Metadata } from "next"
import { Inter, Roboto_Mono } from "next/font/google" // <-- Zamjena za Geist
import { Analytics } from "@vercel/analytics/next"
import { ThemeProvider } from "@/components/theme-provider"
import { Suspense } from "react"
import "./globals.css"

const geistSans = Inter({            // Privremeno
  subsets: ["latin"],
  display: "swap",
  variable: "--font-geist-sans",
})

const geistMono = Roboto_Mono({      // Privremeno
  subsets: ["latin"],
  display: "swap",
  variable: "--font-geist-mono",
})

export const metadata: Metadata = {
  title: "Kristijan Design | Web and Graphic Designer",
  description:
    "Professional web and graphic designer specializing in AI integration, modern web solutions, and innovative digital experiences.",
  keywords: ["web design", "AI integration", "machine learning", "UI/UX design", "digital solutions", "e-commerce"],
  authors: [{ name: "Kristijan Design" }],
  openGraph: {
    title: "Kristijan Design | Web and Graphic Designer",
    description:
      "Professional web and graphic designer specializing in AI integration, modern web solutions, and innovative digital experiences.",
    type: "website",
  },
  generator: 'v0.app'
}

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode
}>) {
  return (
    <html lang="en" suppressHydrationWarning>
      <body className={`${geistSans.variable} ${geistMono.variable} font-sans antialiased`}>
        <Suspense fallback={null}>
          <ThemeProvider attribute="class" defaultTheme="light" enableSystem disableTransitionOnChange={false}>
            {children}
            <Analytics />
          </ThemeProvider>
        </Suspense>
      </body>
    </html>
  )
}