"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var chai_1 = require("chai");
var index_1 = require("../index");
var realworld_1 = require("./realworld");
var index2_1 = require("./index2");
var bar_1 = require("./bar");
describe('test suite', function () {
    it('dependenciesForTree should handle sveltejs/realworld example', function () {
        var rollupData = realworld_1.default;
        var entryChunk = rollupData.find(function (c) { return c.facadeModuleId && c.facadeModuleId.endsWith('routes/index.svelte'); });
        var result = index_1.dependenciesForTree(entryChunk, rollupData, { walk: function (ctx) { return !ctx.dynamicImport; } });
        chai_1.expect(result.size).equal(5);
    });
    it('dependenciesForTree should handle sapper css index2 test', function () {
        var rollupData = index2_1.default;
        var entryChunk = rollupData.find(function (c) { return c.facadeModuleId && c.facadeModuleId.endsWith('routes/index2.svelte'); });
        var result = index_1.dependenciesForTree(entryChunk, rollupData, { walk: function (ctx) { return !ctx.dynamicImport; } });
        chai_1.expect(result.size).equal(3);
    });
    it('dependenciesForTree should handle sapper css bar test', function () {
        var rollupData = bar_1.default;
        var entryChunk = rollupData.find(function (c) { return c.facadeModuleId && c.facadeModuleId.includes('client.js'); });
        var result = index_1.dependenciesForTree(entryChunk, rollupData, { filter: function (ctx) { return ctx.dynamicImport; } });
        chai_1.expect(Array.from(result).find(function (c) { return c.fileName === 'Title.9a7177bc.js'; })).to.be.ok;
    });
});
