export default [
   {
      "code":"function noop() { }\nfunction assign(tar, src) {\n    // @ts-ignore\n    for (const k in src)\n        tar[k] = src[k];\n    return tar;\n}\nfunction run(fn) {\n    return fn();\n}\nfunction blank_object() {\n    return Object.create(null);\n}\nfunction run_all(fns) {\n    fns.forEach(run);\n}\nfunction is_function(thing) {\n    return typeof thing === 'function';\n}\nfunction safe_not_equal(a, b) {\n    return a != a ? b == b : a !== b || ((a && typeof a === 'object') || typeof a === 'function');\n}\nfunction subscribe(store, ...callbacks) {\n    if (store == null) {\n        return noop;\n    }\n    const unsub = store.subscribe(...callbacks);\n    return unsub.unsubscribe ? () => unsub.unsubscribe() : unsub;\n}\nfunction component_subscribe(component, store, callback) {\n    component.$$.on_destroy.push(subscribe(store, callback));\n}\nfunction create_slot(definition, ctx, $$scope, fn) {\n    if (definition) {\n        const slot_ctx = get_slot_context(definition, ctx, $$scope, fn);\n        return definition[0](slot_ctx);\n    }\n}\nfunction get_slot_context(definition, ctx, $$scope, fn) {\n    return definition[1] && fn\n        ? assign($$scope.ctx.slice(), definition[1](fn(ctx)))\n        : $$scope.ctx;\n}\nfunction get_slot_changes(definition, $$scope, dirty, fn) {\n    if (definition[2] && fn) {\n        const lets = definition[2](fn(dirty));\n        if ($$scope.dirty === undefined) {\n            return lets;\n        }\n        if (typeof lets === 'object') {\n            const merged = [];\n            const len = Math.max($$scope.dirty.length, lets.length);\n            for (let i = 0; i < len; i += 1) {\n                merged[i] = $$scope.dirty[i] | lets[i];\n            }\n            return merged;\n        }\n        return $$scope.dirty | lets;\n    }\n    return $$scope.dirty;\n}\nfunction update_slot(slot, slot_definition, ctx, $$scope, dirty, get_slot_changes_fn, get_slot_context_fn) {\n    const slot_changes = get_slot_changes(slot_definition, $$scope, dirty, get_slot_changes_fn);\n    if (slot_changes) {\n        const slot_context = get_slot_context(slot_definition, ctx, $$scope, get_slot_context_fn);\n        slot.p(slot_context, slot_changes);\n    }\n}\nfunction set_store_value(store, ret, value = ret) {\n    store.set(value);\n    return ret;\n}\nfunction action_destroyer(action_result) {\n    return action_result && is_function(action_result.destroy) ? action_result.destroy : noop;\n}\n\nfunction append(target, node) {\n    target.appendChild(node);\n}\nfunction insert(target, node, anchor) {\n    target.insertBefore(node, anchor || null);\n}\nfunction detach(node) {\n    node.parentNode.removeChild(node);\n}\nfunction destroy_each(iterations, detaching) {\n    for (let i = 0; i < iterations.length; i += 1) {\n        if (iterations[i])\n            iterations[i].d(detaching);\n    }\n}\nfunction element(name) {\n    return document.createElement(name);\n}\nfunction svg_element(name) {\n    return document.createElementNS('http://www.w3.org/2000/svg', name);\n}\nfunction text(data) {\n    return document.createTextNode(data);\n}\nfunction space() {\n    return text(' ');\n}\nfunction empty() {\n    return text('');\n}\nfunction listen(node, event, handler, options) {\n    node.addEventListener(event, handler, options);\n    return () => node.removeEventListener(event, handler, options);\n}\nfunction prevent_default(fn) {\n    return function (event) {\n        event.preventDefault();\n        // @ts-ignore\n        return fn.call(this, event);\n    };\n}\nfunction attr(node, attribute, value) {\n    if (value == null)\n        node.removeAttribute(attribute);\n    else if (node.getAttribute(attribute) !== value)\n        node.setAttribute(attribute, value);\n}\nfunction children(element) {\n    return Array.from(element.childNodes);\n}\nfunction claim_element(nodes, name, attributes, svg) {\n    for (let i = 0; i < nodes.length; i += 1) {\n        const node = nodes[i];\n        if (node.nodeName === name) {\n            let j = 0;\n            const remove = [];\n            while (j < node.attributes.length) {\n                const attribute = node.attributes[j++];\n                if (!attributes[attribute.name]) {\n                    remove.push(attribute.name);\n                }\n            }\n            for (let k = 0; k < remove.length; k++) {\n                node.removeAttribute(remove[k]);\n            }\n            return nodes.splice(i, 1)[0];\n        }\n    }\n    return svg ? svg_element(name) : element(name);\n}\nfunction claim_text(nodes, data) {\n    for (let i = 0; i < nodes.length; i += 1) {\n        const node = nodes[i];\n        if (node.nodeType === 3) {\n            node.data = '' + data;\n            return nodes.splice(i, 1)[0];\n        }\n    }\n    return text(data);\n}\nfunction claim_space(nodes) {\n    return claim_text(nodes, ' ');\n}\nfunction set_data(text, data) {\n    data = '' + data;\n    if (text.data !== data)\n        text.data = data;\n}\nfunction set_input_value(input, value) {\n    input.value = value == null ? '' : value;\n}\nfunction toggle_class(element, name, toggle) {\n    element.classList[toggle ? 'add' : 'remove'](name);\n}\nfunction custom_event(type, detail) {\n    const e = document.createEvent('CustomEvent');\n    e.initCustomEvent(type, false, false, detail);\n    return e;\n}\nfunction query_selector_all(selector, parent = document.body) {\n    return Array.from(parent.querySelectorAll(selector));\n}\n\nlet current_component;\nfunction set_current_component(component) {\n    current_component = component;\n}\nfunction get_current_component() {\n    if (!current_component)\n        throw new Error(`Function called outside component initialization`);\n    return current_component;\n}\nfunction onMount(fn) {\n    get_current_component().$$.on_mount.push(fn);\n}\nfunction afterUpdate(fn) {\n    get_current_component().$$.after_update.push(fn);\n}\nfunction createEventDispatcher() {\n    const component = get_current_component();\n    return (type, detail) => {\n        const callbacks = component.$$.callbacks[type];\n        if (callbacks) {\n            // TODO are there situations where events could be dispatched\n            // in a server (non-DOM) environment?\n            const event = custom_event(type, detail);\n            callbacks.slice().forEach(fn => {\n                fn.call(component, event);\n            });\n        }\n    };\n}\nfunction setContext(key, context) {\n    get_current_component().$$.context.set(key, context);\n}\nfunction getContext(key) {\n    return get_current_component().$$.context.get(key);\n}\n\nconst dirty_components = [];\nconst binding_callbacks = [];\nconst render_callbacks = [];\nconst flush_callbacks = [];\nconst resolved_promise = Promise.resolve();\nlet update_scheduled = false;\nfunction schedule_update() {\n    if (!update_scheduled) {\n        update_scheduled = true;\n        resolved_promise.then(flush);\n    }\n}\nfunction add_render_callback(fn) {\n    render_callbacks.push(fn);\n}\nfunction add_flush_callback(fn) {\n    flush_callbacks.push(fn);\n}\nlet flushing = false;\nconst seen_callbacks = new Set();\nfunction flush() {\n    if (flushing)\n        return;\n    flushing = true;\n    do {\n        // first, call beforeUpdate functions\n        // and update components\n        for (let i = 0; i < dirty_components.length; i += 1) {\n            const component = dirty_components[i];\n            set_current_component(component);\n            update(component.$$);\n        }\n        dirty_components.length = 0;\n        while (binding_callbacks.length)\n            binding_callbacks.pop()();\n        // then, once components are updated, call\n        // afterUpdate functions. This may cause\n        // subsequent updates...\n        for (let i = 0; i < render_callbacks.length; i += 1) {\n            const callback = render_callbacks[i];\n            if (!seen_callbacks.has(callback)) {\n                // ...so guard against infinite loops\n                seen_callbacks.add(callback);\n                callback();\n            }\n        }\n        render_callbacks.length = 0;\n    } while (dirty_components.length);\n    while (flush_callbacks.length) {\n        flush_callbacks.pop()();\n    }\n    update_scheduled = false;\n    flushing = false;\n    seen_callbacks.clear();\n}\nfunction update($$) {\n    if ($$.fragment !== null) {\n        $$.update();\n        run_all($$.before_update);\n        const dirty = $$.dirty;\n        $$.dirty = [-1];\n        $$.fragment && $$.fragment.p($$.ctx, dirty);\n        $$.after_update.forEach(add_render_callback);\n    }\n}\nconst outroing = new Set();\nlet outros;\nfunction group_outros() {\n    outros = {\n        r: 0,\n        c: [],\n        p: outros // parent group\n    };\n}\nfunction check_outros() {\n    if (!outros.r) {\n        run_all(outros.c);\n    }\n    outros = outros.p;\n}\nfunction transition_in(block, local) {\n    if (block && block.i) {\n        outroing.delete(block);\n        block.i(local);\n    }\n}\nfunction transition_out(block, local, detach, callback) {\n    if (block && block.o) {\n        if (outroing.has(block))\n            return;\n        outroing.add(block);\n        outros.c.push(() => {\n            outroing.delete(block);\n            if (callback) {\n                if (detach)\n                    block.d(1);\n                callback();\n            }\n        });\n        block.o(local);\n    }\n}\nfunction outro_and_destroy_block(block, lookup) {\n    transition_out(block, 1, 1, () => {\n        lookup.delete(block.key);\n    });\n}\nfunction update_keyed_each(old_blocks, dirty, get_key, dynamic, ctx, list, lookup, node, destroy, create_each_block, next, get_context) {\n    let o = old_blocks.length;\n    let n = list.length;\n    let i = o;\n    const old_indexes = {};\n    while (i--)\n        old_indexes[old_blocks[i].key] = i;\n    const new_blocks = [];\n    const new_lookup = new Map();\n    const deltas = new Map();\n    i = n;\n    while (i--) {\n        const child_ctx = get_context(ctx, list, i);\n        const key = get_key(child_ctx);\n        let block = lookup.get(key);\n        if (!block) {\n            block = create_each_block(key, child_ctx);\n            block.c();\n        }\n        else if (dynamic) {\n            block.p(child_ctx, dirty);\n        }\n        new_lookup.set(key, new_blocks[i] = block);\n        if (key in old_indexes)\n            deltas.set(key, Math.abs(i - old_indexes[key]));\n    }\n    const will_move = new Set();\n    const did_move = new Set();\n    function insert(block) {\n        transition_in(block, 1);\n        block.m(node, next);\n        lookup.set(block.key, block);\n        next = block.first;\n        n--;\n    }\n    while (o && n) {\n        const new_block = new_blocks[n - 1];\n        const old_block = old_blocks[o - 1];\n        const new_key = new_block.key;\n        const old_key = old_block.key;\n        if (new_block === old_block) {\n            // do nothing\n            next = new_block.first;\n            o--;\n            n--;\n        }\n        else if (!new_lookup.has(old_key)) {\n            // remove old block\n            destroy(old_block, lookup);\n            o--;\n        }\n        else if (!lookup.has(new_key) || will_move.has(new_key)) {\n            insert(new_block);\n        }\n        else if (did_move.has(old_key)) {\n            o--;\n        }\n        else if (deltas.get(new_key) > deltas.get(old_key)) {\n            did_move.add(new_key);\n            insert(new_block);\n        }\n        else {\n            will_move.add(old_key);\n            o--;\n        }\n    }\n    while (o--) {\n        const old_block = old_blocks[o];\n        if (!new_lookup.has(old_block.key))\n            destroy(old_block, lookup);\n    }\n    while (n)\n        insert(new_blocks[n - 1]);\n    return new_blocks;\n}\n\nfunction get_spread_update(levels, updates) {\n    const update = {};\n    const to_null_out = {};\n    const accounted_for = { $$scope: 1 };\n    let i = levels.length;\n    while (i--) {\n        const o = levels[i];\n        const n = updates[i];\n        if (n) {\n            for (const key in o) {\n                if (!(key in n))\n                    to_null_out[key] = 1;\n            }\n            for (const key in n) {\n                if (!accounted_for[key]) {\n                    update[key] = n[key];\n                    accounted_for[key] = 1;\n                }\n            }\n            levels[i] = n;\n        }\n        else {\n            for (const key in o) {\n                accounted_for[key] = 1;\n            }\n        }\n    }\n    for (const key in to_null_out) {\n        if (!(key in update))\n            update[key] = undefined;\n    }\n    return update;\n}\nfunction get_spread_object(spread_props) {\n    return typeof spread_props === 'object' && spread_props !== null ? spread_props : {};\n}\n\nfunction bind(component, name, callback) {\n    const index = component.$$.props[name];\n    if (index !== undefined) {\n        component.$$.bound[index] = callback;\n        callback(component.$$.ctx[index]);\n    }\n}\nfunction create_component(block) {\n    block && block.c();\n}\nfunction claim_component(block, parent_nodes) {\n    block && block.l(parent_nodes);\n}\nfunction mount_component(component, target, anchor) {\n    const { fragment, on_mount, on_destroy, after_update } = component.$$;\n    fragment && fragment.m(target, anchor);\n    // onMount happens before the initial afterUpdate\n    add_render_callback(() => {\n        const new_on_destroy = on_mount.map(run).filter(is_function);\n        if (on_destroy) {\n            on_destroy.push(...new_on_destroy);\n        }\n        else {\n            // Edge case - component was destroyed immediately,\n            // most likely as a result of a binding initialising\n            run_all(new_on_destroy);\n        }\n        component.$$.on_mount = [];\n    });\n    after_update.forEach(add_render_callback);\n}\nfunction destroy_component(component, detaching) {\n    const $$ = component.$$;\n    if ($$.fragment !== null) {\n        run_all($$.on_destroy);\n        $$.fragment && $$.fragment.d(detaching);\n        // TODO null out other refs, including component.$$ (but need to\n        // preserve final state?)\n        $$.on_destroy = $$.fragment = null;\n        $$.ctx = [];\n    }\n}\nfunction make_dirty(component, i) {\n    if (component.$$.dirty[0] === -1) {\n        dirty_components.push(component);\n        schedule_update();\n        component.$$.dirty.fill(0);\n    }\n    component.$$.dirty[(i / 31) | 0] |= (1 << (i % 31));\n}\nfunction init(component, options, instance, create_fragment, not_equal, props, dirty = [-1]) {\n    const parent_component = current_component;\n    set_current_component(component);\n    const prop_values = options.props || {};\n    const $$ = component.$$ = {\n        fragment: null,\n        ctx: null,\n        // state\n        props,\n        update: noop,\n        not_equal,\n        bound: blank_object(),\n        // lifecycle\n        on_mount: [],\n        on_destroy: [],\n        before_update: [],\n        after_update: [],\n        context: new Map(parent_component ? parent_component.$$.context : []),\n        // everything else\n        callbacks: blank_object(),\n        dirty\n    };\n    let ready = false;\n    $$.ctx = instance\n        ? instance(component, prop_values, (i, ret, ...rest) => {\n            const value = rest.length ? rest[0] : ret;\n            if ($$.ctx && not_equal($$.ctx[i], $$.ctx[i] = value)) {\n                if ($$.bound[i])\n                    $$.bound[i](value);\n                if (ready)\n                    make_dirty(component, i);\n            }\n            return ret;\n        })\n        : [];\n    $$.update();\n    ready = true;\n    run_all($$.before_update);\n    // `false` as a special case of no DOM component\n    $$.fragment = create_fragment ? create_fragment($$.ctx) : false;\n    if (options.target) {\n        if (options.hydrate) {\n            const nodes = children(options.target);\n            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion\n            $$.fragment && $$.fragment.l(nodes);\n            nodes.forEach(detach);\n        }\n        else {\n            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion\n            $$.fragment && $$.fragment.c();\n        }\n        if (options.intro)\n            transition_in(component.$$.fragment);\n        mount_component(component, options.target, options.anchor);\n        flush();\n    }\n    set_current_component(parent_component);\n}\nclass SvelteComponent {\n    $destroy() {\n        destroy_component(this, 1);\n        this.$destroy = noop;\n    }\n    $on(type, callback) {\n        const callbacks = (this.$$.callbacks[type] || (this.$$.callbacks[type] = []));\n        callbacks.push(callback);\n        return () => {\n            const index = callbacks.indexOf(callback);\n            if (index !== -1)\n                callbacks.splice(index, 1);\n        };\n    }\n    $set() {\n        // overridden by instance, if it has props\n    }\n}\n\nconst subscriber_queue = [];\n/**\n * Create a `Writable` store that allows both updating and reading by subscription.\n * @param {*=}value initial value\n * @param {StartStopNotifier=}start start and stop notifications for subscriptions\n */\nfunction writable(value, start = noop) {\n    let stop;\n    const subscribers = [];\n    function set(new_value) {\n        if (safe_not_equal(value, new_value)) {\n            value = new_value;\n            if (stop) { // store is ready\n                const run_queue = !subscriber_queue.length;\n                for (let i = 0; i < subscribers.length; i += 1) {\n                    const s = subscribers[i];\n                    s[1]();\n                    subscriber_queue.push(s, value);\n                }\n                if (run_queue) {\n                    for (let i = 0; i < subscriber_queue.length; i += 2) {\n                        subscriber_queue[i][0](subscriber_queue[i + 1]);\n                    }\n                    subscriber_queue.length = 0;\n                }\n            }\n        }\n    }\n    function update(fn) {\n        set(fn(value));\n    }\n    function subscribe(run, invalidate = noop) {\n        const subscriber = [run, invalidate];\n        subscribers.push(subscriber);\n        if (subscribers.length === 1) {\n            stop = start(set) || noop;\n        }\n        run(value);\n        return () => {\n            const index = subscribers.indexOf(subscriber);\n            if (index !== -1) {\n                subscribers.splice(index, 1);\n            }\n            if (subscribers.length === 0) {\n                stop();\n                stop = null;\n            }\n        };\n    }\n    return { set, update, subscribe };\n}\n\nconst CONTEXT_KEY = {};\n\nconst preload = () => ({});\n\n/* src/routes/_components/Nav.svelte generated by Svelte v3.23.2 */\n\nfunction create_else_block(ctx) {\n\tlet li0;\n\tlet a0;\n\tlet t0;\n\tlet t1;\n\tlet li1;\n\tlet a1;\n\tlet t2;\n\n\treturn {\n\t\tc() {\n\t\t\tli0 = element(\"li\");\n\t\t\ta0 = element(\"a\");\n\t\t\tt0 = text(\"Sign in\");\n\t\t\tt1 = space();\n\t\t\tli1 = element(\"li\");\n\t\t\ta1 = element(\"a\");\n\t\t\tt2 = text(\"Sign up\");\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tli0 = claim_element(nodes, \"LI\", { class: true });\n\t\t\tvar li0_nodes = children(li0);\n\t\t\ta0 = claim_element(li0_nodes, \"A\", { rel: true, href: true, class: true });\n\t\t\tvar a0_nodes = children(a0);\n\t\t\tt0 = claim_text(a0_nodes, \"Sign in\");\n\t\t\ta0_nodes.forEach(detach);\n\t\t\tli0_nodes.forEach(detach);\n\t\t\tt1 = claim_space(nodes);\n\t\t\tli1 = claim_element(nodes, \"LI\", { class: true });\n\t\t\tvar li1_nodes = children(li1);\n\t\t\ta1 = claim_element(li1_nodes, \"A\", { rel: true, href: true, class: true });\n\t\t\tvar a1_nodes = children(a1);\n\t\t\tt2 = claim_text(a1_nodes, \"Sign up\");\n\t\t\ta1_nodes.forEach(detach);\n\t\t\tli1_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(a0, \"rel\", \"prefetch\");\n\t\t\tattr(a0, \"href\", \"/login\");\n\t\t\tattr(a0, \"class\", \"nav-link\");\n\t\t\ttoggle_class(a0, \"active\", /*$page*/ ctx[0].path === \"/login\");\n\t\t\tattr(li0, \"class\", \"nav-item\");\n\t\t\tattr(a1, \"rel\", \"prefetch\");\n\t\t\tattr(a1, \"href\", \"/register\");\n\t\t\tattr(a1, \"class\", \"nav-link\");\n\t\t\ttoggle_class(a1, \"active\", /*$page*/ ctx[0].path === \"/register\");\n\t\t\tattr(li1, \"class\", \"nav-item\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, li0, anchor);\n\t\t\tappend(li0, a0);\n\t\t\tappend(a0, t0);\n\t\t\tinsert(target, t1, anchor);\n\t\t\tinsert(target, li1, anchor);\n\t\t\tappend(li1, a1);\n\t\t\tappend(a1, t2);\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tif (dirty & /*$page*/ 1) {\n\t\t\t\ttoggle_class(a0, \"active\", /*$page*/ ctx[0].path === \"/login\");\n\t\t\t}\n\n\t\t\tif (dirty & /*$page*/ 1) {\n\t\t\t\ttoggle_class(a1, \"active\", /*$page*/ ctx[0].path === \"/register\");\n\t\t\t}\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(li0);\n\t\t\tif (detaching) detach(t1);\n\t\t\tif (detaching) detach(li1);\n\t\t}\n\t};\n}\n\n// (15:3) {#if $session.user}\nfunction create_if_block(ctx) {\n\tlet li0;\n\tlet a0;\n\tlet i0;\n\tlet t0;\n\tlet t1;\n\tlet li1;\n\tlet a1;\n\tlet i1;\n\tlet t2;\n\tlet t3;\n\tlet li2;\n\tlet a2;\n\tlet t4_value = /*$session*/ ctx[1].user.username + \"\";\n\tlet t4;\n\tlet a2_href_value;\n\n\treturn {\n\t\tc() {\n\t\t\tli0 = element(\"li\");\n\t\t\ta0 = element(\"a\");\n\t\t\ti0 = element(\"i\");\n\t\t\tt0 = text(\" New Post\");\n\t\t\tt1 = space();\n\t\t\tli1 = element(\"li\");\n\t\t\ta1 = element(\"a\");\n\t\t\ti1 = element(\"i\");\n\t\t\tt2 = text(\" Settings\");\n\t\t\tt3 = space();\n\t\t\tli2 = element(\"li\");\n\t\t\ta2 = element(\"a\");\n\t\t\tt4 = text(t4_value);\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tli0 = claim_element(nodes, \"LI\", { class: true });\n\t\t\tvar li0_nodes = children(li0);\n\t\t\ta0 = claim_element(li0_nodes, \"A\", { rel: true, href: true, class: true });\n\t\t\tvar a0_nodes = children(a0);\n\t\t\ti0 = claim_element(a0_nodes, \"I\", { class: true });\n\t\t\tchildren(i0).forEach(detach);\n\t\t\tt0 = claim_text(a0_nodes, \" New Post\");\n\t\t\ta0_nodes.forEach(detach);\n\t\t\tli0_nodes.forEach(detach);\n\t\t\tt1 = claim_space(nodes);\n\t\t\tli1 = claim_element(nodes, \"LI\", { class: true });\n\t\t\tvar li1_nodes = children(li1);\n\t\t\ta1 = claim_element(li1_nodes, \"A\", { rel: true, href: true, class: true });\n\t\t\tvar a1_nodes = children(a1);\n\t\t\ti1 = claim_element(a1_nodes, \"I\", { class: true });\n\t\t\tchildren(i1).forEach(detach);\n\t\t\tt2 = claim_text(a1_nodes, \" Settings\");\n\t\t\ta1_nodes.forEach(detach);\n\t\t\tli1_nodes.forEach(detach);\n\t\t\tt3 = claim_space(nodes);\n\t\t\tli2 = claim_element(nodes, \"LI\", { class: true });\n\t\t\tvar li2_nodes = children(li2);\n\t\t\ta2 = claim_element(li2_nodes, \"A\", { rel: true, href: true, class: true });\n\t\t\tvar a2_nodes = children(a2);\n\t\t\tt4 = claim_text(a2_nodes, t4_value);\n\t\t\ta2_nodes.forEach(detach);\n\t\t\tli2_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(i0, \"class\", \"ion-compose\");\n\t\t\tattr(a0, \"rel\", \"prefetch\");\n\t\t\tattr(a0, \"href\", \"/editor\");\n\t\t\tattr(a0, \"class\", \"nav-link\");\n\t\t\ttoggle_class(a0, \"active\", /*$page*/ ctx[0].path === \"/editor\");\n\t\t\tattr(li0, \"class\", \"nav-item\");\n\t\t\tattr(i1, \"class\", \"ion-gear-a\");\n\t\t\tattr(a1, \"rel\", \"prefetch\");\n\t\t\tattr(a1, \"href\", \"/settings\");\n\t\t\tattr(a1, \"class\", \"nav-link\");\n\t\t\ttoggle_class(a1, \"active\", /*$page*/ ctx[0].path === \"/settings\");\n\t\t\tattr(li1, \"class\", \"nav-item\");\n\t\t\tattr(a2, \"rel\", \"prefetch\");\n\t\t\tattr(a2, \"href\", a2_href_value = \"/profile/@\" + /*$session*/ ctx[1].user.username);\n\t\t\tattr(a2, \"class\", \"nav-link\");\n\t\t\tattr(li2, \"class\", \"nav-item\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, li0, anchor);\n\t\t\tappend(li0, a0);\n\t\t\tappend(a0, i0);\n\t\t\tappend(a0, t0);\n\t\t\tinsert(target, t1, anchor);\n\t\t\tinsert(target, li1, anchor);\n\t\t\tappend(li1, a1);\n\t\t\tappend(a1, i1);\n\t\t\tappend(a1, t2);\n\t\t\tinsert(target, t3, anchor);\n\t\t\tinsert(target, li2, anchor);\n\t\t\tappend(li2, a2);\n\t\t\tappend(a2, t4);\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tif (dirty & /*$page*/ 1) {\n\t\t\t\ttoggle_class(a0, \"active\", /*$page*/ ctx[0].path === \"/editor\");\n\t\t\t}\n\n\t\t\tif (dirty & /*$page*/ 1) {\n\t\t\t\ttoggle_class(a1, \"active\", /*$page*/ ctx[0].path === \"/settings\");\n\t\t\t}\n\n\t\t\tif (dirty & /*$session*/ 2 && t4_value !== (t4_value = /*$session*/ ctx[1].user.username + \"\")) set_data(t4, t4_value);\n\n\t\t\tif (dirty & /*$session*/ 2 && a2_href_value !== (a2_href_value = \"/profile/@\" + /*$session*/ ctx[1].user.username)) {\n\t\t\t\tattr(a2, \"href\", a2_href_value);\n\t\t\t}\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(li0);\n\t\t\tif (detaching) detach(t1);\n\t\t\tif (detaching) detach(li1);\n\t\t\tif (detaching) detach(t3);\n\t\t\tif (detaching) detach(li2);\n\t\t}\n\t};\n}\n\nfunction create_fragment(ctx) {\n\tlet nav;\n\tlet div;\n\tlet a0;\n\tlet t0;\n\tlet t1;\n\tlet ul;\n\tlet li;\n\tlet a1;\n\tlet t2;\n\tlet t3;\n\n\tfunction select_block_type(ctx, dirty) {\n\t\tif (/*$session*/ ctx[1].user) return create_if_block;\n\t\treturn create_else_block;\n\t}\n\n\tlet current_block_type = select_block_type(ctx);\n\tlet if_block = current_block_type(ctx);\n\n\treturn {\n\t\tc() {\n\t\t\tnav = element(\"nav\");\n\t\t\tdiv = element(\"div\");\n\t\t\ta0 = element(\"a\");\n\t\t\tt0 = text(\"conduit\");\n\t\t\tt1 = space();\n\t\t\tul = element(\"ul\");\n\t\t\tli = element(\"li\");\n\t\t\ta1 = element(\"a\");\n\t\t\tt2 = text(\"Home\");\n\t\t\tt3 = space();\n\t\t\tif_block.c();\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tnav = claim_element(nodes, \"NAV\", { class: true });\n\t\t\tvar nav_nodes = children(nav);\n\t\t\tdiv = claim_element(nav_nodes, \"DIV\", { class: true });\n\t\t\tvar div_nodes = children(div);\n\t\t\ta0 = claim_element(div_nodes, \"A\", { rel: true, class: true, href: true });\n\t\t\tvar a0_nodes = children(a0);\n\t\t\tt0 = claim_text(a0_nodes, \"conduit\");\n\t\t\ta0_nodes.forEach(detach);\n\t\t\tt1 = claim_space(div_nodes);\n\t\t\tul = claim_element(div_nodes, \"UL\", { class: true });\n\t\t\tvar ul_nodes = children(ul);\n\t\t\tli = claim_element(ul_nodes, \"LI\", { class: true });\n\t\t\tvar li_nodes = children(li);\n\t\t\ta1 = claim_element(li_nodes, \"A\", { rel: true, class: true, href: true });\n\t\t\tvar a1_nodes = children(a1);\n\t\t\tt2 = claim_text(a1_nodes, \"Home\");\n\t\t\ta1_nodes.forEach(detach);\n\t\t\tli_nodes.forEach(detach);\n\t\t\tt3 = claim_space(ul_nodes);\n\t\t\tif_block.l(ul_nodes);\n\t\t\tul_nodes.forEach(detach);\n\t\t\tdiv_nodes.forEach(detach);\n\t\t\tnav_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(a0, \"rel\", \"prefetch\");\n\t\t\tattr(a0, \"class\", \"navbar-brand\");\n\t\t\tattr(a0, \"href\", \".\");\n\t\t\tattr(a1, \"rel\", \"prefetch\");\n\t\t\tattr(a1, \"class\", \"nav-link\");\n\t\t\tattr(a1, \"href\", \"/\");\n\t\t\ttoggle_class(a1, \"active\", /*$page*/ ctx[0].path === \"/\");\n\t\t\tattr(li, \"class\", \"nav-item\");\n\t\t\tattr(ul, \"class\", \"nav navbar-nav pull-xs-right\");\n\t\t\tattr(div, \"class\", \"container\");\n\t\t\tattr(nav, \"class\", \"navbar navbar-light\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, nav, anchor);\n\t\t\tappend(nav, div);\n\t\t\tappend(div, a0);\n\t\t\tappend(a0, t0);\n\t\t\tappend(div, t1);\n\t\t\tappend(div, ul);\n\t\t\tappend(ul, li);\n\t\t\tappend(li, a1);\n\t\t\tappend(a1, t2);\n\t\t\tappend(ul, t3);\n\t\t\tif_block.m(ul, null);\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tif (dirty & /*$page*/ 1) {\n\t\t\t\ttoggle_class(a1, \"active\", /*$page*/ ctx[0].path === \"/\");\n\t\t\t}\n\n\t\t\tif (current_block_type === (current_block_type = select_block_type(ctx)) && if_block) {\n\t\t\t\tif_block.p(ctx, dirty);\n\t\t\t} else {\n\t\t\t\tif_block.d(1);\n\t\t\t\tif_block = current_block_type(ctx);\n\n\t\t\t\tif (if_block) {\n\t\t\t\t\tif_block.c();\n\t\t\t\t\tif_block.m(ul, null);\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\ti: noop,\n\t\to: noop,\n\t\td(detaching) {\n\t\t\tif (detaching) detach(nav);\n\t\t\tif_block.d();\n\t\t}\n\t};\n}\n\nfunction instance($$self, $$props, $$invalidate) {\n\tlet $page;\n\tlet $session;\n\tconst { page, session } = stores$1();\n\tcomponent_subscribe($$self, page, value => $$invalidate(0, $page = value));\n\tcomponent_subscribe($$self, session, value => $$invalidate(1, $session = value));\n\treturn [$page, $session, page, session];\n}\n\nclass Nav extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance, create_fragment, safe_not_equal, {});\n\t}\n}\n\n/* src/routes/_layout.svelte generated by Svelte v3.23.2 */\n\nfunction create_fragment$1(ctx) {\n\tlet nav;\n\tlet t;\n\tlet main;\n\tlet current;\n\tnav = new Nav({ props: { segment: /*segment*/ ctx[0] } });\n\tconst default_slot_template = /*$$slots*/ ctx[2].default;\n\tconst default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[1], null);\n\n\treturn {\n\t\tc() {\n\t\t\tcreate_component(nav.$$.fragment);\n\t\t\tt = space();\n\t\t\tmain = element(\"main\");\n\t\t\tif (default_slot) default_slot.c();\n\t\t},\n\t\tl(nodes) {\n\t\t\tclaim_component(nav.$$.fragment, nodes);\n\t\t\tt = claim_space(nodes);\n\t\t\tmain = claim_element(nodes, \"MAIN\", {});\n\t\t\tvar main_nodes = children(main);\n\t\t\tif (default_slot) default_slot.l(main_nodes);\n\t\t\tmain_nodes.forEach(detach);\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tmount_component(nav, target, anchor);\n\t\t\tinsert(target, t, anchor);\n\t\t\tinsert(target, main, anchor);\n\n\t\t\tif (default_slot) {\n\t\t\t\tdefault_slot.m(main, null);\n\t\t\t}\n\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tconst nav_changes = {};\n\t\t\tif (dirty & /*segment*/ 1) nav_changes.segment = /*segment*/ ctx[0];\n\t\t\tnav.$set(nav_changes);\n\n\t\t\tif (default_slot) {\n\t\t\t\tif (default_slot.p && dirty & /*$$scope*/ 2) {\n\t\t\t\t\tupdate_slot(default_slot, default_slot_template, ctx, /*$$scope*/ ctx[1], dirty, null, null);\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(nav.$$.fragment, local);\n\t\t\ttransition_in(default_slot, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(nav.$$.fragment, local);\n\t\t\ttransition_out(default_slot, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tdestroy_component(nav, detaching);\n\t\t\tif (detaching) detach(t);\n\t\t\tif (detaching) detach(main);\n\t\t\tif (default_slot) default_slot.d(detaching);\n\t\t}\n\t};\n}\n\nfunction instance$1($$self, $$props, $$invalidate) {\n\tlet { segment } = $$props;\n\tlet { $$slots = {}, $$scope } = $$props;\n\n\t$$self.$set = $$props => {\n\t\tif (\"segment\" in $$props) $$invalidate(0, segment = $$props.segment);\n\t\tif (\"$$scope\" in $$props) $$invalidate(1, $$scope = $$props.$$scope);\n\t};\n\n\treturn [segment, $$scope, $$slots];\n}\n\nclass Layout extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance$1, create_fragment$1, safe_not_equal, { segment: 0 });\n\t}\n}\n\n/* src/routes/_error.svelte generated by Svelte v3.23.2 */\n\nfunction create_if_block$1(ctx) {\n\tlet pre;\n\tlet t_value = /*error*/ ctx[0].stack + \"\";\n\tlet t;\n\n\treturn {\n\t\tc() {\n\t\t\tpre = element(\"pre\");\n\t\t\tt = text(t_value);\n\t\t},\n\t\tl(nodes) {\n\t\t\tpre = claim_element(nodes, \"PRE\", {});\n\t\t\tvar pre_nodes = children(pre);\n\t\t\tt = claim_text(pre_nodes, t_value);\n\t\t\tpre_nodes.forEach(detach);\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, pre, anchor);\n\t\t\tappend(pre, t);\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tif (dirty & /*error*/ 1 && t_value !== (t_value = /*error*/ ctx[0].stack + \"\")) set_data(t, t_value);\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(pre);\n\t\t}\n\t};\n}\n\nfunction create_fragment$2(ctx) {\n\tlet title_value;\n\tlet t0;\n\tlet h1;\n\tlet t1;\n\tlet t2;\n\tlet p;\n\tlet t3_value = /*error*/ ctx[0].message + \"\";\n\tlet t3;\n\tlet t4;\n\tlet if_block_anchor;\n\tdocument.title = title_value = /*status*/ ctx[1];\n\tlet if_block = /*dev*/ ctx[2] && /*error*/ ctx[0].stack && create_if_block$1(ctx);\n\n\treturn {\n\t\tc() {\n\t\t\tt0 = space();\n\t\t\th1 = element(\"h1\");\n\t\t\tt1 = text(/*status*/ ctx[1]);\n\t\t\tt2 = space();\n\t\t\tp = element(\"p\");\n\t\t\tt3 = text(t3_value);\n\t\t\tt4 = space();\n\t\t\tif (if_block) if_block.c();\n\t\t\tif_block_anchor = empty();\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tconst head_nodes = query_selector_all(\"[data-svelte=\\\"svelte-1o9r2ue\\\"]\", document.head);\n\t\t\thead_nodes.forEach(detach);\n\t\t\tt0 = claim_space(nodes);\n\t\t\th1 = claim_element(nodes, \"H1\", { class: true });\n\t\t\tvar h1_nodes = children(h1);\n\t\t\tt1 = claim_text(h1_nodes, /*status*/ ctx[1]);\n\t\t\th1_nodes.forEach(detach);\n\t\t\tt2 = claim_space(nodes);\n\t\t\tp = claim_element(nodes, \"P\", { class: true });\n\t\t\tvar p_nodes = children(p);\n\t\t\tt3 = claim_text(p_nodes, t3_value);\n\t\t\tp_nodes.forEach(detach);\n\t\t\tt4 = claim_space(nodes);\n\t\t\tif (if_block) if_block.l(nodes);\n\t\t\tif_block_anchor = empty();\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(h1, \"class\", \"svelte-8lferx\");\n\t\t\tattr(p, \"class\", \"svelte-8lferx\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, t0, anchor);\n\t\t\tinsert(target, h1, anchor);\n\t\t\tappend(h1, t1);\n\t\t\tinsert(target, t2, anchor);\n\t\t\tinsert(target, p, anchor);\n\t\t\tappend(p, t3);\n\t\t\tinsert(target, t4, anchor);\n\t\t\tif (if_block) if_block.m(target, anchor);\n\t\t\tinsert(target, if_block_anchor, anchor);\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tif (dirty & /*status*/ 2 && title_value !== (title_value = /*status*/ ctx[1])) {\n\t\t\t\tdocument.title = title_value;\n\t\t\t}\n\n\t\t\tif (dirty & /*status*/ 2) set_data(t1, /*status*/ ctx[1]);\n\t\t\tif (dirty & /*error*/ 1 && t3_value !== (t3_value = /*error*/ ctx[0].message + \"\")) set_data(t3, t3_value);\n\n\t\t\tif (/*dev*/ ctx[2] && /*error*/ ctx[0].stack) {\n\t\t\t\tif (if_block) {\n\t\t\t\t\tif_block.p(ctx, dirty);\n\t\t\t\t} else {\n\t\t\t\t\tif_block = create_if_block$1(ctx);\n\t\t\t\t\tif_block.c();\n\t\t\t\t\tif_block.m(if_block_anchor.parentNode, if_block_anchor);\n\t\t\t\t}\n\t\t\t} else if (if_block) {\n\t\t\t\tif_block.d(1);\n\t\t\t\tif_block = null;\n\t\t\t}\n\t\t},\n\t\ti: noop,\n\t\to: noop,\n\t\td(detaching) {\n\t\t\tif (detaching) detach(t0);\n\t\t\tif (detaching) detach(h1);\n\t\t\tif (detaching) detach(t2);\n\t\t\tif (detaching) detach(p);\n\t\t\tif (detaching) detach(t4);\n\t\t\tif (if_block) if_block.d(detaching);\n\t\t\tif (detaching) detach(if_block_anchor);\n\t\t}\n\t};\n}\n\nfunction instance$2($$self, $$props, $$invalidate) {\n\tlet { error } = $$props, { status } = $$props;\n\tlet dev = undefined === \"development\";\n\n\t$$self.$set = $$props => {\n\t\tif (\"error\" in $$props) $$invalidate(0, error = $$props.error);\n\t\tif (\"status\" in $$props) $$invalidate(1, status = $$props.status);\n\t};\n\n\treturn [error, status, dev];\n}\n\nclass Error$1 extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance$2, create_fragment$2, safe_not_equal, { error: 0, status: 1 });\n\t}\n}\n\n/* src/node_modules/@sapper/internal/App.svelte generated by Svelte v3.23.2 */\n\nfunction create_else_block$1(ctx) {\n\tlet switch_instance;\n\tlet switch_instance_anchor;\n\tlet current;\n\tconst switch_instance_spread_levels = [/*level1*/ ctx[4].props];\n\tvar switch_value = /*level1*/ ctx[4].component;\n\n\tfunction switch_props(ctx) {\n\t\tlet switch_instance_props = {};\n\n\t\tfor (let i = 0; i < switch_instance_spread_levels.length; i += 1) {\n\t\t\tswitch_instance_props = assign(switch_instance_props, switch_instance_spread_levels[i]);\n\t\t}\n\n\t\treturn { props: switch_instance_props };\n\t}\n\n\tif (switch_value) {\n\t\tswitch_instance = new switch_value(switch_props());\n\t}\n\n\treturn {\n\t\tc() {\n\t\t\tif (switch_instance) create_component(switch_instance.$$.fragment);\n\t\t\tswitch_instance_anchor = empty();\n\t\t},\n\t\tl(nodes) {\n\t\t\tif (switch_instance) claim_component(switch_instance.$$.fragment, nodes);\n\t\t\tswitch_instance_anchor = empty();\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tif (switch_instance) {\n\t\t\t\tmount_component(switch_instance, target, anchor);\n\t\t\t}\n\n\t\t\tinsert(target, switch_instance_anchor, anchor);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tconst switch_instance_changes = (dirty & /*level1*/ 16)\n\t\t\t? get_spread_update(switch_instance_spread_levels, [get_spread_object(/*level1*/ ctx[4].props)])\n\t\t\t: {};\n\n\t\t\tif (switch_value !== (switch_value = /*level1*/ ctx[4].component)) {\n\t\t\t\tif (switch_instance) {\n\t\t\t\t\tgroup_outros();\n\t\t\t\t\tconst old_component = switch_instance;\n\n\t\t\t\t\ttransition_out(old_component.$$.fragment, 1, 0, () => {\n\t\t\t\t\t\tdestroy_component(old_component, 1);\n\t\t\t\t\t});\n\n\t\t\t\t\tcheck_outros();\n\t\t\t\t}\n\n\t\t\t\tif (switch_value) {\n\t\t\t\t\tswitch_instance = new switch_value(switch_props());\n\t\t\t\t\tcreate_component(switch_instance.$$.fragment);\n\t\t\t\t\ttransition_in(switch_instance.$$.fragment, 1);\n\t\t\t\t\tmount_component(switch_instance, switch_instance_anchor.parentNode, switch_instance_anchor);\n\t\t\t\t} else {\n\t\t\t\t\tswitch_instance = null;\n\t\t\t\t}\n\t\t\t} else if (switch_value) {\n\t\t\t\tswitch_instance.$set(switch_instance_changes);\n\t\t\t}\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\tif (switch_instance) transition_in(switch_instance.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\tif (switch_instance) transition_out(switch_instance.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(switch_instance_anchor);\n\t\t\tif (switch_instance) destroy_component(switch_instance, detaching);\n\t\t}\n\t};\n}\n\n// (21:1) {#if error}\nfunction create_if_block$2(ctx) {\n\tlet error_1;\n\tlet current;\n\n\terror_1 = new Error$1({\n\t\t\tprops: {\n\t\t\t\terror: /*error*/ ctx[0],\n\t\t\t\tstatus: /*status*/ ctx[1]\n\t\t\t}\n\t\t});\n\n\treturn {\n\t\tc() {\n\t\t\tcreate_component(error_1.$$.fragment);\n\t\t},\n\t\tl(nodes) {\n\t\t\tclaim_component(error_1.$$.fragment, nodes);\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tmount_component(error_1, target, anchor);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tconst error_1_changes = {};\n\t\t\tif (dirty & /*error*/ 1) error_1_changes.error = /*error*/ ctx[0];\n\t\t\tif (dirty & /*status*/ 2) error_1_changes.status = /*status*/ ctx[1];\n\t\t\terror_1.$set(error_1_changes);\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(error_1.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(error_1.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tdestroy_component(error_1, detaching);\n\t\t}\n\t};\n}\n\n// (20:0) <Layout segment=\"{segments[0]}\" {...level0.props}>\nfunction create_default_slot(ctx) {\n\tlet current_block_type_index;\n\tlet if_block;\n\tlet if_block_anchor;\n\tlet current;\n\tconst if_block_creators = [create_if_block$2, create_else_block$1];\n\tconst if_blocks = [];\n\n\tfunction select_block_type(ctx, dirty) {\n\t\tif (/*error*/ ctx[0]) return 0;\n\t\treturn 1;\n\t}\n\n\tcurrent_block_type_index = select_block_type(ctx);\n\tif_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);\n\n\treturn {\n\t\tc() {\n\t\t\tif_block.c();\n\t\t\tif_block_anchor = empty();\n\t\t},\n\t\tl(nodes) {\n\t\t\tif_block.l(nodes);\n\t\t\tif_block_anchor = empty();\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tif_blocks[current_block_type_index].m(target, anchor);\n\t\t\tinsert(target, if_block_anchor, anchor);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tlet previous_block_index = current_block_type_index;\n\t\t\tcurrent_block_type_index = select_block_type(ctx);\n\n\t\t\tif (current_block_type_index === previous_block_index) {\n\t\t\t\tif_blocks[current_block_type_index].p(ctx, dirty);\n\t\t\t} else {\n\t\t\t\tgroup_outros();\n\n\t\t\t\ttransition_out(if_blocks[previous_block_index], 1, 1, () => {\n\t\t\t\t\tif_blocks[previous_block_index] = null;\n\t\t\t\t});\n\n\t\t\t\tcheck_outros();\n\t\t\t\tif_block = if_blocks[current_block_type_index];\n\n\t\t\t\tif (!if_block) {\n\t\t\t\t\tif_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);\n\t\t\t\t\tif_block.c();\n\t\t\t\t}\n\n\t\t\t\ttransition_in(if_block, 1);\n\t\t\t\tif_block.m(if_block_anchor.parentNode, if_block_anchor);\n\t\t\t}\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(if_block);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(if_block);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif_blocks[current_block_type_index].d(detaching);\n\t\t\tif (detaching) detach(if_block_anchor);\n\t\t}\n\t};\n}\n\nfunction create_fragment$3(ctx) {\n\tlet layout;\n\tlet current;\n\tconst layout_spread_levels = [{ segment: /*segments*/ ctx[2][0] }, /*level0*/ ctx[3].props];\n\n\tlet layout_props = {\n\t\t$$slots: { default: [create_default_slot] },\n\t\t$$scope: { ctx }\n\t};\n\n\tfor (let i = 0; i < layout_spread_levels.length; i += 1) {\n\t\tlayout_props = assign(layout_props, layout_spread_levels[i]);\n\t}\n\n\tlayout = new Layout({ props: layout_props });\n\n\treturn {\n\t\tc() {\n\t\t\tcreate_component(layout.$$.fragment);\n\t\t},\n\t\tl(nodes) {\n\t\t\tclaim_component(layout.$$.fragment, nodes);\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tmount_component(layout, target, anchor);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tconst layout_changes = (dirty & /*segments, level0*/ 12)\n\t\t\t? get_spread_update(layout_spread_levels, [\n\t\t\t\t\tdirty & /*segments*/ 4 && { segment: /*segments*/ ctx[2][0] },\n\t\t\t\t\tdirty & /*level0*/ 8 && get_spread_object(/*level0*/ ctx[3].props)\n\t\t\t\t])\n\t\t\t: {};\n\n\t\t\tif (dirty & /*$$scope, error, status, level1*/ 147) {\n\t\t\t\tlayout_changes.$$scope = { dirty, ctx };\n\t\t\t}\n\n\t\t\tlayout.$set(layout_changes);\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(layout.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(layout.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tdestroy_component(layout, detaching);\n\t\t}\n\t};\n}\n\nfunction instance$3($$self, $$props, $$invalidate) {\n\tlet { stores } = $$props;\n\tlet { error } = $$props;\n\tlet { status } = $$props;\n\tlet { segments } = $$props;\n\tlet { level0 } = $$props;\n\tlet { level1 = null } = $$props;\n\tlet { notify } = $$props;\n\tafterUpdate(notify);\n\tsetContext(CONTEXT_KEY, stores);\n\n\t$$self.$set = $$props => {\n\t\tif (\"stores\" in $$props) $$invalidate(5, stores = $$props.stores);\n\t\tif (\"error\" in $$props) $$invalidate(0, error = $$props.error);\n\t\tif (\"status\" in $$props) $$invalidate(1, status = $$props.status);\n\t\tif (\"segments\" in $$props) $$invalidate(2, segments = $$props.segments);\n\t\tif (\"level0\" in $$props) $$invalidate(3, level0 = $$props.level0);\n\t\tif (\"level1\" in $$props) $$invalidate(4, level1 = $$props.level1);\n\t\tif (\"notify\" in $$props) $$invalidate(6, notify = $$props.notify);\n\t};\n\n\treturn [error, status, segments, level0, level1, stores, notify];\n}\n\nclass App extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\n\t\tinit(this, options, instance$3, create_fragment$3, safe_not_equal, {\n\t\t\tstores: 5,\n\t\t\terror: 0,\n\t\t\tstatus: 1,\n\t\t\tsegments: 2,\n\t\t\tlevel0: 3,\n\t\t\tlevel1: 4,\n\t\t\tnotify: 6\n\t\t});\n\t}\n}\n\n// This file is generated by Sapper — do not edit it!\n\nconst ignore = [/^\\/auth\\/register\\/?$/, /^\\/auth\\/logout\\/?$/, /^\\/auth\\/login\\/?$/, /^\\/auth\\/save\\/?$/, /^\\/auth\\/user\\/?$/];\n\nconst components = [\n\t{\n\t\tjs: () => import('./index.4c114fc2.js'),\n\t\tcss: \"__SAPPER_CSS_PLACEHOLDER:index.svelte__\"\n\t},\n\t{\n\t\tjs: () => import('./index.38adfd86.js'),\n\t\tcss: \"__SAPPER_CSS_PLACEHOLDER:register/index.svelte__\"\n\t},\n\t{\n\t\tjs: () => import('./index.235c372d.js'),\n\t\tcss: \"__SAPPER_CSS_PLACEHOLDER:settings/index.svelte__\"\n\t},\n\t{\n\t\tjs: () => import('./[slug].52def5ad.js'),\n\t\tcss: \"__SAPPER_CSS_PLACEHOLDER:article/[slug].svelte__\"\n\t},\n\t{\n\t\tjs: () => import('./index.c18e65a8.js'),\n\t\tcss: \"__SAPPER_CSS_PLACEHOLDER:profile/index.svelte__\"\n\t},\n\t{\n\t\tjs: () => import('./index.18706821.js'),\n\t\tcss: \"__SAPPER_CSS_PLACEHOLDER:profile/[user]/index.svelte__\"\n\t},\n\t{\n\t\tjs: () => import('./[view].fb1d7ebc.js'),\n\t\tcss: \"__SAPPER_CSS_PLACEHOLDER:profile/[user]/[view].svelte__\"\n\t},\n\t{\n\t\tjs: () => import('./index.31aa2bf1.js'),\n\t\tcss: \"__SAPPER_CSS_PLACEHOLDER:editor/index.svelte__\"\n\t},\n\t{\n\t\tjs: () => import('./[slug].06001094.js'),\n\t\tcss: \"__SAPPER_CSS_PLACEHOLDER:editor/[slug].svelte__\"\n\t},\n\t{\n\t\tjs: () => import('./index.54a81c7b.js'),\n\t\tcss: \"__SAPPER_CSS_PLACEHOLDER:login/index.svelte__\"\n\t},\n\t{\n\t\tjs: () => import('./[p].449c37dd.js'),\n\t\tcss: \"__SAPPER_CSS_PLACEHOLDER:[p].svelte__\"\n\t}\n];\n\nconst routes = (d => [\n\t{\n\t\t// index.svelte\n\t\tpattern: /^\\/$/,\n\t\tparts: [\n\t\t\t{ i: 0 }\n\t\t]\n\t},\n\n\t{\n\t\t// register/index.svelte\n\t\tpattern: /^\\/register\\/?$/,\n\t\tparts: [\n\t\t\t{ i: 1 }\n\t\t]\n\t},\n\n\t{\n\t\t// settings/index.svelte\n\t\tpattern: /^\\/settings\\/?$/,\n\t\tparts: [\n\t\t\t{ i: 2 }\n\t\t]\n\t},\n\n\t{\n\t\t// article/[slug].svelte\n\t\tpattern: /^\\/article\\/([^\\/]+?)\\/?$/,\n\t\tparts: [\n\t\t\tnull,\n\t\t\t{ i: 3, params: match => ({ slug: d(match[1]) }) }\n\t\t]\n\t},\n\n\t{\n\t\t// profile/index.svelte\n\t\tpattern: /^\\/profile\\/?$/,\n\t\tparts: [\n\t\t\t{ i: 4 }\n\t\t]\n\t},\n\n\t{\n\t\t// profile/[user]/index.svelte\n\t\tpattern: /^\\/profile\\/([^\\/]+?)\\/?$/,\n\t\tparts: [\n\t\t\tnull,\n\t\t\t{ i: 5, params: match => ({ user: d(match[1]) }) }\n\t\t]\n\t},\n\n\t{\n\t\t// profile/[user]/[view].svelte\n\t\tpattern: /^\\/profile\\/([^\\/]+?)\\/([^\\/]+?)\\/?$/,\n\t\tparts: [\n\t\t\tnull,\n\t\t\tnull,\n\t\t\t{ i: 6, params: match => ({ user: d(match[1]), view: d(match[2]) }) }\n\t\t]\n\t},\n\n\t{\n\t\t// editor/index.svelte\n\t\tpattern: /^\\/editor\\/?$/,\n\t\tparts: [\n\t\t\t{ i: 7 }\n\t\t]\n\t},\n\n\t{\n\t\t// editor/[slug].svelte\n\t\tpattern: /^\\/editor\\/([^\\/]+?)\\/?$/,\n\t\tparts: [\n\t\t\tnull,\n\t\t\t{ i: 8, params: match => ({ slug: d(match[1]) }) }\n\t\t]\n\t},\n\n\t{\n\t\t// login/index.svelte\n\t\tpattern: /^\\/login\\/?$/,\n\t\tparts: [\n\t\t\t{ i: 9 }\n\t\t]\n\t},\n\n\t{\n\t\t// [p].svelte\n\t\tpattern: /^\\/([^\\/]+?)\\/?$/,\n\t\tparts: [\n\t\t\t{ i: 10, params: match => ({ p: d(match[1]) }) }\n\t\t]\n\t}\n])(decodeURIComponent);\n\nfunction goto(href, opts = { replaceState: false }) {\n\tconst target = select_target(new URL(href, document.baseURI));\n\n\tif (target) {\n\t\t_history[opts.replaceState ? 'replaceState' : 'pushState']({ id: cid }, '', href);\n\t\treturn navigate(target, null).then(() => {});\n\t}\n\n\tlocation.href = href;\n\treturn new Promise(f => {}); // never resolves\n}\n\n/** Callback to inform of a value updates. */\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nfunction page_store(value) {\n\tconst store = writable(value);\n\tlet ready = true;\n\n\tfunction notify() {\n\t\tready = true;\n\t\tstore.update(val => val);\n\t}\n\n\tfunction set(new_value) {\n\t\tready = false;\n\t\tstore.set(new_value);\n\t}\n\n\tfunction subscribe(run) {\n\t\tlet old_value;\n\t\treturn store.subscribe((value) => {\n\t\t\tif (old_value === undefined || (ready && value !== old_value)) {\n\t\t\t\trun(old_value = value);\n\t\t\t}\n\t\t});\n\t}\n\n\treturn { notify, set, subscribe };\n}\n\nconst initial_data = typeof __SAPPER__ !== 'undefined' && __SAPPER__;\n\nlet ready = false;\nlet root_component;\nlet current_token;\nlet root_preloaded;\nlet current_branch = [];\nlet current_query = '{}';\n\nconst stores = {\n\tpage: page_store({}),\n\tpreloading: writable(null),\n\tsession: writable(initial_data && initial_data.session)\n};\n\nlet $session;\nlet session_dirty;\n\nstores.session.subscribe(async value => {\n\t$session = value;\n\n\tif (!ready) return;\n\tsession_dirty = true;\n\n\tconst target = select_target(new URL(location.href));\n\n\tconst token = current_token = {};\n\tconst { redirect, props, branch } = await hydrate_target(target);\n\tif (token !== current_token) return; // a secondary navigation happened while we were loading\n\n\tawait render(redirect, branch, props, target.page);\n});\n\nlet prefetching\n\n\n = null;\nfunction set_prefetching(href, promise) {\n\tprefetching = { href, promise };\n}\n\nlet target;\nfunction set_target(element) {\n\ttarget = element;\n}\n\nlet uid = 1;\nfunction set_uid(n) {\n\tuid = n;\n}\n\nlet cid;\nfunction set_cid(n) {\n\tcid = n;\n}\n\nconst _history = typeof history !== 'undefined' ? history : {\n\tpushState: (state, title, href) => {},\n\treplaceState: (state, title, href) => {},\n\tscrollRestoration: ''\n};\n\nconst scroll_history = {};\n\nfunction extract_query(search) {\n\tconst query = Object.create(null);\n\tif (search.length > 0) {\n\t\tsearch.slice(1).split('&').forEach(searchParam => {\n\t\t\tlet [, key, value = ''] = /([^=]*)(?:=(.*))?/.exec(decodeURIComponent(searchParam.replace(/\\+/g, ' ')));\n\t\t\tif (typeof query[key] === 'string') query[key] = [query[key]];\n\t\t\tif (typeof query[key] === 'object') (query[key] ).push(value);\n\t\t\telse query[key] = value;\n\t\t});\n\t}\n\treturn query;\n}\n\nfunction select_target(url) {\n\tif (url.origin !== location.origin) return null;\n\tif (!url.pathname.startsWith(initial_data.baseUrl)) return null;\n\n\tlet path = url.pathname.slice(initial_data.baseUrl.length);\n\n\tif (path === '') {\n\t\tpath = '/';\n\t}\n\n\t// avoid accidental clashes between server routes and page routes\n\tif (ignore.some(pattern => pattern.test(path))) return;\n\n\tfor (let i = 0; i < routes.length; i += 1) {\n\t\tconst route = routes[i];\n\n\t\tconst match = route.pattern.exec(path);\n\n\t\tif (match) {\n\t\t\tconst query = extract_query(url.search);\n\t\t\tconst part = route.parts[route.parts.length - 1];\n\t\t\tconst params = part.params ? part.params(match) : {};\n\n\t\t\tconst page = { host: location.host, path, query, params };\n\n\t\t\treturn { href: url.href, route, match, page };\n\t\t}\n\t}\n}\n\nfunction handle_error(url) {\n\tconst { host, pathname, search } = location;\n\tconst { session, preloaded, status, error } = initial_data;\n\n\tif (!root_preloaded) {\n\t\troot_preloaded = preloaded && preloaded[0];\n\t}\n\n\tconst props = {\n\t\terror,\n\t\tstatus,\n\t\tsession,\n\t\tlevel0: {\n\t\t\tprops: root_preloaded\n\t\t},\n\t\tlevel1: {\n\t\t\tprops: {\n\t\t\t\tstatus,\n\t\t\t\terror\n\t\t\t},\n\t\t\tcomponent: Error$1\n\t\t},\n\t\tsegments: preloaded\n\n\t};\n\tconst query = extract_query(search);\n\trender(null, [], props, { host, path: pathname, query, params: {} });\n}\n\nfunction scroll_state() {\n\treturn {\n\t\tx: pageXOffset,\n\t\ty: pageYOffset\n\t};\n}\n\nasync function navigate(target, id, noscroll, hash) {\n\tif (id) {\n\t\t// popstate or initial navigation\n\t\tcid = id;\n\t} else {\n\t\tconst current_scroll = scroll_state();\n\n\t\t// clicked on a link. preserve scroll state\n\t\tscroll_history[cid] = current_scroll;\n\n\t\tid = cid = ++uid;\n\t\tscroll_history[cid] = noscroll ? current_scroll : { x: 0, y: 0 };\n\t}\n\n\tcid = id;\n\n\tif (root_component) stores.preloading.set(true);\n\n\tconst loaded = prefetching && prefetching.href === target.href ?\n\t\tprefetching.promise :\n\t\thydrate_target(target);\n\n\tprefetching = null;\n\n\tconst token = current_token = {};\n\tconst { redirect, props, branch } = await loaded;\n\tif (token !== current_token) return; // a secondary navigation happened while we were loading\n\n\tawait render(redirect, branch, props, target.page);\n\tif (document.activeElement) document.activeElement.blur();\n\n\tif (!noscroll) {\n\t\tlet scroll = scroll_history[id];\n\n\t\tif (hash) {\n\t\t\t// scroll is an element id (from a hash), we need to compute y.\n\t\t\tconst deep_linked = document.getElementById(hash.slice(1));\n\n\t\t\tif (deep_linked) {\n\t\t\t\tscroll = {\n\t\t\t\t\tx: 0,\n\t\t\t\t\ty: deep_linked.getBoundingClientRect().top + scrollY\n\t\t\t\t};\n\t\t\t}\n\t\t}\n\n\t\tscroll_history[cid] = scroll;\n\t\tif (scroll) scrollTo(scroll.x, scroll.y);\n\t}\n}\n\nasync function render(redirect, branch, props, page) {\n\tif (redirect) return goto(redirect.location, { replaceState: true });\n\n\tstores.page.set(page);\n\tstores.preloading.set(false);\n\n\tif (root_component) {\n\t\troot_component.$set(props);\n\t} else {\n\t\tprops.stores = {\n\t\t\tpage: { subscribe: stores.page.subscribe },\n\t\t\tpreloading: { subscribe: stores.preloading.subscribe },\n\t\t\tsession: stores.session\n\t\t};\n\t\tprops.level0 = {\n\t\t\tprops: await root_preloaded\n\t\t};\n\t\tprops.notify = stores.page.notify;\n\n\t\t// first load — remove SSR'd <head> contents\n\t\tconst start = document.querySelector('#sapper-head-start');\n\t\tconst end = document.querySelector('#sapper-head-end');\n\n\t\tif (start && end) {\n\t\t\twhile (start.nextSibling !== end) detach$1(start.nextSibling);\n\t\t\tdetach$1(start);\n\t\t\tdetach$1(end);\n\t\t}\n\n\t\troot_component = new App({\n\t\t\ttarget,\n\t\t\tprops,\n\t\t\thydrate: true\n\t\t});\n\t}\n\n\tcurrent_branch = branch;\n\tcurrent_query = JSON.stringify(page.query);\n\tready = true;\n\tsession_dirty = false;\n}\n\nfunction part_changed(i, segment, match, stringified_query) {\n\t// TODO only check query string changes for preload functions\n\t// that do in fact depend on it (using static analysis or\n\t// runtime instrumentation)\n\tif (stringified_query !== current_query) return true;\n\n\tconst previous = current_branch[i];\n\n\tif (!previous) return false;\n\tif (segment !== previous.segment) return true;\n\tif (previous.match) {\n\t\tif (JSON.stringify(previous.match.slice(1, i + 2)) !== JSON.stringify(match.slice(1, i + 2))) {\n\t\t\treturn true;\n\t\t}\n\t}\n}\n\nasync function hydrate_target(target)\n\n\n\n {\n\tconst { route, page } = target;\n\tconst segments = page.path.split('/').filter(Boolean);\n\n\tlet redirect = null;\n\n\tconst props = { error: null, status: 200, segments: [segments[0]] };\n\n\tconst preload_context = {\n\t\tfetch: (url, opts) => fetch(url, opts),\n\t\tredirect: (statusCode, location) => {\n\t\t\tif (redirect && (redirect.statusCode !== statusCode || redirect.location !== location)) {\n\t\t\t\tthrow new Error(`Conflicting redirects`);\n\t\t\t}\n\t\t\tredirect = { statusCode, location };\n\t\t},\n\t\terror: (status, error) => {\n\t\t\tprops.error = typeof error === 'string' ? new Error(error) : error;\n\t\t\tprops.status = status;\n\t\t}\n\t};\n\n\tif (!root_preloaded) {\n\t\troot_preloaded = initial_data.preloaded[0] || preload.call(preload_context, {\n\t\t\thost: page.host,\n\t\t\tpath: page.path,\n\t\t\tquery: page.query,\n\t\t\tparams: {}\n\t\t}, $session);\n\t}\n\n\tlet branch;\n\tlet l = 1;\n\n\ttry {\n\t\tconst stringified_query = JSON.stringify(page.query);\n\t\tconst match = route.pattern.exec(page.path);\n\n\t\tlet segment_dirty = false;\n\n\t\tbranch = await Promise.all(route.parts.map(async (part, i) => {\n\t\t\tconst segment = segments[i];\n\n\t\t\tif (part_changed(i, segment, match, stringified_query)) segment_dirty = true;\n\n\t\t\tprops.segments[l] = segments[i + 1]; // TODO make this less confusing\n\t\t\tif (!part) return { segment };\n\n\t\t\tconst j = l++;\n\n\t\t\tif (!session_dirty && !segment_dirty && current_branch[i] && current_branch[i].part === part.i) {\n\t\t\t\treturn current_branch[i];\n\t\t\t}\n\n\t\t\tsegment_dirty = false;\n\n\t\t\tconst { default: component, preload } = await load_component(components[part.i]);\n\n\t\t\tlet preloaded;\n\t\t\tif (ready || !initial_data.preloaded[i + 1]) {\n\t\t\t\tpreloaded = preload\n\t\t\t\t\t? await preload.call(preload_context, {\n\t\t\t\t\t\thost: page.host,\n\t\t\t\t\t\tpath: page.path,\n\t\t\t\t\t\tquery: page.query,\n\t\t\t\t\t\tparams: part.params ? part.params(target.match) : {}\n\t\t\t\t\t}, $session)\n\t\t\t\t\t: {};\n\t\t\t} else {\n\t\t\t\tpreloaded = initial_data.preloaded[i + 1];\n\t\t\t}\n\n\t\t\treturn (props[`level${j}`] = { component, props: preloaded, segment, match, part: part.i });\n\t\t}));\n\t} catch (error) {\n\t\tprops.error = error;\n\t\tprops.status = 500;\n\t\tbranch = [];\n\t}\n\n\treturn { redirect, props, branch };\n}\n\nfunction load_css(chunk) {\n\tconst href = `client/${chunk}`;\n\tif (document.querySelector(`link[href=\"${href}\"]`)) return;\n\n\treturn new Promise((fulfil, reject) => {\n\t\tconst link = document.createElement('link');\n\t\tlink.rel = 'stylesheet';\n\t\tlink.href = href;\n\n\t\tlink.onload = () => fulfil();\n\t\tlink.onerror = reject;\n\n\t\tdocument.head.appendChild(link);\n\t});\n}\n\nfunction load_component(component)\n\n\n {\n\t// TODO this is temporary — once placeholders are\n\t// always rewritten, scratch the ternary\n\tconst promises = (typeof component.css === 'string' ? [] : component.css.map(load_css));\n\tpromises.unshift(component.js());\n\treturn Promise.all(promises).then(values => values[0]);\n}\n\nfunction detach$1(node) {\n\tnode.parentNode.removeChild(node);\n}\n\nfunction prefetch(href) {\n\tconst target = select_target(new URL(href, document.baseURI));\n\n\tif (target) {\n\t\tif (!prefetching || href !== prefetching.href) {\n\t\t\tset_prefetching(href, hydrate_target(target));\n\t\t}\n\n\t\treturn prefetching.promise;\n\t}\n}\n\nfunction start(opts\n\n) {\n\tif ('scrollRestoration' in _history) {\n\t\t_history.scrollRestoration = 'manual';\n\t}\n\t\n\t// Adopted from Nuxt.js\n\t// Reset scrollRestoration to auto when leaving page, allowing page reload\n\t// and back-navigation from other pages to use the browser to restore the\n\t// scrolling position.\n\taddEventListener('beforeunload', () => {\n\t\t_history.scrollRestoration = 'auto';\n\t});\n\n\t// Setting scrollRestoration to manual again when returning to this page.\n\taddEventListener('load', () => {\n\t\t_history.scrollRestoration = 'manual';\n\t});\n\n\tset_target(opts.target);\n\n\taddEventListener('click', handle_click);\n\taddEventListener('popstate', handle_popstate);\n\n\t// prefetch\n\taddEventListener('touchstart', trigger_prefetch);\n\taddEventListener('mousemove', handle_mousemove);\n\n\treturn Promise.resolve().then(() => {\n\t\tconst { hash, href } = location;\n\n\t\t_history.replaceState({ id: uid }, '', href);\n\n\t\tconst url = new URL(location.href);\n\n\t\tif (initial_data.error) return handle_error();\n\n\t\tconst target = select_target(url);\n\t\tif (target) return navigate(target, uid, true, hash);\n\t});\n}\n\nlet mousemove_timeout;\n\nfunction handle_mousemove(event) {\n\tclearTimeout(mousemove_timeout);\n\tmousemove_timeout = setTimeout(() => {\n\t\ttrigger_prefetch(event);\n\t}, 20);\n}\n\nfunction trigger_prefetch(event) {\n\tconst a = find_anchor(event.target);\n\tif (!a || a.rel !== 'prefetch') return;\n\n\tprefetch(a.href);\n}\n\nfunction handle_click(event) {\n\t// Adapted from https://github.com/visionmedia/page.js\n\t// MIT license https://github.com/visionmedia/page.js#license\n\tif (which(event) !== 1) return;\n\tif (event.metaKey || event.ctrlKey || event.shiftKey) return;\n\tif (event.defaultPrevented) return;\n\n\tconst a = find_anchor(event.target);\n\tif (!a) return;\n\n\tif (!a.href) return;\n\n\t// check if link is inside an svg\n\t// in this case, both href and target are always inside an object\n\tconst svg = typeof a.href === 'object' && a.href.constructor.name === 'SVGAnimatedString';\n\tconst href = String(svg ? (a).href.baseVal : a.href);\n\n\tif (href === location.href) {\n\t\tif (!location.hash) event.preventDefault();\n\t\treturn;\n\t}\n\n\t// Ignore if tag has\n\t// 1. 'download' attribute\n\t// 2. rel='external' attribute\n\tif (a.hasAttribute('download') || a.getAttribute('rel') === 'external') return;\n\n\t// Ignore if <a> has a target\n\tif (svg ? (a).target.baseVal : a.target) return;\n\n\tconst url = new URL(href);\n\n\t// Don't handle hash changes\n\tif (url.pathname === location.pathname && url.search === location.search) return;\n\n\tconst target = select_target(url);\n\tif (target) {\n\t\tconst noscroll = a.hasAttribute('sapper-noscroll');\n\t\tnavigate(target, null, noscroll, url.hash);\n\t\tevent.preventDefault();\n\t\t_history.pushState({ id: cid }, '', url.href);\n\t}\n}\n\nfunction which(event) {\n\treturn event.which === null ? event.button : event.which;\n}\n\nfunction find_anchor(node) {\n\twhile (node && node.nodeName.toUpperCase() !== 'A') node = node.parentNode; // SVG <a> elements have a lowercase name\n\treturn node;\n}\n\nfunction handle_popstate(event) {\n\tscroll_history[cid] = scroll_state();\n\n\tif (event.state) {\n\t\tconst url = new URL(location.href);\n\t\tconst target = select_target(url);\n\t\tif (target) {\n\t\t\tnavigate(target, event.state.id);\n\t\t} else {\n\t\t\tlocation.href = location.href;\n\t\t}\n\t} else {\n\t\t// hashchange\n\t\tset_uid(uid + 1);\n\t\tset_cid(uid);\n\t\t_history.replaceState({ id: cid }, '', location.href);\n\t}\n}\n\nconst stores$1 = () => getContext(CONTEXT_KEY);\n\nstart({\n\ttarget: document.querySelector('#sapper'),\n});\n\nexport { destroy_each as A, binding_callbacks as B, bind as C, query_selector_all as D, add_flush_callback as E, onMount as F, group_outros as G, check_outros as H, update_keyed_each as I, outro_and_destroy_block as J, set_input_value as K, prevent_default as L, run_all as M, set_store_value as N, goto as O, assign as P, get_spread_update as Q, get_spread_object as R, SvelteComponent as S, action_destroyer as T, claim_component as a, transition_out as b, create_component as c, destroy_component as d, element as e, space as f, text as g, claim_element as h, init as i, children as j, detach as k, claim_space as l, mount_component as m, noop as n, claim_text as o, attr as p, insert as q, append as r, safe_not_equal as s, transition_in as t, listen as u, set_data as v, stores$1 as w, component_subscribe as x, empty as y, createEventDispatcher as z };\n",
      "dynamicImports":[
         "index.4c114fc2.js",
         "index.38adfd86.js",
         "index.235c372d.js",
         "[slug].52def5ad.js",
         "index.c18e65a8.js",
         "index.18706821.js",
         "[view].fb1d7ebc.js",
         "index.31aa2bf1.js",
         "[slug].06001094.js",
         "index.54a81c7b.js",
         "[p].449c37dd.js"
      ],
      "exports":[
         "A",
         "B",
         "C",
         "D",
         "E",
         "F",
         "G",
         "H",
         "I",
         "J",
         "K",
         "L",
         "M",
         "N",
         "O",
         "P",
         "Q",
         "R",
         "S",
         "T",
         "a",
         "b",
         "c",
         "d",
         "e",
         "f",
         "g",
         "h",
         "i",
         "j",
         "k",
         "l",
         "m",
         "n",
         "o",
         "p",
         "q",
         "r",
         "s",
         "t",
         "u",
         "v",
         "w",
         "x",
         "y",
         "z"
      ],
      "facadeModuleId":"/home/bmccann/src/svelte-realworld/src/client.js",
      "fileName":"client.9f4f62db.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[

      ],
      "isDynamicEntry":false,
      "isEntry":true,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/node_modules/svelte/internal/index.mjs":{
            "originalLength":51665,
            "removedExports":[
               "HtmlTag",
               "SvelteComponentDev",
               "SvelteElement",
               "add_attribute",
               "add_classes",
               "add_location",
               "add_resize_listener",
               "add_transform",
               "append_dev",
               "attr_dev",
               "beforeUpdate",
               "bubble",
               "clear_loops",
               "compute_rest_props",
               "create_animation",
               "create_bidirectional_transition",
               "create_in_transition",
               "create_out_transition",
               "create_ssr_component",
               "dataset_dev",
               "debug",
               "destroy_block",
               "detach_after_dev",
               "detach_before_dev",
               "detach_between_dev",
               "detach_dev",
               "dispatch_dev",
               "each",
               "element_is",
               "escape",
               "escaped",
               "exclude_internal_props",
               "fix_and_destroy_block",
               "fix_and_outro_and_destroy_block",
               "fix_position",
               "get_binding_group_value",
               "get_store_value",
               "globals",
               "handle_promise",
               "has_prop",
               "identity",
               "insert_dev",
               "intros",
               "invalid_attribute_name_character",
               "is_client",
               "is_crossorigin",
               "is_promise",
               "listen_dev",
               "loop",
               "loop_guard",
               "missing_component",
               "not_equal",
               "now",
               "null_to_empty",
               "object_without_properties",
               "onDestroy",
               "once",
               "prop_dev",
               "raf",
               "select_multiple_value",
               "select_option",
               "select_options",
               "select_value",
               "self",
               "set_attributes",
               "set_custom_element_data",
               "set_data_dev",
               "set_input_type",
               "set_now",
               "set_raf",
               "set_style",
               "set_svg_attributes",
               "spread",
               "stop_propagation",
               "tick",
               "time_ranges_to_array",
               "to_number",
               "validate_component",
               "validate_each_argument",
               "validate_each_keys",
               "validate_slots",
               "validate_store",
               "xlink_attr"
            ],
            "renderedExports":[
               "SvelteComponent",
               "action_destroyer",
               "add_flush_callback",
               "add_render_callback",
               "afterUpdate",
               "append",
               "assign",
               "attr",
               "bind",
               "binding_callbacks",
               "blank_object",
               "check_outros",
               "children",
               "claim_component",
               "claim_element",
               "claim_space",
               "claim_text",
               "component_subscribe",
               "createEventDispatcher",
               "create_component",
               "create_slot",
               "current_component",
               "custom_event",
               "destroy_component",
               "destroy_each",
               "detach",
               "dirty_components",
               "element",
               "empty",
               "flush",
               "getContext",
               "get_current_component",
               "get_slot_changes",
               "get_slot_context",
               "get_spread_object",
               "get_spread_update",
               "group_outros",
               "init",
               "insert",
               "is_function",
               "listen",
               "mount_component",
               "noop",
               "onMount",
               "outro_and_destroy_block",
               "prevent_default",
               "query_selector_all",
               "run",
               "run_all",
               "safe_not_equal",
               "schedule_update",
               "setContext",
               "set_current_component",
               "set_data",
               "set_input_value",
               "set_store_value",
               "space",
               "subscribe",
               "svg_element",
               "text",
               "toggle_class",
               "transition_in",
               "transition_out",
               "update_keyed_each",
               "update_slot"
            ],
            "renderedLength":16706
         },
         "/home/bmccann/src/svelte-realworld/node_modules/svelte/store/index.mjs":{
            "originalLength":3298,
            "removedExports":[
               "derived",
               "readable"
            ],
            "renderedExports":[
               "writable"
            ],
            "renderedLength":1683
         },
         "/home/bmccann/src/svelte-realworld/src/node_modules/@sapper/internal/shared.mjs":{
            "originalLength":108,
            "removedExports":[

            ],
            "renderedExports":[
               "CONTEXT_KEY",
               "preload"
            ],
            "renderedLength":52
         },
         "/home/bmccann/src/svelte-realworld/src/routes/_components/Nav.svelte":{
            "originalLength":1400,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":8691
         },
         "/home/bmccann/src/svelte-realworld/src/routes/_layout.svelte":{
            "originalLength":181,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":2229
         },
         "/home/bmccann/src/svelte-realworld/src/routes/_error.svelte":{
            "originalLength":467,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":3669
         },
         "/home/bmccann/src/svelte-realworld/src/node_modules/@sapper/internal/App.svelte":{
            "originalLength":667,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":7612
         },
         "/home/bmccann/src/svelte-realworld/src/node_modules/@sapper/internal/manifest-client.mjs":{
            "originalLength":3129,
            "removedExports":[

            ],
            "renderedExports":[
               "ignore",
               "components",
               "routes"
            ],
            "renderedLength":2915
         },
         "/home/bmccann/src/svelte-realworld/src/node_modules/@sapper/app.mjs":{
            "originalLength":13973,
            "removedExports":[
               "prefetchRoutes"
            ],
            "renderedExports":[
               "goto",
               "prefetch",
               "start",
               "stores"
            ],
            "renderedLength":13290
         },
         "/home/bmccann/src/svelte-realworld/src/client.js":{
            "originalLength":102,
            "removedExports":[

            ],
            "renderedExports":[

            ],
            "renderedLength":55
         }
      },
      "name":"client",
      "type":"chunk"
   },
   {
      "code":"import { S as SvelteComponent, i as init, s as safe_not_equal, c as create_component, a as claim_component, m as mount_component, n as noop, t as transition_in, b as transition_out, d as destroy_component } from './client.9f4f62db.js';\nimport './api.5c9dd840.js';\nimport './index.dccd3ebe.js';\nimport { H as Home } from './Home.ba941e4e.js';\n\n/* src/routes/index.svelte generated by Svelte v3.23.2 */\n\nfunction create_fragment(ctx) {\n\tlet home;\n\tlet current;\n\thome = new Home({ props: { p: 1 } });\n\n\treturn {\n\t\tc() {\n\t\t\tcreate_component(home.$$.fragment);\n\t\t},\n\t\tl(nodes) {\n\t\t\tclaim_component(home.$$.fragment, nodes);\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tmount_component(home, target, anchor);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp: noop,\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(home.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(home.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tdestroy_component(home, detaching);\n\t\t}\n\t};\n}\n\nclass Routes extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, null, create_fragment, safe_not_equal, {});\n\t}\n}\n\nexport default Routes;\n",
      "dynamicImports":[

      ],
      "exports":[
         "default"
      ],
      "facadeModuleId":"/home/bmccann/src/svelte-realworld/src/routes/index.svelte",
      "fileName":"index.4c114fc2.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[
         "client.9f4f62db.js",
         "api.5c9dd840.js",
         "index.dccd3ebe.js",
         "Home.ba941e4e.js"
      ],
      "isDynamicEntry":true,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/src/routes/index.svelte":{
            "originalLength":80,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":777
         }
      },
      "name":"index",
      "type":"chunk"
   },
   {
      "code":"import { S as SvelteComponent, i as init, s as safe_not_equal, e as element, f as space, g as text, h as claim_element, j as children, k as detach, l as claim_space, o as claim_text, p as attr, q as insert, r as append, u as listen, v as set_data, c as create_component, a as claim_component, m as mount_component, t as transition_in, b as transition_out, d as destroy_component, w as stores$1, x as component_subscribe, n as noop, y as empty, z as createEventDispatcher, A as destroy_each, B as binding_callbacks, C as bind, D as query_selector_all, E as add_flush_callback, F as onMount } from './client.9f4f62db.js';\nimport { g as get } from './api.5c9dd840.js';\nimport { A as ArticleList } from './index.dccd3ebe.js';\n\n/* src/routes/_components/MainView/index.svelte generated by Svelte v3.23.2 */\n\nfunction create_else_block(ctx) {\n\tlet li;\n\tlet a;\n\tlet t;\n\n\treturn {\n\t\tc() {\n\t\t\tli = element(\"li\");\n\t\t\ta = element(\"a\");\n\t\t\tt = text(\"Your Feed\");\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tli = claim_element(nodes, \"LI\", { class: true });\n\t\t\tvar li_nodes = children(li);\n\t\t\ta = claim_element(li_nodes, \"A\", { href: true, class: true });\n\t\t\tvar a_nodes = children(a);\n\t\t\tt = claim_text(a_nodes, \"Your Feed\");\n\t\t\ta_nodes.forEach(detach);\n\t\t\tli_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(a, \"href\", \"/login\");\n\t\t\tattr(a, \"class\", \"nav-link\");\n\t\t\tattr(li, \"class\", \"nav-item\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, li, anchor);\n\t\t\tappend(li, a);\n\t\t\tappend(a, t);\n\t\t},\n\t\tp: noop,\n\t\td(detaching) {\n\t\t\tif (detaching) detach(li);\n\t\t}\n\t};\n}\n\n// (25:3) {#if $session.user}\nfunction create_if_block_1(ctx) {\n\tlet li;\n\tlet a;\n\tlet t;\n\tlet a_class_value;\n\tlet mounted;\n\tlet dispose;\n\n\treturn {\n\t\tc() {\n\t\t\tli = element(\"li\");\n\t\t\ta = element(\"a\");\n\t\t\tt = text(\"Your Feed\");\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tli = claim_element(nodes, \"LI\", { class: true });\n\t\t\tvar li_nodes = children(li);\n\t\t\ta = claim_element(li_nodes, \"A\", { href: true, class: true });\n\t\t\tvar a_nodes = children(a);\n\t\t\tt = claim_text(a_nodes, \"Your Feed\");\n\t\t\ta_nodes.forEach(detach);\n\t\t\tli_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(a, \"href\", \".\");\n\t\t\tattr(a, \"class\", a_class_value = \"nav-link \" + (/*tab*/ ctx[0] === \"feed\" ? \"active\" : \"\"));\n\t\t\tattr(li, \"class\", \"nav-item\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, li, anchor);\n\t\t\tappend(li, a);\n\t\t\tappend(a, t);\n\n\t\t\tif (!mounted) {\n\t\t\t\tdispose = listen(a, \"click\", /*yourFeed*/ ctx[5]);\n\t\t\t\tmounted = true;\n\t\t\t}\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tif (dirty & /*tab*/ 1 && a_class_value !== (a_class_value = \"nav-link \" + (/*tab*/ ctx[0] === \"feed\" ? \"active\" : \"\"))) {\n\t\t\t\tattr(a, \"class\", a_class_value);\n\t\t\t}\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(li);\n\t\t\tmounted = false;\n\t\t\tdispose();\n\t\t}\n\t};\n}\n\n// (45:3) {#if tag}\nfunction create_if_block(ctx) {\n\tlet li;\n\tlet a;\n\tlet i;\n\tlet t0;\n\tlet t1;\n\tlet a_class_value;\n\tlet mounted;\n\tlet dispose;\n\n\treturn {\n\t\tc() {\n\t\t\tli = element(\"li\");\n\t\t\ta = element(\"a\");\n\t\t\ti = element(\"i\");\n\t\t\tt0 = space();\n\t\t\tt1 = text(/*tag*/ ctx[1]);\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tli = claim_element(nodes, \"LI\", { class: true });\n\t\t\tvar li_nodes = children(li);\n\t\t\ta = claim_element(li_nodes, \"A\", { href: true, class: true });\n\t\t\tvar a_nodes = children(a);\n\t\t\ti = claim_element(a_nodes, \"I\", { class: true });\n\t\t\tchildren(i).forEach(detach);\n\t\t\tt0 = claim_space(a_nodes);\n\t\t\tt1 = claim_text(a_nodes, /*tag*/ ctx[1]);\n\t\t\ta_nodes.forEach(detach);\n\t\t\tli_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(i, \"class\", \"ion-pound\");\n\t\t\tattr(a, \"href\", \".\");\n\t\t\tattr(a, \"class\", a_class_value = \"nav-link \" + (/*tab*/ ctx[0] === \"tag\" ? \"active\" : \"\"));\n\t\t\tattr(li, \"class\", \"nav-item\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, li, anchor);\n\t\t\tappend(li, a);\n\t\t\tappend(a, i);\n\t\t\tappend(a, t0);\n\t\t\tappend(a, t1);\n\n\t\t\tif (!mounted) {\n\t\t\t\tdispose = listen(a, \"click\", /*click_handler*/ ctx[7]);\n\t\t\t\tmounted = true;\n\t\t\t}\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tif (dirty & /*tag*/ 2) set_data(t1, /*tag*/ ctx[1]);\n\n\t\t\tif (dirty & /*tab*/ 1 && a_class_value !== (a_class_value = \"nav-link \" + (/*tab*/ ctx[0] === \"tag\" ? \"active\" : \"\"))) {\n\t\t\t\tattr(a, \"class\", a_class_value);\n\t\t\t}\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(li);\n\t\t\tmounted = false;\n\t\t\tdispose();\n\t\t}\n\t};\n}\n\nfunction create_fragment(ctx) {\n\tlet div1;\n\tlet div0;\n\tlet ul;\n\tlet t0;\n\tlet li;\n\tlet a;\n\tlet t1;\n\tlet a_class_value;\n\tlet t2;\n\tlet t3;\n\tlet articlelist;\n\tlet current;\n\tlet mounted;\n\tlet dispose;\n\n\tfunction select_block_type(ctx, dirty) {\n\t\tif (/*$session*/ ctx[3].user) return create_if_block_1;\n\t\treturn create_else_block;\n\t}\n\n\tlet current_block_type = select_block_type(ctx);\n\tlet if_block0 = current_block_type(ctx);\n\tlet if_block1 = /*tag*/ ctx[1] && create_if_block(ctx);\n\n\tarticlelist = new ArticleList({\n\t\t\tprops: {\n\t\t\t\tp: /*p*/ ctx[2],\n\t\t\t\ttab: /*tab*/ ctx[0],\n\t\t\t\ttag: /*tag*/ ctx[1]\n\t\t\t}\n\t\t});\n\n\treturn {\n\t\tc() {\n\t\t\tdiv1 = element(\"div\");\n\t\t\tdiv0 = element(\"div\");\n\t\t\tul = element(\"ul\");\n\t\t\tif_block0.c();\n\t\t\tt0 = space();\n\t\t\tli = element(\"li\");\n\t\t\ta = element(\"a\");\n\t\t\tt1 = text(\"Global Feed\");\n\t\t\tt2 = space();\n\t\t\tif (if_block1) if_block1.c();\n\t\t\tt3 = space();\n\t\t\tcreate_component(articlelist.$$.fragment);\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tdiv1 = claim_element(nodes, \"DIV\", { class: true });\n\t\t\tvar div1_nodes = children(div1);\n\t\t\tdiv0 = claim_element(div1_nodes, \"DIV\", { class: true });\n\t\t\tvar div0_nodes = children(div0);\n\t\t\tul = claim_element(div0_nodes, \"UL\", { class: true });\n\t\t\tvar ul_nodes = children(ul);\n\t\t\tif_block0.l(ul_nodes);\n\t\t\tt0 = claim_space(ul_nodes);\n\t\t\tli = claim_element(ul_nodes, \"LI\", { class: true });\n\t\t\tvar li_nodes = children(li);\n\t\t\ta = claim_element(li_nodes, \"A\", { href: true, class: true });\n\t\t\tvar a_nodes = children(a);\n\t\t\tt1 = claim_text(a_nodes, \"Global Feed\");\n\t\t\ta_nodes.forEach(detach);\n\t\t\tli_nodes.forEach(detach);\n\t\t\tt2 = claim_space(ul_nodes);\n\t\t\tif (if_block1) if_block1.l(ul_nodes);\n\t\t\tul_nodes.forEach(detach);\n\t\t\tdiv0_nodes.forEach(detach);\n\t\t\tt3 = claim_space(div1_nodes);\n\t\t\tclaim_component(articlelist.$$.fragment, div1_nodes);\n\t\t\tdiv1_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(a, \"href\", \".\");\n\t\t\tattr(a, \"class\", a_class_value = \"nav-link \" + (/*tab*/ ctx[0] === \"all\" ? \"active\" : \"\"));\n\t\t\tattr(li, \"class\", \"nav-item\");\n\t\t\tattr(ul, \"class\", \"nav nav-pills outline-active\");\n\t\t\tattr(div0, \"class\", \"feed-toggle\");\n\t\t\tattr(div1, \"class\", \"col-md-9\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, div1, anchor);\n\t\t\tappend(div1, div0);\n\t\t\tappend(div0, ul);\n\t\t\tif_block0.m(ul, null);\n\t\t\tappend(ul, t0);\n\t\t\tappend(ul, li);\n\t\t\tappend(li, a);\n\t\t\tappend(a, t1);\n\t\t\tappend(ul, t2);\n\t\t\tif (if_block1) if_block1.m(ul, null);\n\t\t\tappend(div1, t3);\n\t\t\tmount_component(articlelist, div1, null);\n\t\t\tcurrent = true;\n\n\t\t\tif (!mounted) {\n\t\t\t\tdispose = listen(a, \"click\", /*globalfeed*/ ctx[6]);\n\t\t\t\tmounted = true;\n\t\t\t}\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tif (current_block_type === (current_block_type = select_block_type(ctx)) && if_block0) {\n\t\t\t\tif_block0.p(ctx, dirty);\n\t\t\t} else {\n\t\t\t\tif_block0.d(1);\n\t\t\t\tif_block0 = current_block_type(ctx);\n\n\t\t\t\tif (if_block0) {\n\t\t\t\t\tif_block0.c();\n\t\t\t\t\tif_block0.m(ul, t0);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (!current || dirty & /*tab*/ 1 && a_class_value !== (a_class_value = \"nav-link \" + (/*tab*/ ctx[0] === \"all\" ? \"active\" : \"\"))) {\n\t\t\t\tattr(a, \"class\", a_class_value);\n\t\t\t}\n\n\t\t\tif (/*tag*/ ctx[1]) {\n\t\t\t\tif (if_block1) {\n\t\t\t\t\tif_block1.p(ctx, dirty);\n\t\t\t\t} else {\n\t\t\t\t\tif_block1 = create_if_block(ctx);\n\t\t\t\t\tif_block1.c();\n\t\t\t\t\tif_block1.m(ul, null);\n\t\t\t\t}\n\t\t\t} else if (if_block1) {\n\t\t\t\tif_block1.d(1);\n\t\t\t\tif_block1 = null;\n\t\t\t}\n\n\t\t\tconst articlelist_changes = {};\n\t\t\tif (dirty & /*p*/ 4) articlelist_changes.p = /*p*/ ctx[2];\n\t\t\tif (dirty & /*tab*/ 1) articlelist_changes.tab = /*tab*/ ctx[0];\n\t\t\tif (dirty & /*tag*/ 2) articlelist_changes.tag = /*tag*/ ctx[1];\n\t\t\tarticlelist.$set(articlelist_changes);\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(articlelist.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(articlelist.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(div1);\n\t\t\tif_block0.d();\n\t\t\tif (if_block1) if_block1.d();\n\t\t\tdestroy_component(articlelist);\n\t\t\tmounted = false;\n\t\t\tdispose();\n\t\t}\n\t};\n}\n\nfunction instance($$self, $$props, $$invalidate) {\n\tlet $session;\n\tlet { tab = \"all\" } = $$props;\n\tlet { tag = null } = $$props;\n\tlet { p } = $$props;\n\tconst { session } = stores$1();\n\tcomponent_subscribe($$self, session, value => $$invalidate(3, $session = value));\n\n\tfunction yourFeed() {\n\t\t$$invalidate(0, tab = \"feed\");\n\t\t$$invalidate(1, tag = null);\n\t}\n\n\tfunction globalfeed() {\n\t\t$$invalidate(0, tab = \"all\");\n\t\t$$invalidate(1, tag = null);\n\t}\n\n\tconst click_handler = () => $$invalidate(0, tab = \"tag\");\n\n\t$$self.$set = $$props => {\n\t\tif (\"tab\" in $$props) $$invalidate(0, tab = $$props.tab);\n\t\tif (\"tag\" in $$props) $$invalidate(1, tag = $$props.tag);\n\t\tif (\"p\" in $$props) $$invalidate(2, p = $$props.p);\n\t};\n\n\treturn [tab, tag, p, $session, session, yourFeed, globalfeed, click_handler];\n}\n\nclass MainView extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance, create_fragment, safe_not_equal, { tab: 0, tag: 1, p: 2 });\n\t}\n}\n\n/* src/routes/_components/Tags.svelte generated by Svelte v3.23.2 */\n\nfunction get_each_context(ctx, list, i) {\n\tconst child_ctx = ctx.slice();\n\tchild_ctx[3] = list[i];\n\treturn child_ctx;\n}\n\n// (16:0) {:else}\nfunction create_else_block$1(ctx) {\n\tlet div;\n\tlet t;\n\n\treturn {\n\t\tc() {\n\t\t\tdiv = element(\"div\");\n\t\t\tt = text(\"Loading Tags...\");\n\t\t},\n\t\tl(nodes) {\n\t\t\tdiv = claim_element(nodes, \"DIV\", {});\n\t\t\tvar div_nodes = children(div);\n\t\t\tt = claim_text(div_nodes, \"Loading Tags...\");\n\t\t\tdiv_nodes.forEach(detach);\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, div, anchor);\n\t\t\tappend(div, t);\n\t\t},\n\t\tp: noop,\n\t\td(detaching) {\n\t\t\tif (detaching) detach(div);\n\t\t}\n\t};\n}\n\n// (8:0) {#if tags}\nfunction create_if_block$1(ctx) {\n\tlet div;\n\tlet each_value = /*tags*/ ctx[0];\n\tlet each_blocks = [];\n\n\tfor (let i = 0; i < each_value.length; i += 1) {\n\t\teach_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));\n\t}\n\n\treturn {\n\t\tc() {\n\t\t\tdiv = element(\"div\");\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].c();\n\t\t\t}\n\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tdiv = claim_element(nodes, \"DIV\", { className: true });\n\t\t\tvar div_nodes = children(div);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].l(div_nodes);\n\t\t\t}\n\n\t\t\tdiv_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(div, \"classname\", \"tag-list\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, div, anchor);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].m(div, null);\n\t\t\t}\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tif (dirty & /*dispatch, tags*/ 3) {\n\t\t\t\teach_value = /*tags*/ ctx[0];\n\t\t\t\tlet i;\n\n\t\t\t\tfor (i = 0; i < each_value.length; i += 1) {\n\t\t\t\t\tconst child_ctx = get_each_context(ctx, each_value, i);\n\n\t\t\t\t\tif (each_blocks[i]) {\n\t\t\t\t\t\teach_blocks[i].p(child_ctx, dirty);\n\t\t\t\t\t} else {\n\t\t\t\t\t\teach_blocks[i] = create_each_block(child_ctx);\n\t\t\t\t\t\teach_blocks[i].c();\n\t\t\t\t\t\teach_blocks[i].m(div, null);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor (; i < each_blocks.length; i += 1) {\n\t\t\t\t\teach_blocks[i].d(1);\n\t\t\t\t}\n\n\t\t\t\teach_blocks.length = each_value.length;\n\t\t\t}\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(div);\n\t\t\tdestroy_each(each_blocks, detaching);\n\t\t}\n\t};\n}\n\n// (10:2) {#each tags as tag}\nfunction create_each_block(ctx) {\n\tlet a;\n\tlet t0_value = /*tag*/ ctx[3] + \"\";\n\tlet t0;\n\tlet t1;\n\tlet mounted;\n\tlet dispose;\n\n\tfunction click_handler(...args) {\n\t\treturn /*click_handler*/ ctx[2](/*tag*/ ctx[3], ...args);\n\t}\n\n\treturn {\n\t\tc() {\n\t\t\ta = element(\"a\");\n\t\t\tt0 = text(t0_value);\n\t\t\tt1 = space();\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\ta = claim_element(nodes, \"A\", { href: true, class: true });\n\t\t\tvar a_nodes = children(a);\n\t\t\tt0 = claim_text(a_nodes, t0_value);\n\t\t\tt1 = claim_space(a_nodes);\n\t\t\ta_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(a, \"href\", \".\");\n\t\t\tattr(a, \"class\", \"tag-default tag-pill\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, a, anchor);\n\t\t\tappend(a, t0);\n\t\t\tappend(a, t1);\n\n\t\t\tif (!mounted) {\n\t\t\t\tdispose = listen(a, \"click\", click_handler);\n\t\t\t\tmounted = true;\n\t\t\t}\n\t\t},\n\t\tp(new_ctx, dirty) {\n\t\t\tctx = new_ctx;\n\t\t\tif (dirty & /*tags*/ 1 && t0_value !== (t0_value = /*tag*/ ctx[3] + \"\")) set_data(t0, t0_value);\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(a);\n\t\t\tmounted = false;\n\t\t\tdispose();\n\t\t}\n\t};\n}\n\nfunction create_fragment$1(ctx) {\n\tlet if_block_anchor;\n\n\tfunction select_block_type(ctx, dirty) {\n\t\tif (/*tags*/ ctx[0]) return create_if_block$1;\n\t\treturn create_else_block$1;\n\t}\n\n\tlet current_block_type = select_block_type(ctx);\n\tlet if_block = current_block_type(ctx);\n\n\treturn {\n\t\tc() {\n\t\t\tif_block.c();\n\t\t\tif_block_anchor = empty();\n\t\t},\n\t\tl(nodes) {\n\t\t\tif_block.l(nodes);\n\t\t\tif_block_anchor = empty();\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tif_block.m(target, anchor);\n\t\t\tinsert(target, if_block_anchor, anchor);\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tif (current_block_type === (current_block_type = select_block_type(ctx)) && if_block) {\n\t\t\t\tif_block.p(ctx, dirty);\n\t\t\t} else {\n\t\t\t\tif_block.d(1);\n\t\t\t\tif_block = current_block_type(ctx);\n\n\t\t\t\tif (if_block) {\n\t\t\t\t\tif_block.c();\n\t\t\t\t\tif_block.m(if_block_anchor.parentNode, if_block_anchor);\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\ti: noop,\n\t\to: noop,\n\t\td(detaching) {\n\t\t\tif_block.d(detaching);\n\t\t\tif (detaching) detach(if_block_anchor);\n\t\t}\n\t};\n}\n\nfunction instance$1($$self, $$props, $$invalidate) {\n\tlet { tags } = $$props;\n\tconst dispatch = createEventDispatcher();\n\tconst click_handler = tag => dispatch(\"select\", { tag });\n\n\t$$self.$set = $$props => {\n\t\tif (\"tags\" in $$props) $$invalidate(0, tags = $$props.tags);\n\t};\n\n\treturn [tags, dispatch, click_handler];\n}\n\nclass Tags extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance$1, create_fragment$1, safe_not_equal, { tags: 0 });\n\t}\n}\n\n/* src/routes/_components/Home.svelte generated by Svelte v3.23.2 */\n\nfunction create_fragment$2(ctx) {\n\tlet t0;\n\tlet div6;\n\tlet div1;\n\tlet div0;\n\tlet h1;\n\tlet t1;\n\tlet t2;\n\tlet p0;\n\tlet t3;\n\tlet t4;\n\tlet div5;\n\tlet div4;\n\tlet mainview;\n\tlet updating_tab;\n\tlet t5;\n\tlet div3;\n\tlet div2;\n\tlet p1;\n\tlet t6;\n\tlet t7;\n\tlet tags_1;\n\tlet current;\n\n\tfunction mainview_tab_binding(value) {\n\t\t/*mainview_tab_binding*/ ctx[5].call(null, value);\n\t}\n\n\tlet mainview_props = { p: /*p*/ ctx[0], tag: /*tag*/ ctx[2] };\n\n\tif (/*tab*/ ctx[1] !== void 0) {\n\t\tmainview_props.tab = /*tab*/ ctx[1];\n\t}\n\n\tmainview = new MainView({ props: mainview_props });\n\tbinding_callbacks.push(() => bind(mainview, \"tab\", mainview_tab_binding));\n\ttags_1 = new Tags({ props: { tags: /*tags*/ ctx[3] } });\n\ttags_1.$on(\"select\", /*setTags*/ ctx[4]);\n\n\treturn {\n\t\tc() {\n\t\t\tt0 = space();\n\t\t\tdiv6 = element(\"div\");\n\t\t\tdiv1 = element(\"div\");\n\t\t\tdiv0 = element(\"div\");\n\t\t\th1 = element(\"h1\");\n\t\t\tt1 = text(\"conduit\");\n\t\t\tt2 = space();\n\t\t\tp0 = element(\"p\");\n\t\t\tt3 = text(\"A place to share your knowledge.\");\n\t\t\tt4 = space();\n\t\t\tdiv5 = element(\"div\");\n\t\t\tdiv4 = element(\"div\");\n\t\t\tcreate_component(mainview.$$.fragment);\n\t\t\tt5 = space();\n\t\t\tdiv3 = element(\"div\");\n\t\t\tdiv2 = element(\"div\");\n\t\t\tp1 = element(\"p\");\n\t\t\tt6 = text(\"Popular Tags\");\n\t\t\tt7 = space();\n\t\t\tcreate_component(tags_1.$$.fragment);\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tconst head_nodes = query_selector_all(\"[data-svelte=\\\"svelte-125rjtu\\\"]\", document.head);\n\t\t\thead_nodes.forEach(detach);\n\t\t\tt0 = claim_space(nodes);\n\t\t\tdiv6 = claim_element(nodes, \"DIV\", { class: true });\n\t\t\tvar div6_nodes = children(div6);\n\t\t\tdiv1 = claim_element(div6_nodes, \"DIV\", { class: true });\n\t\t\tvar div1_nodes = children(div1);\n\t\t\tdiv0 = claim_element(div1_nodes, \"DIV\", { class: true });\n\t\t\tvar div0_nodes = children(div0);\n\t\t\th1 = claim_element(div0_nodes, \"H1\", { class: true });\n\t\t\tvar h1_nodes = children(h1);\n\t\t\tt1 = claim_text(h1_nodes, \"conduit\");\n\t\t\th1_nodes.forEach(detach);\n\t\t\tt2 = claim_space(div0_nodes);\n\t\t\tp0 = claim_element(div0_nodes, \"P\", {});\n\t\t\tvar p0_nodes = children(p0);\n\t\t\tt3 = claim_text(p0_nodes, \"A place to share your knowledge.\");\n\t\t\tp0_nodes.forEach(detach);\n\t\t\tdiv0_nodes.forEach(detach);\n\t\t\tdiv1_nodes.forEach(detach);\n\t\t\tt4 = claim_space(div6_nodes);\n\t\t\tdiv5 = claim_element(div6_nodes, \"DIV\", { class: true });\n\t\t\tvar div5_nodes = children(div5);\n\t\t\tdiv4 = claim_element(div5_nodes, \"DIV\", { class: true });\n\t\t\tvar div4_nodes = children(div4);\n\t\t\tclaim_component(mainview.$$.fragment, div4_nodes);\n\t\t\tt5 = claim_space(div4_nodes);\n\t\t\tdiv3 = claim_element(div4_nodes, \"DIV\", { class: true });\n\t\t\tvar div3_nodes = children(div3);\n\t\t\tdiv2 = claim_element(div3_nodes, \"DIV\", { class: true });\n\t\t\tvar div2_nodes = children(div2);\n\t\t\tp1 = claim_element(div2_nodes, \"P\", {});\n\t\t\tvar p1_nodes = children(p1);\n\t\t\tt6 = claim_text(p1_nodes, \"Popular Tags\");\n\t\t\tp1_nodes.forEach(detach);\n\t\t\tt7 = claim_space(div2_nodes);\n\t\t\tclaim_component(tags_1.$$.fragment, div2_nodes);\n\t\t\tdiv2_nodes.forEach(detach);\n\t\t\tdiv3_nodes.forEach(detach);\n\t\t\tdiv4_nodes.forEach(detach);\n\t\t\tdiv5_nodes.forEach(detach);\n\t\t\tdiv6_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tdocument.title = \"Conduit\";\n\t\t\tattr(h1, \"class\", \"logo-font\");\n\t\t\tattr(div0, \"class\", \"container\");\n\t\t\tattr(div1, \"class\", \"banner\");\n\t\t\tattr(div2, \"class\", \"sidebar\");\n\t\t\tattr(div3, \"class\", \"col-md-3\");\n\t\t\tattr(div4, \"class\", \"row\");\n\t\t\tattr(div5, \"class\", \"container page\");\n\t\t\tattr(div6, \"class\", \"home-page\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, t0, anchor);\n\t\t\tinsert(target, div6, anchor);\n\t\t\tappend(div6, div1);\n\t\t\tappend(div1, div0);\n\t\t\tappend(div0, h1);\n\t\t\tappend(h1, t1);\n\t\t\tappend(div0, t2);\n\t\t\tappend(div0, p0);\n\t\t\tappend(p0, t3);\n\t\t\tappend(div6, t4);\n\t\t\tappend(div6, div5);\n\t\t\tappend(div5, div4);\n\t\t\tmount_component(mainview, div4, null);\n\t\t\tappend(div4, t5);\n\t\t\tappend(div4, div3);\n\t\t\tappend(div3, div2);\n\t\t\tappend(div2, p1);\n\t\t\tappend(p1, t6);\n\t\t\tappend(div2, t7);\n\t\t\tmount_component(tags_1, div2, null);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tconst mainview_changes = {};\n\t\t\tif (dirty & /*p*/ 1) mainview_changes.p = /*p*/ ctx[0];\n\t\t\tif (dirty & /*tag*/ 4) mainview_changes.tag = /*tag*/ ctx[2];\n\n\t\t\tif (!updating_tab && dirty & /*tab*/ 2) {\n\t\t\t\tupdating_tab = true;\n\t\t\t\tmainview_changes.tab = /*tab*/ ctx[1];\n\t\t\t\tadd_flush_callback(() => updating_tab = false);\n\t\t\t}\n\n\t\t\tmainview.$set(mainview_changes);\n\t\t\tconst tags_1_changes = {};\n\t\t\tif (dirty & /*tags*/ 8) tags_1_changes.tags = /*tags*/ ctx[3];\n\t\t\ttags_1.$set(tags_1_changes);\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(mainview.$$.fragment, local);\n\t\t\ttransition_in(tags_1.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(mainview.$$.fragment, local);\n\t\t\ttransition_out(tags_1.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(t0);\n\t\t\tif (detaching) detach(div6);\n\t\t\tdestroy_component(mainview);\n\t\t\tdestroy_component(tags_1);\n\t\t}\n\t};\n}\n\nfunction instance$2($$self, $$props, $$invalidate) {\n\tlet { p = 1 } = $$props;\n\tlet tab;\n\tlet tag;\n\tlet tags;\n\n\tfunction setTags({ detail }) {\n\t\t$$invalidate(2, tag = detail.tag);\n\t\t$$invalidate(1, tab = \"tag\");\n\t}\n\n\tonMount(async () => {\n\t\t$$invalidate(3, { tags } = await get(\"tags\"), tags);\n\t});\n\n\tfunction mainview_tab_binding(value) {\n\t\ttab = value;\n\t\t$$invalidate(1, tab);\n\t}\n\n\t$$self.$set = $$props => {\n\t\tif (\"p\" in $$props) $$invalidate(0, p = $$props.p);\n\t};\n\n\treturn [p, tab, tag, tags, setTags, mainview_tab_binding];\n}\n\nclass Home extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance$2, create_fragment$2, safe_not_equal, { p: 0 });\n\t}\n}\n\nexport { Home as H };\n",
      "dynamicImports":[

      ],
      "exports":[
         "H"
      ],
      "facadeModuleId":null,
      "fileName":"Home.ba941e4e.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[
         "client.9f4f62db.js",
         "api.5c9dd840.js",
         "index.dccd3ebe.js"
      ],
      "isDynamicEntry":false,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/src/routes/_components/MainView/index.svelte":{
            "originalLength":1132,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":8471
         },
         "/home/bmccann/src/svelte-realworld/src/routes/_components/Tags.svelte":{
            "originalLength":361,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":4693
         },
         "/home/bmccann/src/svelte-realworld/src/routes/_components/Home.svelte":{
            "originalLength":836,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":5673
         }
      },
      "name":"Home",
      "type":"chunk"
   },
   {
      "code":"const base = 'https://conduit.productionready.io/api';\n\nfunction send({ method, path, data, token }) {\n\tconst fetch =  window.fetch ;\n\n\tconst opts = { method, headers: {} };\n\n\tif (data) {\n\t\topts.headers['Content-Type'] = 'application/json';\n\t\topts.body = JSON.stringify(data);\n\t}\n\n\tif (token) {\n\t\topts.headers['Authorization'] = `Token ${token}`;\n\t}\n\n\treturn fetch(`${base}/${path}`, opts)\n\t\t.then(r => r.text())\n\t\t.then(json => {\n\t\t\ttry {\n\t\t\t\treturn JSON.parse(json);\n\t\t\t} catch (err) {\n\t\t\t\treturn json;\n\t\t\t}\n\t\t});\n}\n\nfunction get(path, token) {\n\treturn send({ method: 'GET', path, token });\n}\n\nfunction del(path, token) {\n\treturn send({ method: 'DELETE', path, token });\n}\n\nfunction post(path, data, token) {\n\treturn send({ method: 'POST', path, data, token });\n}\n\nfunction put(path, data, token) {\n\treturn send({ method: 'PUT', path, data, token });\n}\n\nexport { put as a, del as d, get as g, post as p };\n",
      "dynamicImports":[

      ],
      "exports":[
         "a",
         "d",
         "g",
         "p"
      ],
      "facadeModuleId":null,
      "fileName":"api.5c9dd840.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[

      ],
      "isDynamicEntry":false,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/src/node_modules/api.js":{
            "originalLength":930,
            "removedExports":[

            ],
            "renderedExports":[
               "get",
               "del",
               "post",
               "put"
            ],
            "renderedLength":854
         }
      },
      "name":"api",
      "type":"chunk"
   },
   {
      "code":"import { S as SvelteComponent, i as init, s as safe_not_equal, e as element, f as space, g as text, h as claim_element, j as children, k as detach, l as claim_space, o as claim_text, p as attr, q as insert, r as append, u as listen, v as set_data, n as noop, A as destroy_each, y as empty, G as group_outros, b as transition_out, H as check_outros, t as transition_in, w as stores$1, x as component_subscribe, c as create_component, a as claim_component, m as mount_component, d as destroy_component, I as update_keyed_each, J as outro_and_destroy_block } from './client.9f4f62db.js';\nimport { p as post, d as del, g as get } from './api.5c9dd840.js';\n\n/* src/routes/_components/ArticleList/ArticlePreview.svelte generated by Svelte v3.23.2 */\n\nfunction get_each_context(ctx, list, i) {\n\tconst child_ctx = ctx.slice();\n\tchild_ctx[3] = list[i];\n\treturn child_ctx;\n}\n\n// (37:2) {#if user}\nfunction create_if_block(ctx) {\n\tlet div;\n\tlet button;\n\tlet i;\n\tlet t0;\n\tlet t1_value = /*article*/ ctx[0].favoritesCount + \"\";\n\tlet t1;\n\tlet button_class_value;\n\tlet mounted;\n\tlet dispose;\n\n\treturn {\n\t\tc() {\n\t\t\tdiv = element(\"div\");\n\t\t\tbutton = element(\"button\");\n\t\t\ti = element(\"i\");\n\t\t\tt0 = space();\n\t\t\tt1 = text(t1_value);\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tdiv = claim_element(nodes, \"DIV\", { class: true });\n\t\t\tvar div_nodes = children(div);\n\t\t\tbutton = claim_element(div_nodes, \"BUTTON\", { class: true });\n\t\t\tvar button_nodes = children(button);\n\t\t\ti = claim_element(button_nodes, \"I\", { class: true });\n\t\t\tchildren(i).forEach(detach);\n\t\t\tt0 = claim_space(button_nodes);\n\t\t\tt1 = claim_text(button_nodes, t1_value);\n\t\t\tbutton_nodes.forEach(detach);\n\t\t\tdiv_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(i, \"class\", \"ion-heart\");\n\n\t\t\tattr(button, \"class\", button_class_value = \"btn btn-sm \" + (/*article*/ ctx[0].favorited\n\t\t\t? \"btn-primary\"\n\t\t\t: \"btn-outline-primary\"));\n\n\t\t\tattr(div, \"class\", \"pull-xs-right\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, div, anchor);\n\t\t\tappend(div, button);\n\t\t\tappend(button, i);\n\t\t\tappend(button, t0);\n\t\t\tappend(button, t1);\n\n\t\t\tif (!mounted) {\n\t\t\t\tdispose = listen(button, \"click\", /*toggleFavorite*/ ctx[2]);\n\t\t\t\tmounted = true;\n\t\t\t}\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tif (dirty & /*article*/ 1 && t1_value !== (t1_value = /*article*/ ctx[0].favoritesCount + \"\")) set_data(t1, t1_value);\n\n\t\t\tif (dirty & /*article*/ 1 && button_class_value !== (button_class_value = \"btn btn-sm \" + (/*article*/ ctx[0].favorited\n\t\t\t? \"btn-primary\"\n\t\t\t: \"btn-outline-primary\"))) {\n\t\t\t\tattr(button, \"class\", button_class_value);\n\t\t\t}\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(div);\n\t\t\tmounted = false;\n\t\t\tdispose();\n\t\t}\n\t};\n}\n\n// (51:3) {#each article.tagList as tag}\nfunction create_each_block(ctx) {\n\tlet li;\n\tlet t0_value = /*tag*/ ctx[3] + \"\";\n\tlet t0;\n\tlet t1;\n\n\treturn {\n\t\tc() {\n\t\t\tli = element(\"li\");\n\t\t\tt0 = text(t0_value);\n\t\t\tt1 = space();\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tli = claim_element(nodes, \"LI\", { class: true });\n\t\t\tvar li_nodes = children(li);\n\t\t\tt0 = claim_text(li_nodes, t0_value);\n\t\t\tt1 = claim_space(li_nodes);\n\t\t\tli_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(li, \"class\", \"tag-default tag-pill tag-outline\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, li, anchor);\n\t\t\tappend(li, t0);\n\t\t\tappend(li, t1);\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tif (dirty & /*article*/ 1 && t0_value !== (t0_value = /*tag*/ ctx[3] + \"\")) set_data(t0, t0_value);\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(li);\n\t\t}\n\t};\n}\n\nfunction create_fragment(ctx) {\n\tlet div2;\n\tlet div1;\n\tlet a0;\n\tlet img;\n\tlet img_src_value;\n\tlet img_alt_value;\n\tlet a0_href_value;\n\tlet t0;\n\tlet div0;\n\tlet a1;\n\tlet t1_value = /*article*/ ctx[0].author.username + \"\";\n\tlet t1;\n\tlet a1_href_value;\n\tlet t2;\n\tlet span0;\n\tlet t3_value = new Date(/*article*/ ctx[0].createdAt).toDateString() + \"\";\n\tlet t3;\n\tlet t4;\n\tlet t5;\n\tlet a2;\n\tlet h1;\n\tlet t6_value = /*article*/ ctx[0].title + \"\";\n\tlet t6;\n\tlet t7;\n\tlet p;\n\tlet t8_value = /*article*/ ctx[0].description + \"\";\n\tlet t8;\n\tlet t9;\n\tlet span1;\n\tlet t10;\n\tlet t11;\n\tlet ul;\n\tlet a2_href_value;\n\tlet if_block = /*user*/ ctx[1] && create_if_block(ctx);\n\tlet each_value = /*article*/ ctx[0].tagList;\n\tlet each_blocks = [];\n\n\tfor (let i = 0; i < each_value.length; i += 1) {\n\t\teach_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));\n\t}\n\n\treturn {\n\t\tc() {\n\t\t\tdiv2 = element(\"div\");\n\t\t\tdiv1 = element(\"div\");\n\t\t\ta0 = element(\"a\");\n\t\t\timg = element(\"img\");\n\t\t\tt0 = space();\n\t\t\tdiv0 = element(\"div\");\n\t\t\ta1 = element(\"a\");\n\t\t\tt1 = text(t1_value);\n\t\t\tt2 = space();\n\t\t\tspan0 = element(\"span\");\n\t\t\tt3 = text(t3_value);\n\t\t\tt4 = space();\n\t\t\tif (if_block) if_block.c();\n\t\t\tt5 = space();\n\t\t\ta2 = element(\"a\");\n\t\t\th1 = element(\"h1\");\n\t\t\tt6 = text(t6_value);\n\t\t\tt7 = space();\n\t\t\tp = element(\"p\");\n\t\t\tt8 = text(t8_value);\n\t\t\tt9 = space();\n\t\t\tspan1 = element(\"span\");\n\t\t\tt10 = text(\"Read more...\");\n\t\t\tt11 = space();\n\t\t\tul = element(\"ul\");\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].c();\n\t\t\t}\n\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tdiv2 = claim_element(nodes, \"DIV\", { class: true });\n\t\t\tvar div2_nodes = children(div2);\n\t\t\tdiv1 = claim_element(div2_nodes, \"DIV\", { class: true });\n\t\t\tvar div1_nodes = children(div1);\n\t\t\ta0 = claim_element(div1_nodes, \"A\", { href: true });\n\t\t\tvar a0_nodes = children(a0);\n\t\t\timg = claim_element(a0_nodes, \"IMG\", { src: true, alt: true });\n\t\t\ta0_nodes.forEach(detach);\n\t\t\tt0 = claim_space(div1_nodes);\n\t\t\tdiv0 = claim_element(div1_nodes, \"DIV\", { class: true });\n\t\t\tvar div0_nodes = children(div0);\n\t\t\ta1 = claim_element(div0_nodes, \"A\", { class: true, href: true });\n\t\t\tvar a1_nodes = children(a1);\n\t\t\tt1 = claim_text(a1_nodes, t1_value);\n\t\t\ta1_nodes.forEach(detach);\n\t\t\tt2 = claim_space(div0_nodes);\n\t\t\tspan0 = claim_element(div0_nodes, \"SPAN\", { class: true });\n\t\t\tvar span0_nodes = children(span0);\n\t\t\tt3 = claim_text(span0_nodes, t3_value);\n\t\t\tspan0_nodes.forEach(detach);\n\t\t\tdiv0_nodes.forEach(detach);\n\t\t\tt4 = claim_space(div1_nodes);\n\t\t\tif (if_block) if_block.l(div1_nodes);\n\t\t\tdiv1_nodes.forEach(detach);\n\t\t\tt5 = claim_space(div2_nodes);\n\t\t\ta2 = claim_element(div2_nodes, \"A\", { href: true, rel: true, class: true });\n\t\t\tvar a2_nodes = children(a2);\n\t\t\th1 = claim_element(a2_nodes, \"H1\", {});\n\t\t\tvar h1_nodes = children(h1);\n\t\t\tt6 = claim_text(h1_nodes, t6_value);\n\t\t\th1_nodes.forEach(detach);\n\t\t\tt7 = claim_space(a2_nodes);\n\t\t\tp = claim_element(a2_nodes, \"P\", {});\n\t\t\tvar p_nodes = children(p);\n\t\t\tt8 = claim_text(p_nodes, t8_value);\n\t\t\tp_nodes.forEach(detach);\n\t\t\tt9 = claim_space(a2_nodes);\n\t\t\tspan1 = claim_element(a2_nodes, \"SPAN\", {});\n\t\t\tvar span1_nodes = children(span1);\n\t\t\tt10 = claim_text(span1_nodes, \"Read more...\");\n\t\t\tspan1_nodes.forEach(detach);\n\t\t\tt11 = claim_space(a2_nodes);\n\t\t\tul = claim_element(a2_nodes, \"UL\", { class: true });\n\t\t\tvar ul_nodes = children(ul);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].l(ul_nodes);\n\t\t\t}\n\n\t\t\tul_nodes.forEach(detach);\n\t\t\ta2_nodes.forEach(detach);\n\t\t\tdiv2_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tif (img.src !== (img_src_value = /*article*/ ctx[0].author.image)) attr(img, \"src\", img_src_value);\n\t\t\tattr(img, \"alt\", img_alt_value = /*article*/ ctx[0].author.username);\n\t\t\tattr(a0, \"href\", a0_href_value = \"/profile/@\" + /*article*/ ctx[0].author.username);\n\t\t\tattr(a1, \"class\", \"author\");\n\t\t\tattr(a1, \"href\", a1_href_value = \"/profile/@\" + /*article*/ ctx[0].author.username);\n\t\t\tattr(span0, \"class\", \"date\");\n\t\t\tattr(div0, \"class\", \"info\");\n\t\t\tattr(div1, \"class\", \"article-meta\");\n\t\t\tattr(ul, \"class\", \"tag-list\");\n\t\t\tattr(a2, \"href\", a2_href_value = \"/article/\" + /*article*/ ctx[0].slug);\n\t\t\tattr(a2, \"rel\", \"prefetch\");\n\t\t\tattr(a2, \"class\", \"preview-link\");\n\t\t\tattr(div2, \"class\", \"article-preview\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, div2, anchor);\n\t\t\tappend(div2, div1);\n\t\t\tappend(div1, a0);\n\t\t\tappend(a0, img);\n\t\t\tappend(div1, t0);\n\t\t\tappend(div1, div0);\n\t\t\tappend(div0, a1);\n\t\t\tappend(a1, t1);\n\t\t\tappend(div0, t2);\n\t\t\tappend(div0, span0);\n\t\t\tappend(span0, t3);\n\t\t\tappend(div1, t4);\n\t\t\tif (if_block) if_block.m(div1, null);\n\t\t\tappend(div2, t5);\n\t\t\tappend(div2, a2);\n\t\t\tappend(a2, h1);\n\t\t\tappend(h1, t6);\n\t\t\tappend(a2, t7);\n\t\t\tappend(a2, p);\n\t\t\tappend(p, t8);\n\t\t\tappend(a2, t9);\n\t\t\tappend(a2, span1);\n\t\t\tappend(span1, t10);\n\t\t\tappend(a2, t11);\n\t\t\tappend(a2, ul);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].m(ul, null);\n\t\t\t}\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tif (dirty & /*article*/ 1 && img.src !== (img_src_value = /*article*/ ctx[0].author.image)) {\n\t\t\t\tattr(img, \"src\", img_src_value);\n\t\t\t}\n\n\t\t\tif (dirty & /*article*/ 1 && img_alt_value !== (img_alt_value = /*article*/ ctx[0].author.username)) {\n\t\t\t\tattr(img, \"alt\", img_alt_value);\n\t\t\t}\n\n\t\t\tif (dirty & /*article*/ 1 && a0_href_value !== (a0_href_value = \"/profile/@\" + /*article*/ ctx[0].author.username)) {\n\t\t\t\tattr(a0, \"href\", a0_href_value);\n\t\t\t}\n\n\t\t\tif (dirty & /*article*/ 1 && t1_value !== (t1_value = /*article*/ ctx[0].author.username + \"\")) set_data(t1, t1_value);\n\n\t\t\tif (dirty & /*article*/ 1 && a1_href_value !== (a1_href_value = \"/profile/@\" + /*article*/ ctx[0].author.username)) {\n\t\t\t\tattr(a1, \"href\", a1_href_value);\n\t\t\t}\n\n\t\t\tif (dirty & /*article*/ 1 && t3_value !== (t3_value = new Date(/*article*/ ctx[0].createdAt).toDateString() + \"\")) set_data(t3, t3_value);\n\n\t\t\tif (/*user*/ ctx[1]) {\n\t\t\t\tif (if_block) {\n\t\t\t\t\tif_block.p(ctx, dirty);\n\t\t\t\t} else {\n\t\t\t\t\tif_block = create_if_block(ctx);\n\t\t\t\t\tif_block.c();\n\t\t\t\t\tif_block.m(div1, null);\n\t\t\t\t}\n\t\t\t} else if (if_block) {\n\t\t\t\tif_block.d(1);\n\t\t\t\tif_block = null;\n\t\t\t}\n\n\t\t\tif (dirty & /*article*/ 1 && t6_value !== (t6_value = /*article*/ ctx[0].title + \"\")) set_data(t6, t6_value);\n\t\t\tif (dirty & /*article*/ 1 && t8_value !== (t8_value = /*article*/ ctx[0].description + \"\")) set_data(t8, t8_value);\n\n\t\t\tif (dirty & /*article*/ 1) {\n\t\t\t\teach_value = /*article*/ ctx[0].tagList;\n\t\t\t\tlet i;\n\n\t\t\t\tfor (i = 0; i < each_value.length; i += 1) {\n\t\t\t\t\tconst child_ctx = get_each_context(ctx, each_value, i);\n\n\t\t\t\t\tif (each_blocks[i]) {\n\t\t\t\t\t\teach_blocks[i].p(child_ctx, dirty);\n\t\t\t\t\t} else {\n\t\t\t\t\t\teach_blocks[i] = create_each_block(child_ctx);\n\t\t\t\t\t\teach_blocks[i].c();\n\t\t\t\t\t\teach_blocks[i].m(ul, null);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor (; i < each_blocks.length; i += 1) {\n\t\t\t\t\teach_blocks[i].d(1);\n\t\t\t\t}\n\n\t\t\t\teach_blocks.length = each_value.length;\n\t\t\t}\n\n\t\t\tif (dirty & /*article*/ 1 && a2_href_value !== (a2_href_value = \"/article/\" + /*article*/ ctx[0].slug)) {\n\t\t\t\tattr(a2, \"href\", a2_href_value);\n\t\t\t}\n\t\t},\n\t\ti: noop,\n\t\to: noop,\n\t\td(detaching) {\n\t\t\tif (detaching) detach(div2);\n\t\t\tif (if_block) if_block.d();\n\t\t\tdestroy_each(each_blocks, detaching);\n\t\t}\n\t};\n}\n\nfunction instance($$self, $$props, $$invalidate) {\n\tlet { article } = $$props;\n\tlet { user } = $$props;\n\n\tasync function toggleFavorite() {\n\t\t// optimistic UI\n\t\tif (article.favorited) {\n\t\t\t$$invalidate(0, article.favoritesCount -= 1, article);\n\t\t\t$$invalidate(0, article.favorited = false, article);\n\t\t} else {\n\t\t\t$$invalidate(0, article.favoritesCount += 1, article);\n\t\t\t$$invalidate(0, article.favorited = true, article);\n\t\t}\n\n\t\t$$invalidate(\n\t\t\t0,\n\t\t\t{ article } = await (article.favorited\n\t\t\t? post(`articles/${article.slug}/favorite`, null, user && user.token)\n\t\t\t: del(`articles/${article.slug}/favorite`, user && user.token)),\n\t\t\tarticle\n\t\t);\n\t}\n\n\t$$self.$set = $$props => {\n\t\tif (\"article\" in $$props) $$invalidate(0, article = $$props.article);\n\t\tif (\"user\" in $$props) $$invalidate(1, user = $$props.user);\n\t};\n\n\treturn [article, user, toggleFavorite];\n}\n\nclass ArticlePreview extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance, create_fragment, safe_not_equal, { article: 0, user: 1 });\n\t}\n}\n\n/* src/routes/_components/ArticleList/ListPagination.svelte generated by Svelte v3.23.2 */\n\nfunction get_each_context$1(ctx, list, i) {\n\tconst child_ctx = ctx.slice();\n\tchild_ctx[3] = list[i];\n\treturn child_ctx;\n}\n\n// (15:0) {#if articlesCount > 10}\nfunction create_if_block$1(ctx) {\n\tlet nav;\n\tlet ul;\n\tlet each_value = /*range*/ ctx[2];\n\tlet each_blocks = [];\n\n\tfor (let i = 0; i < each_value.length; i += 1) {\n\t\teach_blocks[i] = create_each_block$1(get_each_context$1(ctx, each_value, i));\n\t}\n\n\treturn {\n\t\tc() {\n\t\t\tnav = element(\"nav\");\n\t\t\tul = element(\"ul\");\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].c();\n\t\t\t}\n\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tnav = claim_element(nodes, \"NAV\", {});\n\t\t\tvar nav_nodes = children(nav);\n\t\t\tul = claim_element(nav_nodes, \"UL\", { class: true });\n\t\t\tvar ul_nodes = children(ul);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].l(ul_nodes);\n\t\t\t}\n\n\t\t\tul_nodes.forEach(detach);\n\t\t\tnav_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(ul, \"class\", \"pagination\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, nav, anchor);\n\t\t\tappend(nav, ul);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].m(ul, null);\n\t\t\t}\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tif (dirty & /*range, page*/ 6) {\n\t\t\t\teach_value = /*range*/ ctx[2];\n\t\t\t\tlet i;\n\n\t\t\t\tfor (i = 0; i < each_value.length; i += 1) {\n\t\t\t\t\tconst child_ctx = get_each_context$1(ctx, each_value, i);\n\n\t\t\t\t\tif (each_blocks[i]) {\n\t\t\t\t\t\teach_blocks[i].p(child_ctx, dirty);\n\t\t\t\t\t} else {\n\t\t\t\t\t\teach_blocks[i] = create_each_block$1(child_ctx);\n\t\t\t\t\t\teach_blocks[i].c();\n\t\t\t\t\t\teach_blocks[i].m(ul, null);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor (; i < each_blocks.length; i += 1) {\n\t\t\t\t\teach_blocks[i].d(1);\n\t\t\t\t}\n\n\t\t\t\teach_blocks.length = each_value.length;\n\t\t\t}\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(nav);\n\t\t\tdestroy_each(each_blocks, detaching);\n\t\t}\n\t};\n}\n\n// (19:3) {#each range as v}\nfunction create_each_block$1(ctx) {\n\tlet li;\n\tlet a;\n\tlet t0_value = /*v*/ ctx[3] + 1 + \"\";\n\tlet t0;\n\tlet a_href_value;\n\tlet t1;\n\tlet li_class_value;\n\n\treturn {\n\t\tc() {\n\t\t\tli = element(\"li\");\n\t\t\ta = element(\"a\");\n\t\t\tt0 = text(t0_value);\n\t\t\tt1 = space();\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tli = claim_element(nodes, \"LI\", { class: true });\n\t\t\tvar li_nodes = children(li);\n\t\t\ta = claim_element(li_nodes, \"A\", { class: true, href: true });\n\t\t\tvar a_nodes = children(a);\n\t\t\tt0 = claim_text(a_nodes, t0_value);\n\t\t\ta_nodes.forEach(detach);\n\t\t\tt1 = claim_space(li_nodes);\n\t\t\tli_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(a, \"class\", \"page-link\");\n\t\t\tattr(a, \"href\", a_href_value = \"/\" + (/*v*/ ctx[3] ? /*v*/ ctx[3] + 1 : \"\"));\n\t\t\tattr(li, \"class\", li_class_value = \"page-item \" + (/*v*/ ctx[3] === /*page*/ ctx[1] ? \"active\" : \"\"));\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, li, anchor);\n\t\t\tappend(li, a);\n\t\t\tappend(a, t0);\n\t\t\tappend(li, t1);\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tif (dirty & /*range*/ 4 && t0_value !== (t0_value = /*v*/ ctx[3] + 1 + \"\")) set_data(t0, t0_value);\n\n\t\t\tif (dirty & /*range*/ 4 && a_href_value !== (a_href_value = \"/\" + (/*v*/ ctx[3] ? /*v*/ ctx[3] + 1 : \"\"))) {\n\t\t\t\tattr(a, \"href\", a_href_value);\n\t\t\t}\n\n\t\t\tif (dirty & /*range, page*/ 6 && li_class_value !== (li_class_value = \"page-item \" + (/*v*/ ctx[3] === /*page*/ ctx[1] ? \"active\" : \"\"))) {\n\t\t\t\tattr(li, \"class\", li_class_value);\n\t\t\t}\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(li);\n\t\t}\n\t};\n}\n\nfunction create_fragment$1(ctx) {\n\tlet if_block_anchor;\n\tlet if_block = /*articlesCount*/ ctx[0] > 10 && create_if_block$1(ctx);\n\n\treturn {\n\t\tc() {\n\t\t\tif (if_block) if_block.c();\n\t\t\tif_block_anchor = empty();\n\t\t},\n\t\tl(nodes) {\n\t\t\tif (if_block) if_block.l(nodes);\n\t\t\tif_block_anchor = empty();\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tif (if_block) if_block.m(target, anchor);\n\t\t\tinsert(target, if_block_anchor, anchor);\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tif (/*articlesCount*/ ctx[0] > 10) {\n\t\t\t\tif (if_block) {\n\t\t\t\t\tif_block.p(ctx, dirty);\n\t\t\t\t} else {\n\t\t\t\t\tif_block = create_if_block$1(ctx);\n\t\t\t\t\tif_block.c();\n\t\t\t\t\tif_block.m(if_block_anchor.parentNode, if_block_anchor);\n\t\t\t\t}\n\t\t\t} else if (if_block) {\n\t\t\t\tif_block.d(1);\n\t\t\t\tif_block = null;\n\t\t\t}\n\t\t},\n\t\ti: noop,\n\t\to: noop,\n\t\td(detaching) {\n\t\t\tif (if_block) if_block.d(detaching);\n\t\t\tif (detaching) detach(if_block_anchor);\n\t\t}\n\t};\n}\n\nfunction instance$1($$self, $$props, $$invalidate) {\n\tlet { articlesCount } = $$props;\n\tlet { page } = $$props;\n\tlet range;\n\n\t$$self.$set = $$props => {\n\t\tif (\"articlesCount\" in $$props) $$invalidate(0, articlesCount = $$props.articlesCount);\n\t\tif (\"page\" in $$props) $$invalidate(1, page = $$props.page);\n\t};\n\n\t$$self.$$.update = () => {\n\t\tif ($$self.$$.dirty & /*articlesCount, range*/ 5) {\n\t\t\t {\n\t\t\t\t$$invalidate(2, range = []);\n\n\t\t\t\tfor (let i = 0; i < Math.ceil(articlesCount / 10); ++i) {\n\t\t\t\t\trange.push(i);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t};\n\n\treturn [articlesCount, page, range];\n}\n\nclass ListPagination extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance$1, create_fragment$1, safe_not_equal, { articlesCount: 0, page: 1 });\n\t}\n}\n\n/* src/routes/_components/ArticleList/index.svelte generated by Svelte v3.23.2 */\n\nfunction get_each_context$2(ctx, list, i) {\n\tconst child_ctx = ctx.slice();\n\tchild_ctx[13] = list[i];\n\treturn child_ctx;\n}\n\n// (53:0) {:else}\nfunction create_else_block_1(ctx) {\n\tlet div;\n\tlet t;\n\n\treturn {\n\t\tc() {\n\t\t\tdiv = element(\"div\");\n\t\t\tt = text(\"Loading...\");\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tdiv = claim_element(nodes, \"DIV\", { class: true });\n\t\t\tvar div_nodes = children(div);\n\t\t\tt = claim_text(div_nodes, \"Loading...\");\n\t\t\tdiv_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(div, \"class\", \"article-preview\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, div, anchor);\n\t\t\tappend(div, t);\n\t\t},\n\t\tp: noop,\n\t\ti: noop,\n\t\to: noop,\n\t\td(detaching) {\n\t\t\tif (detaching) detach(div);\n\t\t}\n\t};\n}\n\n// (39:0) {#if articles}\nfunction create_if_block$2(ctx) {\n\tlet current_block_type_index;\n\tlet if_block;\n\tlet if_block_anchor;\n\tlet current;\n\tconst if_block_creators = [create_if_block_1, create_else_block];\n\tconst if_blocks = [];\n\n\tfunction select_block_type_1(ctx, dirty) {\n\t\tif (/*articles*/ ctx[0].length === 0) return 0;\n\t\treturn 1;\n\t}\n\n\tcurrent_block_type_index = select_block_type_1(ctx);\n\tif_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);\n\n\treturn {\n\t\tc() {\n\t\t\tif_block.c();\n\t\t\tif_block_anchor = empty();\n\t\t},\n\t\tl(nodes) {\n\t\t\tif_block.l(nodes);\n\t\t\tif_block_anchor = empty();\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tif_blocks[current_block_type_index].m(target, anchor);\n\t\t\tinsert(target, if_block_anchor, anchor);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tlet previous_block_index = current_block_type_index;\n\t\t\tcurrent_block_type_index = select_block_type_1(ctx);\n\n\t\t\tif (current_block_type_index === previous_block_index) {\n\t\t\t\tif_blocks[current_block_type_index].p(ctx, dirty);\n\t\t\t} else {\n\t\t\t\tgroup_outros();\n\n\t\t\t\ttransition_out(if_blocks[previous_block_index], 1, 1, () => {\n\t\t\t\t\tif_blocks[previous_block_index] = null;\n\t\t\t\t});\n\n\t\t\t\tcheck_outros();\n\t\t\t\tif_block = if_blocks[current_block_type_index];\n\n\t\t\t\tif (!if_block) {\n\t\t\t\t\tif_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);\n\t\t\t\t\tif_block.c();\n\t\t\t\t}\n\n\t\t\t\ttransition_in(if_block, 1);\n\t\t\t\tif_block.m(if_block_anchor.parentNode, if_block_anchor);\n\t\t\t}\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(if_block);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(if_block);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif_blocks[current_block_type_index].d(detaching);\n\t\t\tif (detaching) detach(if_block_anchor);\n\t\t}\n\t};\n}\n\n// (44:1) {:else}\nfunction create_else_block(ctx) {\n\tlet div;\n\tlet each_blocks = [];\n\tlet each_1_lookup = new Map();\n\tlet t;\n\tlet listpagination;\n\tlet current;\n\tlet each_value = /*articles*/ ctx[0];\n\tconst get_key = ctx => /*article*/ ctx[13].slug;\n\n\tfor (let i = 0; i < each_value.length; i += 1) {\n\t\tlet child_ctx = get_each_context$2(ctx, each_value, i);\n\t\tlet key = get_key(child_ctx);\n\t\teach_1_lookup.set(key, each_blocks[i] = create_each_block$2(key, child_ctx));\n\t}\n\n\tlistpagination = new ListPagination({\n\t\t\tprops: {\n\t\t\t\tarticlesCount: /*articlesCount*/ ctx[1],\n\t\t\t\tpage: parseInt(/*$page*/ ctx[3].params.user, 10)\n\t\t\t}\n\t\t});\n\n\treturn {\n\t\tc() {\n\t\t\tdiv = element(\"div\");\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].c();\n\t\t\t}\n\n\t\t\tt = space();\n\t\t\tcreate_component(listpagination.$$.fragment);\n\t\t},\n\t\tl(nodes) {\n\t\t\tdiv = claim_element(nodes, \"DIV\", {});\n\t\t\tvar div_nodes = children(div);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].l(div_nodes);\n\t\t\t}\n\n\t\t\tt = claim_space(div_nodes);\n\t\t\tclaim_component(listpagination.$$.fragment, div_nodes);\n\t\t\tdiv_nodes.forEach(detach);\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, div, anchor);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].m(div, null);\n\t\t\t}\n\n\t\t\tappend(div, t);\n\t\t\tmount_component(listpagination, div, null);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tif (dirty & /*articles, $session*/ 5) {\n\t\t\t\tconst each_value = /*articles*/ ctx[0];\n\t\t\t\tgroup_outros();\n\t\t\t\teach_blocks = update_keyed_each(each_blocks, dirty, get_key, 1, ctx, each_value, each_1_lookup, div, outro_and_destroy_block, create_each_block$2, t, get_each_context$2);\n\t\t\t\tcheck_outros();\n\t\t\t}\n\n\t\t\tconst listpagination_changes = {};\n\t\t\tif (dirty & /*articlesCount*/ 2) listpagination_changes.articlesCount = /*articlesCount*/ ctx[1];\n\t\t\tif (dirty & /*$page*/ 8) listpagination_changes.page = parseInt(/*$page*/ ctx[3].params.user, 10);\n\t\t\tlistpagination.$set(listpagination_changes);\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\n\t\t\tfor (let i = 0; i < each_value.length; i += 1) {\n\t\t\t\ttransition_in(each_blocks[i]);\n\t\t\t}\n\n\t\t\ttransition_in(listpagination.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\ttransition_out(each_blocks[i]);\n\t\t\t}\n\n\t\t\ttransition_out(listpagination.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(div);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].d();\n\t\t\t}\n\n\t\t\tdestroy_component(listpagination);\n\t\t}\n\t};\n}\n\n// (40:1) {#if articles.length === 0}\nfunction create_if_block_1(ctx) {\n\tlet div;\n\tlet t;\n\n\treturn {\n\t\tc() {\n\t\t\tdiv = element(\"div\");\n\t\t\tt = text(\"No articles are here... yet.\");\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tdiv = claim_element(nodes, \"DIV\", { class: true });\n\t\t\tvar div_nodes = children(div);\n\t\t\tt = claim_text(div_nodes, \"No articles are here... yet.\");\n\t\t\tdiv_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(div, \"class\", \"article-preview\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, div, anchor);\n\t\t\tappend(div, t);\n\t\t},\n\t\tp: noop,\n\t\ti: noop,\n\t\to: noop,\n\t\td(detaching) {\n\t\t\tif (detaching) detach(div);\n\t\t}\n\t};\n}\n\n// (46:3) {#each articles as article (article.slug)}\nfunction create_each_block$2(key_1, ctx) {\n\tlet first;\n\tlet articlepreview;\n\tlet current;\n\n\tarticlepreview = new ArticlePreview({\n\t\t\tprops: {\n\t\t\t\tarticle: /*article*/ ctx[13],\n\t\t\t\tuser: /*$session*/ ctx[2].user\n\t\t\t}\n\t\t});\n\n\treturn {\n\t\tkey: key_1,\n\t\tfirst: null,\n\t\tc() {\n\t\t\tfirst = empty();\n\t\t\tcreate_component(articlepreview.$$.fragment);\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tfirst = empty();\n\t\t\tclaim_component(articlepreview.$$.fragment, nodes);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tthis.first = first;\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, first, anchor);\n\t\t\tmount_component(articlepreview, target, anchor);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tconst articlepreview_changes = {};\n\t\t\tif (dirty & /*articles*/ 1) articlepreview_changes.article = /*article*/ ctx[13];\n\t\t\tif (dirty & /*$session*/ 4) articlepreview_changes.user = /*$session*/ ctx[2].user;\n\t\t\tarticlepreview.$set(articlepreview_changes);\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(articlepreview.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(articlepreview.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(first);\n\t\t\tdestroy_component(articlepreview, detaching);\n\t\t}\n\t};\n}\n\nfunction create_fragment$2(ctx) {\n\tlet current_block_type_index;\n\tlet if_block;\n\tlet if_block_anchor;\n\tlet current;\n\tconst if_block_creators = [create_if_block$2, create_else_block_1];\n\tconst if_blocks = [];\n\n\tfunction select_block_type(ctx, dirty) {\n\t\tif (/*articles*/ ctx[0]) return 0;\n\t\treturn 1;\n\t}\n\n\tcurrent_block_type_index = select_block_type(ctx);\n\tif_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);\n\n\treturn {\n\t\tc() {\n\t\t\tif_block.c();\n\t\t\tif_block_anchor = empty();\n\t\t},\n\t\tl(nodes) {\n\t\t\tif_block.l(nodes);\n\t\t\tif_block_anchor = empty();\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tif_blocks[current_block_type_index].m(target, anchor);\n\t\t\tinsert(target, if_block_anchor, anchor);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tlet previous_block_index = current_block_type_index;\n\t\t\tcurrent_block_type_index = select_block_type(ctx);\n\n\t\t\tif (current_block_type_index === previous_block_index) {\n\t\t\t\tif_blocks[current_block_type_index].p(ctx, dirty);\n\t\t\t} else {\n\t\t\t\tgroup_outros();\n\n\t\t\t\ttransition_out(if_blocks[previous_block_index], 1, 1, () => {\n\t\t\t\t\tif_blocks[previous_block_index] = null;\n\t\t\t\t});\n\n\t\t\t\tcheck_outros();\n\t\t\t\tif_block = if_blocks[current_block_type_index];\n\n\t\t\t\tif (!if_block) {\n\t\t\t\t\tif_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);\n\t\t\t\t\tif_block.c();\n\t\t\t\t}\n\n\t\t\t\ttransition_in(if_block, 1);\n\t\t\t\tif_block.m(if_block_anchor.parentNode, if_block_anchor);\n\t\t\t}\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(if_block);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(if_block);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif_blocks[current_block_type_index].d(detaching);\n\t\t\tif (detaching) detach(if_block_anchor);\n\t\t}\n\t};\n}\n\nfunction instance$2($$self, $$props, $$invalidate) {\n\tlet $session;\n\tlet $page;\n\tlet { tab } = $$props, { username = false } = $$props;\n\tlet { favorites = false } = $$props;\n\tlet { tag } = $$props;\n\tlet { p } = $$props;\n\tconst { session, page } = stores$1();\n\tcomponent_subscribe($$self, session, value => $$invalidate(2, $session = value));\n\tcomponent_subscribe($$self, page, value => $$invalidate(3, $page = value));\n\tlet query;\n\tlet articles;\n\tlet articlesCount;\n\n\tasync function getData() {\n\t\t$$invalidate(0, articles = null);\n\n\t\t// TODO do we need some error handling here?\n\t\t$$invalidate(0, { articles, articlesCount } = await get(query, $session.user && $session.user.token), articles, $$invalidate(1, articlesCount));\n\t}\n\n\t$$self.$set = $$props => {\n\t\tif (\"tab\" in $$props) $$invalidate(6, tab = $$props.tab);\n\t\tif (\"username\" in $$props) $$invalidate(7, username = $$props.username);\n\t\tif (\"favorites\" in $$props) $$invalidate(8, favorites = $$props.favorites);\n\t\tif (\"tag\" in $$props) $$invalidate(9, tag = $$props.tag);\n\t\tif (\"p\" in $$props) $$invalidate(10, p = $$props.p);\n\t};\n\n\t$$self.$$.update = () => {\n\t\tif ($$self.$$.dirty & /*tab, p, tag, favorites, username*/ 1984) {\n\t\t\t {\n\t\t\t\tconst endpoint = tab === \"feed\" ? \"articles/feed\" : \"articles\";\n\t\t\t\tconst page_size = tab === \"feed\" ? 5 : 10;\n\t\t\t\tlet params = `limit=${page_size}&offset=${(p - 1) * page_size}`;\n\t\t\t\tif (tab === \"tag\") params += `&tag=${tag}`;\n\t\t\t\tif (tab === \"profile\") params += `&${favorites ? \"favorited\" : \"author\"}=${encodeURIComponent(username)}`;\n\t\t\t\t$$invalidate(11, query = `${endpoint}?${params}`);\n\t\t\t}\n\t\t}\n\n\t\tif ($$self.$$.dirty & /*query*/ 2048) {\n\t\t\t query && getData();\n\t\t}\n\t};\n\n\treturn [\n\t\tarticles,\n\t\tarticlesCount,\n\t\t$session,\n\t\t$page,\n\t\tsession,\n\t\tpage,\n\t\ttab,\n\t\tusername,\n\t\tfavorites,\n\t\ttag,\n\t\tp\n\t];\n}\n\nclass ArticleList extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\n\t\tinit(this, options, instance$2, create_fragment$2, safe_not_equal, {\n\t\t\ttab: 6,\n\t\t\tusername: 7,\n\t\t\tfavorites: 8,\n\t\t\ttag: 9,\n\t\t\tp: 10\n\t\t});\n\t}\n}\n\nexport { ArticleList as A };\n",
      "dynamicImports":[

      ],
      "exports":[
         "A"
      ],
      "facadeModuleId":null,
      "fileName":"index.dccd3ebe.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[
         "client.9f4f62db.js",
         "api.5c9dd840.js"
      ],
      "isDynamicEntry":false,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/src/routes/_components/ArticleList/ArticlePreview.svelte":{
            "originalLength":1481,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":11020
         },
         "/home/bmccann/src/svelte-realworld/src/routes/_components/ArticleList/ListPagination.svelte":{
            "originalLength":425,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":5036
         },
         "/home/bmccann/src/svelte-realworld/src/routes/_components/ArticleList/index.svelte":{
            "originalLength":1383,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":10847
         }
      },
      "name":"index",
      "type":"chunk"
   },
   {
      "code":"import { S as SvelteComponent, i as init, s as safe_not_equal, f as space, e as element, g as text, c as create_component, D as query_selector_all, k as detach, l as claim_space, h as claim_element, j as children, o as claim_text, a as claim_component, p as attr, q as insert, r as append, m as mount_component, K as set_input_value, u as listen, L as prevent_default, t as transition_in, b as transition_out, d as destroy_component, M as run_all, w as stores$1, x as component_subscribe, N as set_store_value, O as goto } from './client.9f4f62db.js';\nimport { L as ListErrors } from './ListErrors.ab5b20bd.js';\nimport { p as post } from './utils.d5c0e45a.js';\n\n/* src/routes/register/index.svelte generated by Svelte v3.23.2 */\n\nfunction create_fragment(ctx) {\n\tlet t0;\n\tlet div3;\n\tlet div2;\n\tlet div1;\n\tlet div0;\n\tlet h1;\n\tlet t1;\n\tlet t2;\n\tlet p;\n\tlet a;\n\tlet t3;\n\tlet t4;\n\tlet listerrors;\n\tlet t5;\n\tlet form;\n\tlet fieldset0;\n\tlet input0;\n\tlet t6;\n\tlet fieldset1;\n\tlet input1;\n\tlet t7;\n\tlet fieldset2;\n\tlet input2;\n\tlet t8;\n\tlet button;\n\tlet t9;\n\tlet current;\n\tlet mounted;\n\tlet dispose;\n\tlisterrors = new ListErrors({ props: { errors: /*errors*/ ctx[3] } });\n\n\treturn {\n\t\tc() {\n\t\t\tt0 = space();\n\t\t\tdiv3 = element(\"div\");\n\t\t\tdiv2 = element(\"div\");\n\t\t\tdiv1 = element(\"div\");\n\t\t\tdiv0 = element(\"div\");\n\t\t\th1 = element(\"h1\");\n\t\t\tt1 = text(\"Sign up\");\n\t\t\tt2 = space();\n\t\t\tp = element(\"p\");\n\t\t\ta = element(\"a\");\n\t\t\tt3 = text(\"Have an account?\");\n\t\t\tt4 = space();\n\t\t\tcreate_component(listerrors.$$.fragment);\n\t\t\tt5 = space();\n\t\t\tform = element(\"form\");\n\t\t\tfieldset0 = element(\"fieldset\");\n\t\t\tinput0 = element(\"input\");\n\t\t\tt6 = space();\n\t\t\tfieldset1 = element(\"fieldset\");\n\t\t\tinput1 = element(\"input\");\n\t\t\tt7 = space();\n\t\t\tfieldset2 = element(\"fieldset\");\n\t\t\tinput2 = element(\"input\");\n\t\t\tt8 = space();\n\t\t\tbutton = element(\"button\");\n\t\t\tt9 = text(\"Sign up\");\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tconst head_nodes = query_selector_all(\"[data-svelte=\\\"svelte-15rwypm\\\"]\", document.head);\n\t\t\thead_nodes.forEach(detach);\n\t\t\tt0 = claim_space(nodes);\n\t\t\tdiv3 = claim_element(nodes, \"DIV\", { class: true });\n\t\t\tvar div3_nodes = children(div3);\n\t\t\tdiv2 = claim_element(div3_nodes, \"DIV\", { class: true });\n\t\t\tvar div2_nodes = children(div2);\n\t\t\tdiv1 = claim_element(div2_nodes, \"DIV\", { class: true });\n\t\t\tvar div1_nodes = children(div1);\n\t\t\tdiv0 = claim_element(div1_nodes, \"DIV\", { class: true });\n\t\t\tvar div0_nodes = children(div0);\n\t\t\th1 = claim_element(div0_nodes, \"H1\", { class: true });\n\t\t\tvar h1_nodes = children(h1);\n\t\t\tt1 = claim_text(h1_nodes, \"Sign up\");\n\t\t\th1_nodes.forEach(detach);\n\t\t\tt2 = claim_space(div0_nodes);\n\t\t\tp = claim_element(div0_nodes, \"P\", { class: true });\n\t\t\tvar p_nodes = children(p);\n\t\t\ta = claim_element(p_nodes, \"A\", { href: true });\n\t\t\tvar a_nodes = children(a);\n\t\t\tt3 = claim_text(a_nodes, \"Have an account?\");\n\t\t\ta_nodes.forEach(detach);\n\t\t\tp_nodes.forEach(detach);\n\t\t\tt4 = claim_space(div0_nodes);\n\t\t\tclaim_component(listerrors.$$.fragment, div0_nodes);\n\t\t\tt5 = claim_space(div0_nodes);\n\t\t\tform = claim_element(div0_nodes, \"FORM\", {});\n\t\t\tvar form_nodes = children(form);\n\t\t\tfieldset0 = claim_element(form_nodes, \"FIELDSET\", { class: true });\n\t\t\tvar fieldset0_nodes = children(fieldset0);\n\n\t\t\tinput0 = claim_element(fieldset0_nodes, \"INPUT\", {\n\t\t\t\tclass: true,\n\t\t\t\ttype: true,\n\t\t\t\tplaceholder: true\n\t\t\t});\n\n\t\t\tfieldset0_nodes.forEach(detach);\n\t\t\tt6 = claim_space(form_nodes);\n\t\t\tfieldset1 = claim_element(form_nodes, \"FIELDSET\", { class: true });\n\t\t\tvar fieldset1_nodes = children(fieldset1);\n\n\t\t\tinput1 = claim_element(fieldset1_nodes, \"INPUT\", {\n\t\t\t\tclass: true,\n\t\t\t\ttype: true,\n\t\t\t\tplaceholder: true\n\t\t\t});\n\n\t\t\tfieldset1_nodes.forEach(detach);\n\t\t\tt7 = claim_space(form_nodes);\n\t\t\tfieldset2 = claim_element(form_nodes, \"FIELDSET\", { class: true });\n\t\t\tvar fieldset2_nodes = children(fieldset2);\n\n\t\t\tinput2 = claim_element(fieldset2_nodes, \"INPUT\", {\n\t\t\t\tclass: true,\n\t\t\t\ttype: true,\n\t\t\t\tplaceholder: true\n\t\t\t});\n\n\t\t\tfieldset2_nodes.forEach(detach);\n\t\t\tt8 = claim_space(form_nodes);\n\t\t\tbutton = claim_element(form_nodes, \"BUTTON\", { class: true });\n\t\t\tvar button_nodes = children(button);\n\t\t\tt9 = claim_text(button_nodes, \"Sign up\");\n\t\t\tbutton_nodes.forEach(detach);\n\t\t\tform_nodes.forEach(detach);\n\t\t\tdiv0_nodes.forEach(detach);\n\t\t\tdiv1_nodes.forEach(detach);\n\t\t\tdiv2_nodes.forEach(detach);\n\t\t\tdiv3_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tdocument.title = \"Sign up • Conduit\";\n\t\t\tattr(h1, \"class\", \"text-xs-center\");\n\t\t\tattr(a, \"href\", \"/login\");\n\t\t\tattr(p, \"class\", \"text-xs-center\");\n\t\t\tattr(input0, \"class\", \"form-control form-control-lg\");\n\t\t\tattr(input0, \"type\", \"text\");\n\t\t\tattr(input0, \"placeholder\", \"Your Name\");\n\t\t\tattr(fieldset0, \"class\", \"form-group\");\n\t\t\tattr(input1, \"class\", \"form-control form-control-lg\");\n\t\t\tattr(input1, \"type\", \"text\");\n\t\t\tattr(input1, \"placeholder\", \"Email\");\n\t\t\tattr(fieldset1, \"class\", \"form-group\");\n\t\t\tattr(input2, \"class\", \"form-control form-control-lg\");\n\t\t\tattr(input2, \"type\", \"password\");\n\t\t\tattr(input2, \"placeholder\", \"Password\");\n\t\t\tattr(fieldset2, \"class\", \"form-group\");\n\t\t\tattr(button, \"class\", \"btn btn-lg btn-primary pull-xs-right\");\n\t\t\tattr(div0, \"class\", \"col-md-6 offset-md-3 col-xs-12\");\n\t\t\tattr(div1, \"class\", \"row\");\n\t\t\tattr(div2, \"class\", \"container page\");\n\t\t\tattr(div3, \"class\", \"auth-page\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, t0, anchor);\n\t\t\tinsert(target, div3, anchor);\n\t\t\tappend(div3, div2);\n\t\t\tappend(div2, div1);\n\t\t\tappend(div1, div0);\n\t\t\tappend(div0, h1);\n\t\t\tappend(h1, t1);\n\t\t\tappend(div0, t2);\n\t\t\tappend(div0, p);\n\t\t\tappend(p, a);\n\t\t\tappend(a, t3);\n\t\t\tappend(div0, t4);\n\t\t\tmount_component(listerrors, div0, null);\n\t\t\tappend(div0, t5);\n\t\t\tappend(div0, form);\n\t\t\tappend(form, fieldset0);\n\t\t\tappend(fieldset0, input0);\n\t\t\tset_input_value(input0, /*username*/ ctx[0]);\n\t\t\tappend(form, t6);\n\t\t\tappend(form, fieldset1);\n\t\t\tappend(fieldset1, input1);\n\t\t\tset_input_value(input1, /*email*/ ctx[1]);\n\t\t\tappend(form, t7);\n\t\t\tappend(form, fieldset2);\n\t\t\tappend(fieldset2, input2);\n\t\t\tset_input_value(input2, /*password*/ ctx[2]);\n\t\t\tappend(form, t8);\n\t\t\tappend(form, button);\n\t\t\tappend(button, t9);\n\t\t\tcurrent = true;\n\n\t\t\tif (!mounted) {\n\t\t\t\tdispose = [\n\t\t\t\t\tlisten(input0, \"input\", /*input0_input_handler*/ ctx[6]),\n\t\t\t\t\tlisten(input1, \"input\", /*input1_input_handler*/ ctx[7]),\n\t\t\t\t\tlisten(input2, \"input\", /*input2_input_handler*/ ctx[8]),\n\t\t\t\t\tlisten(form, \"submit\", prevent_default(/*submit*/ ctx[5]))\n\t\t\t\t];\n\n\t\t\t\tmounted = true;\n\t\t\t}\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tconst listerrors_changes = {};\n\t\t\tif (dirty & /*errors*/ 8) listerrors_changes.errors = /*errors*/ ctx[3];\n\t\t\tlisterrors.$set(listerrors_changes);\n\n\t\t\tif (dirty & /*username*/ 1 && input0.value !== /*username*/ ctx[0]) {\n\t\t\t\tset_input_value(input0, /*username*/ ctx[0]);\n\t\t\t}\n\n\t\t\tif (dirty & /*email*/ 2 && input1.value !== /*email*/ ctx[1]) {\n\t\t\t\tset_input_value(input1, /*email*/ ctx[1]);\n\t\t\t}\n\n\t\t\tif (dirty & /*password*/ 4 && input2.value !== /*password*/ ctx[2]) {\n\t\t\t\tset_input_value(input2, /*password*/ ctx[2]);\n\t\t\t}\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(listerrors.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(listerrors.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(t0);\n\t\t\tif (detaching) detach(div3);\n\t\t\tdestroy_component(listerrors);\n\t\t\tmounted = false;\n\t\t\trun_all(dispose);\n\t\t}\n\t};\n}\n\nfunction instance($$self, $$props, $$invalidate) {\n\tlet $session;\n\tconst { session } = stores$1();\n\tcomponent_subscribe($$self, session, value => $$invalidate(9, $session = value));\n\tlet username = \"\";\n\tlet email = \"\";\n\tlet password = \"\";\n\tlet errors = null;\n\n\tasync function submit(event) {\n\t\tconst response = await post(`auth/register`, { username, email, password });\n\n\t\t// TODO handle network errors\n\t\t$$invalidate(3, errors = response.errors);\n\n\t\tif (response.user) {\n\t\t\tset_store_value(session, $session.user = response.user, $session);\n\t\t\tgoto(\"/\");\n\t\t}\n\t}\n\n\tfunction input0_input_handler() {\n\t\tusername = this.value;\n\t\t$$invalidate(0, username);\n\t}\n\n\tfunction input1_input_handler() {\n\t\temail = this.value;\n\t\t$$invalidate(1, email);\n\t}\n\n\tfunction input2_input_handler() {\n\t\tpassword = this.value;\n\t\t$$invalidate(2, password);\n\t}\n\n\treturn [\n\t\tusername,\n\t\temail,\n\t\tpassword,\n\t\terrors,\n\t\tsession,\n\t\tsubmit,\n\t\tinput0_input_handler,\n\t\tinput1_input_handler,\n\t\tinput2_input_handler\n\t];\n}\n\nclass Register extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance, create_fragment, safe_not_equal, {});\n\t}\n}\n\nexport default Register;\n",
      "dynamicImports":[

      ],
      "exports":[
         "default"
      ],
      "facadeModuleId":"/home/bmccann/src/svelte-realworld/src/routes/register/index.svelte",
      "fileName":"index.38adfd86.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[
         "client.9f4f62db.js",
         "ListErrors.ab5b20bd.js",
         "utils.d5c0e45a.js"
      ],
      "isDynamicEntry":true,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/src/routes/register/index.svelte":{
            "originalLength":1520,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":7845
         }
      },
      "name":"index",
      "type":"chunk"
   },
   {
      "code":"import { S as SvelteComponent, i as init, s as safe_not_equal, e as element, h as claim_element, j as children, k as detach, p as attr, q as insert, g as text, f as space, o as claim_text, l as claim_space, r as append, v as set_data, A as destroy_each, y as empty, n as noop } from './client.9f4f62db.js';\n\n/* src/routes/_components/ListErrors.svelte generated by Svelte v3.23.2 */\n\nfunction get_each_context(ctx, list, i) {\n\tconst child_ctx = ctx.slice();\n\tchild_ctx[1] = list[i];\n\treturn child_ctx;\n}\n\n// (5:0) {#if errors}\nfunction create_if_block(ctx) {\n\tlet ul;\n\tlet each_value = Object.keys(/*errors*/ ctx[0]);\n\tlet each_blocks = [];\n\n\tfor (let i = 0; i < each_value.length; i += 1) {\n\t\teach_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));\n\t}\n\n\treturn {\n\t\tc() {\n\t\t\tul = element(\"ul\");\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].c();\n\t\t\t}\n\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tul = claim_element(nodes, \"UL\", { class: true });\n\t\t\tvar ul_nodes = children(ul);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].l(ul_nodes);\n\t\t\t}\n\n\t\t\tul_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(ul, \"class\", \"error-messages\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, ul, anchor);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].m(ul, null);\n\t\t\t}\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tif (dirty & /*errors, Object*/ 1) {\n\t\t\t\teach_value = Object.keys(/*errors*/ ctx[0]);\n\t\t\t\tlet i;\n\n\t\t\t\tfor (i = 0; i < each_value.length; i += 1) {\n\t\t\t\t\tconst child_ctx = get_each_context(ctx, each_value, i);\n\n\t\t\t\t\tif (each_blocks[i]) {\n\t\t\t\t\t\teach_blocks[i].p(child_ctx, dirty);\n\t\t\t\t\t} else {\n\t\t\t\t\t\teach_blocks[i] = create_each_block(child_ctx);\n\t\t\t\t\t\teach_blocks[i].c();\n\t\t\t\t\t\teach_blocks[i].m(ul, null);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor (; i < each_blocks.length; i += 1) {\n\t\t\t\t\teach_blocks[i].d(1);\n\t\t\t\t}\n\n\t\t\t\teach_blocks.length = each_value.length;\n\t\t\t}\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(ul);\n\t\t\tdestroy_each(each_blocks, detaching);\n\t\t}\n\t};\n}\n\n// (7:2) {#each Object.keys(errors) as key}\nfunction create_each_block(ctx) {\n\tlet li;\n\tlet t0_value = /*key*/ ctx[1] + \"\";\n\tlet t0;\n\tlet t1;\n\tlet t2_value = /*errors*/ ctx[0][/*key*/ ctx[1]] + \"\";\n\tlet t2;\n\n\treturn {\n\t\tc() {\n\t\t\tli = element(\"li\");\n\t\t\tt0 = text(t0_value);\n\t\t\tt1 = space();\n\t\t\tt2 = text(t2_value);\n\t\t},\n\t\tl(nodes) {\n\t\t\tli = claim_element(nodes, \"LI\", {});\n\t\t\tvar li_nodes = children(li);\n\t\t\tt0 = claim_text(li_nodes, t0_value);\n\t\t\tt1 = claim_space(li_nodes);\n\t\t\tt2 = claim_text(li_nodes, t2_value);\n\t\t\tli_nodes.forEach(detach);\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, li, anchor);\n\t\t\tappend(li, t0);\n\t\t\tappend(li, t1);\n\t\t\tappend(li, t2);\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tif (dirty & /*errors*/ 1 && t0_value !== (t0_value = /*key*/ ctx[1] + \"\")) set_data(t0, t0_value);\n\t\t\tif (dirty & /*errors*/ 1 && t2_value !== (t2_value = /*errors*/ ctx[0][/*key*/ ctx[1]] + \"\")) set_data(t2, t2_value);\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(li);\n\t\t}\n\t};\n}\n\nfunction create_fragment(ctx) {\n\tlet if_block_anchor;\n\tlet if_block = /*errors*/ ctx[0] && create_if_block(ctx);\n\n\treturn {\n\t\tc() {\n\t\t\tif (if_block) if_block.c();\n\t\t\tif_block_anchor = empty();\n\t\t},\n\t\tl(nodes) {\n\t\t\tif (if_block) if_block.l(nodes);\n\t\t\tif_block_anchor = empty();\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tif (if_block) if_block.m(target, anchor);\n\t\t\tinsert(target, if_block_anchor, anchor);\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tif (/*errors*/ ctx[0]) {\n\t\t\t\tif (if_block) {\n\t\t\t\t\tif_block.p(ctx, dirty);\n\t\t\t\t} else {\n\t\t\t\t\tif_block = create_if_block(ctx);\n\t\t\t\t\tif_block.c();\n\t\t\t\t\tif_block.m(if_block_anchor.parentNode, if_block_anchor);\n\t\t\t\t}\n\t\t\t} else if (if_block) {\n\t\t\t\tif_block.d(1);\n\t\t\t\tif_block = null;\n\t\t\t}\n\t\t},\n\t\ti: noop,\n\t\to: noop,\n\t\td(detaching) {\n\t\t\tif (if_block) if_block.d(detaching);\n\t\t\tif (detaching) detach(if_block_anchor);\n\t\t}\n\t};\n}\n\nfunction instance($$self, $$props, $$invalidate) {\n\tlet { errors } = $$props;\n\n\t$$self.$set = $$props => {\n\t\tif (\"errors\" in $$props) $$invalidate(0, errors = $$props.errors);\n\t};\n\n\treturn [errors];\n}\n\nclass ListErrors extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance, create_fragment, safe_not_equal, { errors: 0 });\n\t}\n}\n\nexport { ListErrors as L };\n",
      "dynamicImports":[

      ],
      "exports":[
         "L"
      ],
      "facadeModuleId":null,
      "fileName":"ListErrors.ab5b20bd.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[
         "client.9f4f62db.js"
      ],
      "isDynamicEntry":false,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/src/routes/_components/ListErrors.svelte":{
            "originalLength":173,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":3891
         }
      },
      "name":"ListErrors",
      "type":"chunk"
   },
   {
      "code":"function post(endpoint, data) {\n\treturn fetch(endpoint, {\n\t\tmethod: 'POST',\n\t\tcredentials: 'include',\n\t\tbody: JSON.stringify(data),\n\t\theaders: {\n\t\t\t'Content-Type': 'application/json'\n\t\t}\n\t}).then(r => r.json());\n}\n\nexport { post as p };\n",
      "dynamicImports":[

      ],
      "exports":[
         "p"
      ],
      "facadeModuleId":null,
      "fileName":"utils.d5c0e45a.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[

      ],
      "isDynamicEntry":false,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/src/node_modules/utils.js":{
            "originalLength":220,
            "removedExports":[

            ],
            "renderedExports":[
               "post"
            ],
            "renderedLength":213
         }
      },
      "name":"utils",
      "type":"chunk"
   },
   {
      "code":"import { S as SvelteComponent, i as init, s as safe_not_equal, e as element, f as space, g as text, h as claim_element, j as children, k as detach, l as claim_space, o as claim_text, p as attr, q as insert, r as append, K as set_input_value, u as listen, L as prevent_default, n as noop, M as run_all, z as createEventDispatcher, P as assign, c as create_component, D as query_selector_all, a as claim_component, m as mount_component, Q as get_spread_update, R as get_spread_object, t as transition_in, b as transition_out, d as destroy_component, w as stores$1, x as component_subscribe, N as set_store_value, O as goto } from './client.9f4f62db.js';\nimport { L as ListErrors } from './ListErrors.ab5b20bd.js';\nimport { p as post } from './utils.d5c0e45a.js';\n\n/* src/routes/settings/_SettingsForm.svelte generated by Svelte v3.23.2 */\n\nfunction create_fragment(ctx) {\n\tlet form;\n\tlet fieldset5;\n\tlet fieldset0;\n\tlet input0;\n\tlet t0;\n\tlet fieldset1;\n\tlet input1;\n\tlet t1;\n\tlet fieldset2;\n\tlet textarea;\n\tlet t2;\n\tlet fieldset3;\n\tlet input2;\n\tlet t3;\n\tlet fieldset4;\n\tlet input3;\n\tlet t4;\n\tlet button;\n\tlet t5;\n\tlet mounted;\n\tlet dispose;\n\n\treturn {\n\t\tc() {\n\t\t\tform = element(\"form\");\n\t\t\tfieldset5 = element(\"fieldset\");\n\t\t\tfieldset0 = element(\"fieldset\");\n\t\t\tinput0 = element(\"input\");\n\t\t\tt0 = space();\n\t\t\tfieldset1 = element(\"fieldset\");\n\t\t\tinput1 = element(\"input\");\n\t\t\tt1 = space();\n\t\t\tfieldset2 = element(\"fieldset\");\n\t\t\ttextarea = element(\"textarea\");\n\t\t\tt2 = space();\n\t\t\tfieldset3 = element(\"fieldset\");\n\t\t\tinput2 = element(\"input\");\n\t\t\tt3 = space();\n\t\t\tfieldset4 = element(\"fieldset\");\n\t\t\tinput3 = element(\"input\");\n\t\t\tt4 = space();\n\t\t\tbutton = element(\"button\");\n\t\t\tt5 = text(\"Update Settings\");\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tform = claim_element(nodes, \"FORM\", {});\n\t\t\tvar form_nodes = children(form);\n\t\t\tfieldset5 = claim_element(form_nodes, \"FIELDSET\", {});\n\t\t\tvar fieldset5_nodes = children(fieldset5);\n\t\t\tfieldset0 = claim_element(fieldset5_nodes, \"FIELDSET\", { class: true });\n\t\t\tvar fieldset0_nodes = children(fieldset0);\n\n\t\t\tinput0 = claim_element(fieldset0_nodes, \"INPUT\", {\n\t\t\t\tclass: true,\n\t\t\t\ttype: true,\n\t\t\t\tplaceholder: true\n\t\t\t});\n\n\t\t\tfieldset0_nodes.forEach(detach);\n\t\t\tt0 = claim_space(fieldset5_nodes);\n\t\t\tfieldset1 = claim_element(fieldset5_nodes, \"FIELDSET\", { class: true });\n\t\t\tvar fieldset1_nodes = children(fieldset1);\n\n\t\t\tinput1 = claim_element(fieldset1_nodes, \"INPUT\", {\n\t\t\t\tclass: true,\n\t\t\t\ttype: true,\n\t\t\t\tplaceholder: true\n\t\t\t});\n\n\t\t\tfieldset1_nodes.forEach(detach);\n\t\t\tt1 = claim_space(fieldset5_nodes);\n\t\t\tfieldset2 = claim_element(fieldset5_nodes, \"FIELDSET\", { class: true });\n\t\t\tvar fieldset2_nodes = children(fieldset2);\n\n\t\t\ttextarea = claim_element(fieldset2_nodes, \"TEXTAREA\", {\n\t\t\t\tclass: true,\n\t\t\t\trows: true,\n\t\t\t\tplaceholder: true\n\t\t\t});\n\n\t\t\tchildren(textarea).forEach(detach);\n\t\t\tfieldset2_nodes.forEach(detach);\n\t\t\tt2 = claim_space(fieldset5_nodes);\n\t\t\tfieldset3 = claim_element(fieldset5_nodes, \"FIELDSET\", { class: true });\n\t\t\tvar fieldset3_nodes = children(fieldset3);\n\n\t\t\tinput2 = claim_element(fieldset3_nodes, \"INPUT\", {\n\t\t\t\tclass: true,\n\t\t\t\ttype: true,\n\t\t\t\tplaceholder: true\n\t\t\t});\n\n\t\t\tfieldset3_nodes.forEach(detach);\n\t\t\tt3 = claim_space(fieldset5_nodes);\n\t\t\tfieldset4 = claim_element(fieldset5_nodes, \"FIELDSET\", { class: true });\n\t\t\tvar fieldset4_nodes = children(fieldset4);\n\n\t\t\tinput3 = claim_element(fieldset4_nodes, \"INPUT\", {\n\t\t\t\tclass: true,\n\t\t\t\ttype: true,\n\t\t\t\tplaceholder: true\n\t\t\t});\n\n\t\t\tfieldset4_nodes.forEach(detach);\n\t\t\tt4 = claim_space(fieldset5_nodes);\n\t\t\tbutton = claim_element(fieldset5_nodes, \"BUTTON\", { class: true, type: true, disabled: true });\n\t\t\tvar button_nodes = children(button);\n\t\t\tt5 = claim_text(button_nodes, \"Update Settings\");\n\t\t\tbutton_nodes.forEach(detach);\n\t\t\tfieldset5_nodes.forEach(detach);\n\t\t\tform_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(input0, \"class\", \"form-control\");\n\t\t\tattr(input0, \"type\", \"text\");\n\t\t\tattr(input0, \"placeholder\", \"URL of profile picture\");\n\t\t\tattr(fieldset0, \"class\", \"form-group\");\n\t\t\tattr(input1, \"class\", \"form-control form-control-lg\");\n\t\t\tattr(input1, \"type\", \"text\");\n\t\t\tattr(input1, \"placeholder\", \"Username\");\n\t\t\tattr(fieldset1, \"class\", \"form-group\");\n\t\t\tattr(textarea, \"class\", \"form-control form-control-lg\");\n\t\t\tattr(textarea, \"rows\", \"8\");\n\t\t\tattr(textarea, \"placeholder\", \"Short bio about you\");\n\t\t\tattr(fieldset2, \"class\", \"form-group\");\n\t\t\tattr(input2, \"class\", \"form-control form-control-lg\");\n\t\t\tattr(input2, \"type\", \"email\");\n\t\t\tattr(input2, \"placeholder\", \"Email\");\n\t\t\tattr(fieldset3, \"class\", \"form-group\");\n\t\t\tattr(input3, \"class\", \"form-control form-control-lg\");\n\t\t\tattr(input3, \"type\", \"password\");\n\t\t\tattr(input3, \"placeholder\", \"New Password\");\n\t\t\tattr(fieldset4, \"class\", \"form-group\");\n\t\t\tattr(button, \"class\", \"btn btn-lg btn-primary pull-xs-right\");\n\t\t\tattr(button, \"type\", \"submit\");\n\t\t\tbutton.disabled = /*inProgress*/ ctx[5];\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, form, anchor);\n\t\t\tappend(form, fieldset5);\n\t\t\tappend(fieldset5, fieldset0);\n\t\t\tappend(fieldset0, input0);\n\t\t\tset_input_value(input0, /*image*/ ctx[0]);\n\t\t\tappend(fieldset5, t0);\n\t\t\tappend(fieldset5, fieldset1);\n\t\t\tappend(fieldset1, input1);\n\t\t\tset_input_value(input1, /*username*/ ctx[1]);\n\t\t\tappend(fieldset5, t1);\n\t\t\tappend(fieldset5, fieldset2);\n\t\t\tappend(fieldset2, textarea);\n\t\t\tset_input_value(textarea, /*bio*/ ctx[2]);\n\t\t\tappend(fieldset5, t2);\n\t\t\tappend(fieldset5, fieldset3);\n\t\t\tappend(fieldset3, input2);\n\t\t\tset_input_value(input2, /*email*/ ctx[3]);\n\t\t\tappend(fieldset5, t3);\n\t\t\tappend(fieldset5, fieldset4);\n\t\t\tappend(fieldset4, input3);\n\t\t\tset_input_value(input3, /*password*/ ctx[4]);\n\t\t\tappend(fieldset5, t4);\n\t\t\tappend(fieldset5, button);\n\t\t\tappend(button, t5);\n\n\t\t\tif (!mounted) {\n\t\t\t\tdispose = [\n\t\t\t\t\tlisten(input0, \"input\", /*input0_input_handler*/ ctx[7]),\n\t\t\t\t\tlisten(input1, \"input\", /*input1_input_handler*/ ctx[8]),\n\t\t\t\t\tlisten(textarea, \"input\", /*textarea_input_handler*/ ctx[9]),\n\t\t\t\t\tlisten(input2, \"input\", /*input2_input_handler*/ ctx[10]),\n\t\t\t\t\tlisten(input3, \"input\", /*input3_input_handler*/ ctx[11]),\n\t\t\t\t\tlisten(form, \"submit\", prevent_default(/*submit*/ ctx[6]))\n\t\t\t\t];\n\n\t\t\t\tmounted = true;\n\t\t\t}\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tif (dirty & /*image*/ 1 && input0.value !== /*image*/ ctx[0]) {\n\t\t\t\tset_input_value(input0, /*image*/ ctx[0]);\n\t\t\t}\n\n\t\t\tif (dirty & /*username*/ 2 && input1.value !== /*username*/ ctx[1]) {\n\t\t\t\tset_input_value(input1, /*username*/ ctx[1]);\n\t\t\t}\n\n\t\t\tif (dirty & /*bio*/ 4) {\n\t\t\t\tset_input_value(textarea, /*bio*/ ctx[2]);\n\t\t\t}\n\n\t\t\tif (dirty & /*email*/ 8 && input2.value !== /*email*/ ctx[3]) {\n\t\t\t\tset_input_value(input2, /*email*/ ctx[3]);\n\t\t\t}\n\n\t\t\tif (dirty & /*password*/ 16 && input3.value !== /*password*/ ctx[4]) {\n\t\t\t\tset_input_value(input3, /*password*/ ctx[4]);\n\t\t\t}\n\n\t\t\tif (dirty & /*inProgress*/ 32) {\n\t\t\t\tbutton.disabled = /*inProgress*/ ctx[5];\n\t\t\t}\n\t\t},\n\t\ti: noop,\n\t\to: noop,\n\t\td(detaching) {\n\t\t\tif (detaching) detach(form);\n\t\t\tmounted = false;\n\t\t\trun_all(dispose);\n\t\t}\n\t};\n}\n\nfunction instance($$self, $$props, $$invalidate) {\n\tlet { inProgress } = $$props,\n\t\t{ image } = $$props,\n\t\t{ username } = $$props,\n\t\t{ bio } = $$props,\n\t\t{ email } = $$props,\n\t\t{ password = \"\" } = $$props;\n\n\tconst dispatch = createEventDispatcher();\n\n\tfunction submit(event) {\n\t\tdispatch(\"save\", { image, username, bio, email, password });\n\t}\n\n\tfunction input0_input_handler() {\n\t\timage = this.value;\n\t\t$$invalidate(0, image);\n\t}\n\n\tfunction input1_input_handler() {\n\t\tusername = this.value;\n\t\t$$invalidate(1, username);\n\t}\n\n\tfunction textarea_input_handler() {\n\t\tbio = this.value;\n\t\t$$invalidate(2, bio);\n\t}\n\n\tfunction input2_input_handler() {\n\t\temail = this.value;\n\t\t$$invalidate(3, email);\n\t}\n\n\tfunction input3_input_handler() {\n\t\tpassword = this.value;\n\t\t$$invalidate(4, password);\n\t}\n\n\t$$self.$set = $$props => {\n\t\tif (\"inProgress\" in $$props) $$invalidate(5, inProgress = $$props.inProgress);\n\t\tif (\"image\" in $$props) $$invalidate(0, image = $$props.image);\n\t\tif (\"username\" in $$props) $$invalidate(1, username = $$props.username);\n\t\tif (\"bio\" in $$props) $$invalidate(2, bio = $$props.bio);\n\t\tif (\"email\" in $$props) $$invalidate(3, email = $$props.email);\n\t\tif (\"password\" in $$props) $$invalidate(4, password = $$props.password);\n\t};\n\n\treturn [\n\t\timage,\n\t\tusername,\n\t\tbio,\n\t\temail,\n\t\tpassword,\n\t\tinProgress,\n\t\tsubmit,\n\t\tinput0_input_handler,\n\t\tinput1_input_handler,\n\t\ttextarea_input_handler,\n\t\tinput2_input_handler,\n\t\tinput3_input_handler\n\t];\n}\n\nclass SettingsForm extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\n\t\tinit(this, options, instance, create_fragment, safe_not_equal, {\n\t\t\tinProgress: 5,\n\t\t\timage: 0,\n\t\t\tusername: 1,\n\t\t\tbio: 2,\n\t\t\temail: 3,\n\t\t\tpassword: 4\n\t\t});\n\t}\n}\n\n/* src/routes/settings/index.svelte generated by Svelte v3.23.2 */\n\nfunction create_fragment$1(ctx) {\n\tlet t0;\n\tlet div3;\n\tlet div2;\n\tlet div1;\n\tlet div0;\n\tlet h1;\n\tlet t1;\n\tlet t2;\n\tlet listerrors;\n\tlet t3;\n\tlet settingsform;\n\tlet t4;\n\tlet hr;\n\tlet t5;\n\tlet button;\n\tlet t6;\n\tlet current;\n\tlet mounted;\n\tlet dispose;\n\tlisterrors = new ListErrors({ props: { errors: /*errors*/ ctx[1] } });\n\tconst settingsform_spread_levels = [/*$session*/ ctx[2].user, { inProgress: /*inProgress*/ ctx[0] }];\n\tlet settingsform_props = {};\n\n\tfor (let i = 0; i < settingsform_spread_levels.length; i += 1) {\n\t\tsettingsform_props = assign(settingsform_props, settingsform_spread_levels[i]);\n\t}\n\n\tsettingsform = new SettingsForm({ props: settingsform_props });\n\tsettingsform.$on(\"save\", /*save*/ ctx[5]);\n\n\treturn {\n\t\tc() {\n\t\t\tt0 = space();\n\t\t\tdiv3 = element(\"div\");\n\t\t\tdiv2 = element(\"div\");\n\t\t\tdiv1 = element(\"div\");\n\t\t\tdiv0 = element(\"div\");\n\t\t\th1 = element(\"h1\");\n\t\t\tt1 = text(\"Your Settings\");\n\t\t\tt2 = space();\n\t\t\tcreate_component(listerrors.$$.fragment);\n\t\t\tt3 = space();\n\t\t\tcreate_component(settingsform.$$.fragment);\n\t\t\tt4 = space();\n\t\t\thr = element(\"hr\");\n\t\t\tt5 = space();\n\t\t\tbutton = element(\"button\");\n\t\t\tt6 = text(\"Or click here to logout.\");\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tconst head_nodes = query_selector_all(\"[data-svelte=\\\"svelte-ync0zh\\\"]\", document.head);\n\t\t\thead_nodes.forEach(detach);\n\t\t\tt0 = claim_space(nodes);\n\t\t\tdiv3 = claim_element(nodes, \"DIV\", { class: true });\n\t\t\tvar div3_nodes = children(div3);\n\t\t\tdiv2 = claim_element(div3_nodes, \"DIV\", { class: true });\n\t\t\tvar div2_nodes = children(div2);\n\t\t\tdiv1 = claim_element(div2_nodes, \"DIV\", { class: true });\n\t\t\tvar div1_nodes = children(div1);\n\t\t\tdiv0 = claim_element(div1_nodes, \"DIV\", { class: true });\n\t\t\tvar div0_nodes = children(div0);\n\t\t\th1 = claim_element(div0_nodes, \"H1\", { class: true });\n\t\t\tvar h1_nodes = children(h1);\n\t\t\tt1 = claim_text(h1_nodes, \"Your Settings\");\n\t\t\th1_nodes.forEach(detach);\n\t\t\tt2 = claim_space(div0_nodes);\n\t\t\tclaim_component(listerrors.$$.fragment, div0_nodes);\n\t\t\tt3 = claim_space(div0_nodes);\n\t\t\tclaim_component(settingsform.$$.fragment, div0_nodes);\n\t\t\tt4 = claim_space(div0_nodes);\n\t\t\thr = claim_element(div0_nodes, \"HR\", {});\n\t\t\tt5 = claim_space(div0_nodes);\n\t\t\tbutton = claim_element(div0_nodes, \"BUTTON\", { class: true });\n\t\t\tvar button_nodes = children(button);\n\t\t\tt6 = claim_text(button_nodes, \"Or click here to logout.\");\n\t\t\tbutton_nodes.forEach(detach);\n\t\t\tdiv0_nodes.forEach(detach);\n\t\t\tdiv1_nodes.forEach(detach);\n\t\t\tdiv2_nodes.forEach(detach);\n\t\t\tdiv3_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tdocument.title = \"Settings • Conduit\";\n\t\t\tattr(h1, \"class\", \"text-xs-center\");\n\t\t\tattr(button, \"class\", \"btn btn-outline-danger\");\n\t\t\tattr(div0, \"class\", \"col-md-6 offset-md-3 col-xs-12\");\n\t\t\tattr(div1, \"class\", \"row\");\n\t\t\tattr(div2, \"class\", \"container page\");\n\t\t\tattr(div3, \"class\", \"settings-page\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, t0, anchor);\n\t\t\tinsert(target, div3, anchor);\n\t\t\tappend(div3, div2);\n\t\t\tappend(div2, div1);\n\t\t\tappend(div1, div0);\n\t\t\tappend(div0, h1);\n\t\t\tappend(h1, t1);\n\t\t\tappend(div0, t2);\n\t\t\tmount_component(listerrors, div0, null);\n\t\t\tappend(div0, t3);\n\t\t\tmount_component(settingsform, div0, null);\n\t\t\tappend(div0, t4);\n\t\t\tappend(div0, hr);\n\t\t\tappend(div0, t5);\n\t\t\tappend(div0, button);\n\t\t\tappend(button, t6);\n\t\t\tcurrent = true;\n\n\t\t\tif (!mounted) {\n\t\t\t\tdispose = listen(button, \"click\", /*logout*/ ctx[4]);\n\t\t\t\tmounted = true;\n\t\t\t}\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tconst listerrors_changes = {};\n\t\t\tif (dirty & /*errors*/ 2) listerrors_changes.errors = /*errors*/ ctx[1];\n\t\t\tlisterrors.$set(listerrors_changes);\n\n\t\t\tconst settingsform_changes = (dirty & /*$session, inProgress*/ 5)\n\t\t\t? get_spread_update(settingsform_spread_levels, [\n\t\t\t\t\tdirty & /*$session*/ 4 && get_spread_object(/*$session*/ ctx[2].user),\n\t\t\t\t\tdirty & /*inProgress*/ 1 && { inProgress: /*inProgress*/ ctx[0] }\n\t\t\t\t])\n\t\t\t: {};\n\n\t\t\tsettingsform.$set(settingsform_changes);\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(listerrors.$$.fragment, local);\n\t\t\ttransition_in(settingsform.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(listerrors.$$.fragment, local);\n\t\t\ttransition_out(settingsform.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(t0);\n\t\t\tif (detaching) detach(div3);\n\t\t\tdestroy_component(listerrors);\n\t\t\tdestroy_component(settingsform);\n\t\t\tmounted = false;\n\t\t\tdispose();\n\t\t}\n\t};\n}\n\nfunction instance$1($$self, $$props, $$invalidate) {\n\tlet $session;\n\tlet inProgress;\n\tlet errors;\n\tconst { session } = stores$1();\n\tcomponent_subscribe($$self, session, value => $$invalidate(2, $session = value));\n\n\tasync function logout() {\n\t\tawait post(`auth/logout`);\n\t\tset_store_value(session, $session.user = null, $session);\n\t\tgoto(\"/\");\n\t}\n\n\tasync function save(event) {\n\t\t$$invalidate(0, inProgress = true);\n\t\tconst response = await post(`auth/save`, event.detail);\n\t\t$$invalidate(1, errors = response.errors);\n\t\tif (response.user) set_store_value(session, $session.user = response.user, $session);\n\t\t$$invalidate(0, inProgress = false);\n\t}\n\n\treturn [inProgress, errors, $session, session, logout, save];\n}\n\nclass Settings extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance$1, create_fragment$1, safe_not_equal, {});\n\t}\n}\n\nexport default Settings;\n",
      "dynamicImports":[

      ],
      "exports":[
         "default"
      ],
      "facadeModuleId":"/home/bmccann/src/svelte-realworld/src/routes/settings/index.svelte",
      "fileName":"index.235c372d.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[
         "client.9f4f62db.js",
         "ListErrors.ab5b20bd.js",
         "utils.d5c0e45a.js"
      ],
      "isDynamicEntry":true,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/src/routes/settings/_SettingsForm.svelte":{
            "originalLength":1237,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":7940
         },
         "/home/bmccann/src/svelte-realworld/src/routes/settings/index.svelte":{
            "originalLength":1079,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":5355
         }
      },
      "name":"index",
      "type":"chunk"
   },
   {
      "code":"import { S as SvelteComponent, i as init, s as safe_not_equal, e as element, g as text, f as space, h as claim_element, j as children, k as detach, o as claim_text, l as claim_space, p as attr, q as insert, r as append, u as listen, v as set_data, n as noop, O as goto, K as set_input_value, L as prevent_default, M as run_all, z as createEventDispatcher, y as empty, c as create_component, a as claim_component, m as mount_component, t as transition_in, b as transition_out, d as destroy_component, G as group_outros, H as check_outros, I as update_keyed_each, J as outro_and_destroy_block, D as query_selector_all, A as destroy_each, w as stores$1, x as component_subscribe, F as onMount } from './client.9f4f62db.js';\nimport { d as del, p as post, g as get } from './api.5c9dd840.js';\nimport { L as ListErrors } from './ListErrors.ab5b20bd.js';\n\nfunction createCommonjsModule(fn, basedir, module) {\n\treturn module = {\n\t  path: basedir,\n\t  exports: {},\n\t  require: function (path, base) {\n      return commonjsRequire(path, (base === undefined || base === null) ? module.path : base);\n    }\n\t}, fn(module, module.exports), module.exports;\n}\n\nfunction commonjsRequire () {\n\tthrow new Error('Dynamic requires are not currently supported by @rollup/plugin-commonjs');\n}\n\nvar marked = createCommonjsModule(function (module, exports) {\n(function(root) {\n\n/**\n * Block-Level Grammar\n */\n\nvar block = {\n  newline: /^\\n+/,\n  code: /^( {4}[^\\n]+\\n*)+/,\n  fences: noop,\n  hr: /^ {0,3}((?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$)/,\n  heading: /^ *(#{1,6}) *([^\\n]+?) *(?:#+ *)?(?:\\n+|$)/,\n  nptable: noop,\n  blockquote: /^( {0,3}> ?(paragraph|[^\\n]*)(?:\\n|$))+/,\n  list: /^( {0,3})(bull) [\\s\\S]+?(?:hr|def|\\n{2,}(?! )(?!\\1bull )\\n*|\\s*$)/,\n  html: '^ {0,3}(?:' // optional indentation\n    + '<(script|pre|style)[\\\\s>][\\\\s\\\\S]*?(?:</\\\\1>[^\\\\n]*\\\\n+|$)' // (1)\n    + '|comment[^\\\\n]*(\\\\n+|$)' // (2)\n    + '|<\\\\?[\\\\s\\\\S]*?\\\\?>\\\\n*' // (3)\n    + '|<![A-Z][\\\\s\\\\S]*?>\\\\n*' // (4)\n    + '|<!\\\\[CDATA\\\\[[\\\\s\\\\S]*?\\\\]\\\\]>\\\\n*' // (5)\n    + '|</?(tag)(?: +|\\\\n|/?>)[\\\\s\\\\S]*?(?:\\\\n{2,}|$)' // (6)\n    + '|<(?!script|pre|style)([a-z][\\\\w-]*)(?:attribute)*? */?>(?=[ \\\\t]*(?:\\\\n|$))[\\\\s\\\\S]*?(?:\\\\n{2,}|$)' // (7) open tag\n    + '|</(?!script|pre|style)[a-z][\\\\w-]*\\\\s*>(?=[ \\\\t]*(?:\\\\n|$))[\\\\s\\\\S]*?(?:\\\\n{2,}|$)' // (7) closing tag\n    + ')',\n  def: /^ {0,3}\\[(label)\\]: *\\n? *<?([^\\s>]+)>?(?:(?: +\\n? *| *\\n *)(title))? *(?:\\n+|$)/,\n  table: noop,\n  lheading: /^([^\\n]+)\\n {0,3}(=|-){2,} *(?:\\n+|$)/,\n  paragraph: /^([^\\n]+(?:\\n(?!hr|heading|lheading| {0,3}>|<\\/?(?:tag)(?: +|\\n|\\/?>)|<(?:script|pre|style|!--))[^\\n]+)*)/,\n  text: /^[^\\n]+/\n};\n\nblock._label = /(?!\\s*\\])(?:\\\\[\\[\\]]|[^\\[\\]])+/;\nblock._title = /(?:\"(?:\\\\\"?|[^\"\\\\])*\"|'[^'\\n]*(?:\\n[^'\\n]+)*\\n?'|\\([^()]*\\))/;\nblock.def = edit(block.def)\n  .replace('label', block._label)\n  .replace('title', block._title)\n  .getRegex();\n\nblock.bullet = /(?:[*+-]|\\d{1,9}\\.)/;\nblock.item = /^( *)(bull) ?[^\\n]*(?:\\n(?!\\1bull ?)[^\\n]*)*/;\nblock.item = edit(block.item, 'gm')\n  .replace(/bull/g, block.bullet)\n  .getRegex();\n\nblock.list = edit(block.list)\n  .replace(/bull/g, block.bullet)\n  .replace('hr', '\\\\n+(?=\\\\1?(?:(?:- *){3,}|(?:_ *){3,}|(?:\\\\* *){3,})(?:\\\\n+|$))')\n  .replace('def', '\\\\n+(?=' + block.def.source + ')')\n  .getRegex();\n\nblock._tag = 'address|article|aside|base|basefont|blockquote|body|caption'\n  + '|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption'\n  + '|figure|footer|form|frame|frameset|h[1-6]|head|header|hr|html|iframe'\n  + '|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option'\n  + '|p|param|section|source|summary|table|tbody|td|tfoot|th|thead|title|tr'\n  + '|track|ul';\nblock._comment = /<!--(?!-?>)[\\s\\S]*?-->/;\nblock.html = edit(block.html, 'i')\n  .replace('comment', block._comment)\n  .replace('tag', block._tag)\n  .replace('attribute', / +[a-zA-Z:_][\\w.:-]*(?: *= *\"[^\"\\n]*\"| *= *'[^'\\n]*'| *= *[^\\s\"'=<>`]+)?/)\n  .getRegex();\n\nblock.paragraph = edit(block.paragraph)\n  .replace('hr', block.hr)\n  .replace('heading', block.heading)\n  .replace('lheading', block.lheading)\n  .replace('tag', block._tag) // pars can be interrupted by type (6) html blocks\n  .getRegex();\n\nblock.blockquote = edit(block.blockquote)\n  .replace('paragraph', block.paragraph)\n  .getRegex();\n\n/**\n * Normal Block Grammar\n */\n\nblock.normal = merge({}, block);\n\n/**\n * GFM Block Grammar\n */\n\nblock.gfm = merge({}, block.normal, {\n  fences: /^ {0,3}(`{3,}|~{3,})([^`\\n]*)\\n(?:|([\\s\\S]*?)\\n)(?: {0,3}\\1[~`]* *(?:\\n+|$)|$)/,\n  paragraph: /^/,\n  heading: /^ *(#{1,6}) +([^\\n]+?) *#* *(?:\\n+|$)/\n});\n\nblock.gfm.paragraph = edit(block.paragraph)\n  .replace('(?!', '(?!'\n    + block.gfm.fences.source.replace('\\\\1', '\\\\2') + '|'\n    + block.list.source.replace('\\\\1', '\\\\3') + '|')\n  .getRegex();\n\n/**\n * GFM + Tables Block Grammar\n */\n\nblock.tables = merge({}, block.gfm, {\n  nptable: /^ *([^|\\n ].*\\|.*)\\n *([-:]+ *\\|[-| :]*)(?:\\n((?:.*[^>\\n ].*(?:\\n|$))*)\\n*|$)/,\n  table: /^ *\\|(.+)\\n *\\|?( *[-:]+[-| :]*)(?:\\n((?: *[^>\\n ].*(?:\\n|$))*)\\n*|$)/\n});\n\n/**\n * Pedantic grammar\n */\n\nblock.pedantic = merge({}, block.normal, {\n  html: edit(\n    '^ *(?:comment *(?:\\\\n|\\\\s*$)'\n    + '|<(tag)[\\\\s\\\\S]+?</\\\\1> *(?:\\\\n{2,}|\\\\s*$)' // closed tag\n    + '|<tag(?:\"[^\"]*\"|\\'[^\\']*\\'|\\\\s[^\\'\"/>\\\\s]*)*?/?> *(?:\\\\n{2,}|\\\\s*$))')\n    .replace('comment', block._comment)\n    .replace(/tag/g, '(?!(?:'\n      + 'a|em|strong|small|s|cite|q|dfn|abbr|data|time|code|var|samp|kbd|sub'\n      + '|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo|span|br|wbr|ins|del|img)'\n      + '\\\\b)\\\\w+(?!:|[^\\\\w\\\\s@]*@)\\\\b')\n    .getRegex(),\n  def: /^ *\\[([^\\]]+)\\]: *<?([^\\s>]+)>?(?: +([\"(][^\\n]+[\")]))? *(?:\\n+|$)/\n});\n\n/**\n * Block Lexer\n */\n\nfunction Lexer(options) {\n  this.tokens = [];\n  this.tokens.links = Object.create(null);\n  this.options = options || marked.defaults;\n  this.rules = block.normal;\n\n  if (this.options.pedantic) {\n    this.rules = block.pedantic;\n  } else if (this.options.gfm) {\n    if (this.options.tables) {\n      this.rules = block.tables;\n    } else {\n      this.rules = block.gfm;\n    }\n  }\n}\n\n/**\n * Expose Block Rules\n */\n\nLexer.rules = block;\n\n/**\n * Static Lex Method\n */\n\nLexer.lex = function(src, options) {\n  var lexer = new Lexer(options);\n  return lexer.lex(src);\n};\n\n/**\n * Preprocessing\n */\n\nLexer.prototype.lex = function(src) {\n  src = src\n    .replace(/\\r\\n|\\r/g, '\\n')\n    .replace(/\\t/g, '    ')\n    .replace(/\\u00a0/g, ' ')\n    .replace(/\\u2424/g, '\\n');\n\n  return this.token(src, true);\n};\n\n/**\n * Lexing\n */\n\nLexer.prototype.token = function(src, top) {\n  src = src.replace(/^ +$/gm, '');\n  var next,\n      loose,\n      cap,\n      bull,\n      b,\n      item,\n      listStart,\n      listItems,\n      t,\n      space,\n      i,\n      tag,\n      l,\n      isordered,\n      istask,\n      ischecked;\n\n  while (src) {\n    // newline\n    if (cap = this.rules.newline.exec(src)) {\n      src = src.substring(cap[0].length);\n      if (cap[0].length > 1) {\n        this.tokens.push({\n          type: 'space'\n        });\n      }\n    }\n\n    // code\n    if (cap = this.rules.code.exec(src)) {\n      var lastToken = this.tokens[this.tokens.length - 1];\n      src = src.substring(cap[0].length);\n      // An indented code block cannot interrupt a paragraph.\n      if (lastToken && lastToken.type === 'paragraph') {\n        lastToken.text += '\\n' + cap[0].trimRight();\n      } else {\n        cap = cap[0].replace(/^ {4}/gm, '');\n        this.tokens.push({\n          type: 'code',\n          codeBlockStyle: 'indented',\n          text: !this.options.pedantic\n            ? rtrim(cap, '\\n')\n            : cap\n        });\n      }\n      continue;\n    }\n\n    // fences (gfm)\n    if (cap = this.rules.fences.exec(src)) {\n      src = src.substring(cap[0].length);\n      this.tokens.push({\n        type: 'code',\n        lang: cap[2] ? cap[2].trim() : cap[2],\n        text: cap[3] || ''\n      });\n      continue;\n    }\n\n    // heading\n    if (cap = this.rules.heading.exec(src)) {\n      src = src.substring(cap[0].length);\n      this.tokens.push({\n        type: 'heading',\n        depth: cap[1].length,\n        text: cap[2]\n      });\n      continue;\n    }\n\n    // table no leading pipe (gfm)\n    if (cap = this.rules.nptable.exec(src)) {\n      item = {\n        type: 'table',\n        header: splitCells(cap[1].replace(/^ *| *\\| *$/g, '')),\n        align: cap[2].replace(/^ *|\\| *$/g, '').split(/ *\\| */),\n        cells: cap[3] ? cap[3].replace(/\\n$/, '').split('\\n') : []\n      };\n\n      if (item.header.length === item.align.length) {\n        src = src.substring(cap[0].length);\n\n        for (i = 0; i < item.align.length; i++) {\n          if (/^ *-+: *$/.test(item.align[i])) {\n            item.align[i] = 'right';\n          } else if (/^ *:-+: *$/.test(item.align[i])) {\n            item.align[i] = 'center';\n          } else if (/^ *:-+ *$/.test(item.align[i])) {\n            item.align[i] = 'left';\n          } else {\n            item.align[i] = null;\n          }\n        }\n\n        for (i = 0; i < item.cells.length; i++) {\n          item.cells[i] = splitCells(item.cells[i], item.header.length);\n        }\n\n        this.tokens.push(item);\n\n        continue;\n      }\n    }\n\n    // hr\n    if (cap = this.rules.hr.exec(src)) {\n      src = src.substring(cap[0].length);\n      this.tokens.push({\n        type: 'hr'\n      });\n      continue;\n    }\n\n    // blockquote\n    if (cap = this.rules.blockquote.exec(src)) {\n      src = src.substring(cap[0].length);\n\n      this.tokens.push({\n        type: 'blockquote_start'\n      });\n\n      cap = cap[0].replace(/^ *> ?/gm, '');\n\n      // Pass `top` to keep the current\n      // \"toplevel\" state. This is exactly\n      // how markdown.pl works.\n      this.token(cap, top);\n\n      this.tokens.push({\n        type: 'blockquote_end'\n      });\n\n      continue;\n    }\n\n    // list\n    if (cap = this.rules.list.exec(src)) {\n      src = src.substring(cap[0].length);\n      bull = cap[2];\n      isordered = bull.length > 1;\n\n      listStart = {\n        type: 'list_start',\n        ordered: isordered,\n        start: isordered ? +bull : '',\n        loose: false\n      };\n\n      this.tokens.push(listStart);\n\n      // Get each top-level item.\n      cap = cap[0].match(this.rules.item);\n\n      listItems = [];\n      next = false;\n      l = cap.length;\n      i = 0;\n\n      for (; i < l; i++) {\n        item = cap[i];\n\n        // Remove the list item's bullet\n        // so it is seen as the next token.\n        space = item.length;\n        item = item.replace(/^ *([*+-]|\\d+\\.) */, '');\n\n        // Outdent whatever the\n        // list item contains. Hacky.\n        if (~item.indexOf('\\n ')) {\n          space -= item.length;\n          item = !this.options.pedantic\n            ? item.replace(new RegExp('^ {1,' + space + '}', 'gm'), '')\n            : item.replace(/^ {1,4}/gm, '');\n        }\n\n        // Determine whether the next list item belongs here.\n        // Backpedal if it does not belong in this list.\n        if (i !== l - 1) {\n          b = block.bullet.exec(cap[i + 1])[0];\n          if (bull.length > 1 ? b.length === 1\n            : (b.length > 1 || (this.options.smartLists && b !== bull))) {\n            src = cap.slice(i + 1).join('\\n') + src;\n            i = l - 1;\n          }\n        }\n\n        // Determine whether item is loose or not.\n        // Use: /(^|\\n)(?! )[^\\n]+\\n\\n(?!\\s*$)/\n        // for discount behavior.\n        loose = next || /\\n\\n(?!\\s*$)/.test(item);\n        if (i !== l - 1) {\n          next = item.charAt(item.length - 1) === '\\n';\n          if (!loose) loose = next;\n        }\n\n        if (loose) {\n          listStart.loose = true;\n        }\n\n        // Check for task list items\n        istask = /^\\[[ xX]\\] /.test(item);\n        ischecked = undefined;\n        if (istask) {\n          ischecked = item[1] !== ' ';\n          item = item.replace(/^\\[[ xX]\\] +/, '');\n        }\n\n        t = {\n          type: 'list_item_start',\n          task: istask,\n          checked: ischecked,\n          loose: loose\n        };\n\n        listItems.push(t);\n        this.tokens.push(t);\n\n        // Recurse.\n        this.token(item, false);\n\n        this.tokens.push({\n          type: 'list_item_end'\n        });\n      }\n\n      if (listStart.loose) {\n        l = listItems.length;\n        i = 0;\n        for (; i < l; i++) {\n          listItems[i].loose = true;\n        }\n      }\n\n      this.tokens.push({\n        type: 'list_end'\n      });\n\n      continue;\n    }\n\n    // html\n    if (cap = this.rules.html.exec(src)) {\n      src = src.substring(cap[0].length);\n      this.tokens.push({\n        type: this.options.sanitize\n          ? 'paragraph'\n          : 'html',\n        pre: !this.options.sanitizer\n          && (cap[1] === 'pre' || cap[1] === 'script' || cap[1] === 'style'),\n        text: cap[0]\n      });\n      continue;\n    }\n\n    // def\n    if (top && (cap = this.rules.def.exec(src))) {\n      src = src.substring(cap[0].length);\n      if (cap[3]) cap[3] = cap[3].substring(1, cap[3].length - 1);\n      tag = cap[1].toLowerCase().replace(/\\s+/g, ' ');\n      if (!this.tokens.links[tag]) {\n        this.tokens.links[tag] = {\n          href: cap[2],\n          title: cap[3]\n        };\n      }\n      continue;\n    }\n\n    // table (gfm)\n    if (cap = this.rules.table.exec(src)) {\n      item = {\n        type: 'table',\n        header: splitCells(cap[1].replace(/^ *| *\\| *$/g, '')),\n        align: cap[2].replace(/^ *|\\| *$/g, '').split(/ *\\| */),\n        cells: cap[3] ? cap[3].replace(/\\n$/, '').split('\\n') : []\n      };\n\n      if (item.header.length === item.align.length) {\n        src = src.substring(cap[0].length);\n\n        for (i = 0; i < item.align.length; i++) {\n          if (/^ *-+: *$/.test(item.align[i])) {\n            item.align[i] = 'right';\n          } else if (/^ *:-+: *$/.test(item.align[i])) {\n            item.align[i] = 'center';\n          } else if (/^ *:-+ *$/.test(item.align[i])) {\n            item.align[i] = 'left';\n          } else {\n            item.align[i] = null;\n          }\n        }\n\n        for (i = 0; i < item.cells.length; i++) {\n          item.cells[i] = splitCells(\n            item.cells[i].replace(/^ *\\| *| *\\| *$/g, ''),\n            item.header.length);\n        }\n\n        this.tokens.push(item);\n\n        continue;\n      }\n    }\n\n    // lheading\n    if (cap = this.rules.lheading.exec(src)) {\n      src = src.substring(cap[0].length);\n      this.tokens.push({\n        type: 'heading',\n        depth: cap[2] === '=' ? 1 : 2,\n        text: cap[1]\n      });\n      continue;\n    }\n\n    // top-level paragraph\n    if (top && (cap = this.rules.paragraph.exec(src))) {\n      src = src.substring(cap[0].length);\n      this.tokens.push({\n        type: 'paragraph',\n        text: cap[1].charAt(cap[1].length - 1) === '\\n'\n          ? cap[1].slice(0, -1)\n          : cap[1]\n      });\n      continue;\n    }\n\n    // text\n    if (cap = this.rules.text.exec(src)) {\n      // Top-level should never reach here.\n      src = src.substring(cap[0].length);\n      this.tokens.push({\n        type: 'text',\n        text: cap[0]\n      });\n      continue;\n    }\n\n    if (src) {\n      throw new Error('Infinite loop on byte: ' + src.charCodeAt(0));\n    }\n  }\n\n  return this.tokens;\n};\n\n/**\n * Inline-Level Grammar\n */\n\nvar inline = {\n  escape: /^\\\\([!\"#$%&'()*+,\\-./:;<=>?@\\[\\]\\\\^_`{|}~])/,\n  autolink: /^<(scheme:[^\\s\\x00-\\x1f<>]*|email)>/,\n  url: noop,\n  tag: '^comment'\n    + '|^</[a-zA-Z][\\\\w:-]*\\\\s*>' // self-closing tag\n    + '|^<[a-zA-Z][\\\\w-]*(?:attribute)*?\\\\s*/?>' // open tag\n    + '|^<\\\\?[\\\\s\\\\S]*?\\\\?>' // processing instruction, e.g. <?php ?>\n    + '|^<![a-zA-Z]+\\\\s[\\\\s\\\\S]*?>' // declaration, e.g. <!DOCTYPE html>\n    + '|^<!\\\\[CDATA\\\\[[\\\\s\\\\S]*?\\\\]\\\\]>', // CDATA section\n  link: /^!?\\[(label)\\]\\(href(?:\\s+(title))?\\s*\\)/,\n  reflink: /^!?\\[(label)\\]\\[(?!\\s*\\])((?:\\\\[\\[\\]]?|[^\\[\\]\\\\])+)\\]/,\n  nolink: /^!?\\[(?!\\s*\\])((?:\\[[^\\[\\]]*\\]|\\\\[\\[\\]]|[^\\[\\]])*)\\](?:\\[\\])?/,\n  strong: /^__([^\\s_])__(?!_)|^\\*\\*([^\\s*])\\*\\*(?!\\*)|^__([^\\s][\\s\\S]*?[^\\s])__(?!_)|^\\*\\*([^\\s][\\s\\S]*?[^\\s])\\*\\*(?!\\*)/,\n  em: /^_([^\\s_])_(?!_)|^\\*([^\\s*<\\[])\\*(?!\\*)|^_([^\\s<][\\s\\S]*?[^\\s_])_(?!_|[^\\spunctuation])|^_([^\\s_<][\\s\\S]*?[^\\s])_(?!_|[^\\spunctuation])|^\\*([^\\s<\"][\\s\\S]*?[^\\s\\*])\\*(?!\\*|[^\\spunctuation])|^\\*([^\\s*\"<\\[][\\s\\S]*?[^\\s])\\*(?!\\*)/,\n  code: /^(`+)([^`]|[^`][\\s\\S]*?[^`])\\1(?!`)/,\n  br: /^( {2,}|\\\\)\\n(?!\\s*$)/,\n  del: noop,\n  text: /^(`+|[^`])(?:[\\s\\S]*?(?:(?=[\\\\<!\\[`*]|\\b_|$)|[^ ](?= {2,}\\n))|(?= {2,}\\n))/\n};\n\n// list of punctuation marks from common mark spec\n// without ` and ] to workaround Rule 17 (inline code blocks/links)\ninline._punctuation = '!\"#$%&\\'()*+,\\\\-./:;<=>?@\\\\[^_{|}~';\ninline.em = edit(inline.em).replace(/punctuation/g, inline._punctuation).getRegex();\n\ninline._escapes = /\\\\([!\"#$%&'()*+,\\-./:;<=>?@\\[\\]\\\\^_`{|}~])/g;\n\ninline._scheme = /[a-zA-Z][a-zA-Z0-9+.-]{1,31}/;\ninline._email = /[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+(@)[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+(?![-_])/;\ninline.autolink = edit(inline.autolink)\n  .replace('scheme', inline._scheme)\n  .replace('email', inline._email)\n  .getRegex();\n\ninline._attribute = /\\s+[a-zA-Z:_][\\w.:-]*(?:\\s*=\\s*\"[^\"]*\"|\\s*=\\s*'[^']*'|\\s*=\\s*[^\\s\"'=<>`]+)?/;\n\ninline.tag = edit(inline.tag)\n  .replace('comment', block._comment)\n  .replace('attribute', inline._attribute)\n  .getRegex();\n\ninline._label = /(?:\\[[^\\[\\]]*\\]|\\\\[\\[\\]]?|`[^`]*`|`(?!`)|[^\\[\\]\\\\`])*?/;\ninline._href = /\\s*(<(?:\\\\[<>]?|[^\\s<>\\\\])*>|[^\\s\\x00-\\x1f]*)/;\ninline._title = /\"(?:\\\\\"?|[^\"\\\\])*\"|'(?:\\\\'?|[^'\\\\])*'|\\((?:\\\\\\)?|[^)\\\\])*\\)/;\n\ninline.link = edit(inline.link)\n  .replace('label', inline._label)\n  .replace('href', inline._href)\n  .replace('title', inline._title)\n  .getRegex();\n\ninline.reflink = edit(inline.reflink)\n  .replace('label', inline._label)\n  .getRegex();\n\n/**\n * Normal Inline Grammar\n */\n\ninline.normal = merge({}, inline);\n\n/**\n * Pedantic Inline Grammar\n */\n\ninline.pedantic = merge({}, inline.normal, {\n  strong: /^__(?=\\S)([\\s\\S]*?\\S)__(?!_)|^\\*\\*(?=\\S)([\\s\\S]*?\\S)\\*\\*(?!\\*)/,\n  em: /^_(?=\\S)([\\s\\S]*?\\S)_(?!_)|^\\*(?=\\S)([\\s\\S]*?\\S)\\*(?!\\*)/,\n  link: edit(/^!?\\[(label)\\]\\((.*?)\\)/)\n    .replace('label', inline._label)\n    .getRegex(),\n  reflink: edit(/^!?\\[(label)\\]\\s*\\[([^\\]]*)\\]/)\n    .replace('label', inline._label)\n    .getRegex()\n});\n\n/**\n * GFM Inline Grammar\n */\n\ninline.gfm = merge({}, inline.normal, {\n  escape: edit(inline.escape).replace('])', '~|])').getRegex(),\n  _extended_email: /[A-Za-z0-9._+-]+(@)[a-zA-Z0-9-_]+(?:\\.[a-zA-Z0-9-_]*[a-zA-Z0-9])+(?![-_])/,\n  url: /^((?:ftp|https?):\\/\\/|www\\.)(?:[a-zA-Z0-9\\-]+\\.?)+[^\\s<]*|^email/,\n  _backpedal: /(?:[^?!.,:;*_~()&]+|\\([^)]*\\)|&(?![a-zA-Z0-9]+;$)|[?!.,:;*_~)]+(?!$))+/,\n  del: /^~+(?=\\S)([\\s\\S]*?\\S)~+/,\n  text: /^(`+|[^`])(?:[\\s\\S]*?(?:(?=[\\\\<!\\[`*~]|\\b_|https?:\\/\\/|ftp:\\/\\/|www\\.|$)|[^ ](?= {2,}\\n)|[^a-zA-Z0-9.!#$%&'*+\\/=?_`{\\|}~-](?=[a-zA-Z0-9.!#$%&'*+\\/=?_`{\\|}~-]+@))|(?= {2,}\\n|[a-zA-Z0-9.!#$%&'*+\\/=?_`{\\|}~-]+@))/\n});\n\ninline.gfm.url = edit(inline.gfm.url, 'i')\n  .replace('email', inline.gfm._extended_email)\n  .getRegex();\n/**\n * GFM + Line Breaks Inline Grammar\n */\n\ninline.breaks = merge({}, inline.gfm, {\n  br: edit(inline.br).replace('{2,}', '*').getRegex(),\n  text: edit(inline.gfm.text)\n    .replace('\\\\b_', '\\\\b_| {2,}\\\\n')\n    .replace(/\\{2,\\}/g, '*')\n    .getRegex()\n});\n\n/**\n * Inline Lexer & Compiler\n */\n\nfunction InlineLexer(links, options) {\n  this.options = options || marked.defaults;\n  this.links = links;\n  this.rules = inline.normal;\n  this.renderer = this.options.renderer || new Renderer();\n  this.renderer.options = this.options;\n\n  if (!this.links) {\n    throw new Error('Tokens array requires a `links` property.');\n  }\n\n  if (this.options.pedantic) {\n    this.rules = inline.pedantic;\n  } else if (this.options.gfm) {\n    if (this.options.breaks) {\n      this.rules = inline.breaks;\n    } else {\n      this.rules = inline.gfm;\n    }\n  }\n}\n\n/**\n * Expose Inline Rules\n */\n\nInlineLexer.rules = inline;\n\n/**\n * Static Lexing/Compiling Method\n */\n\nInlineLexer.output = function(src, links, options) {\n  var inline = new InlineLexer(links, options);\n  return inline.output(src);\n};\n\n/**\n * Lexing/Compiling\n */\n\nInlineLexer.prototype.output = function(src) {\n  var out = '',\n      link,\n      text,\n      href,\n      title,\n      cap,\n      prevCapZero;\n\n  while (src) {\n    // escape\n    if (cap = this.rules.escape.exec(src)) {\n      src = src.substring(cap[0].length);\n      out += escape(cap[1]);\n      continue;\n    }\n\n    // tag\n    if (cap = this.rules.tag.exec(src)) {\n      if (!this.inLink && /^<a /i.test(cap[0])) {\n        this.inLink = true;\n      } else if (this.inLink && /^<\\/a>/i.test(cap[0])) {\n        this.inLink = false;\n      }\n      if (!this.inRawBlock && /^<(pre|code|kbd|script)(\\s|>)/i.test(cap[0])) {\n        this.inRawBlock = true;\n      } else if (this.inRawBlock && /^<\\/(pre|code|kbd|script)(\\s|>)/i.test(cap[0])) {\n        this.inRawBlock = false;\n      }\n\n      src = src.substring(cap[0].length);\n      out += this.options.sanitize\n        ? this.options.sanitizer\n          ? this.options.sanitizer(cap[0])\n          : escape(cap[0])\n        : cap[0];\n      continue;\n    }\n\n    // link\n    if (cap = this.rules.link.exec(src)) {\n      var lastParenIndex = findClosingBracket(cap[2], '()');\n      if (lastParenIndex > -1) {\n        var linkLen = cap[0].length - (cap[2].length - lastParenIndex) - (cap[3] || '').length;\n        cap[2] = cap[2].substring(0, lastParenIndex);\n        cap[0] = cap[0].substring(0, linkLen).trim();\n        cap[3] = '';\n      }\n      src = src.substring(cap[0].length);\n      this.inLink = true;\n      href = cap[2];\n      if (this.options.pedantic) {\n        link = /^([^'\"]*[^\\s])\\s+(['\"])(.*)\\2/.exec(href);\n\n        if (link) {\n          href = link[1];\n          title = link[3];\n        } else {\n          title = '';\n        }\n      } else {\n        title = cap[3] ? cap[3].slice(1, -1) : '';\n      }\n      href = href.trim().replace(/^<([\\s\\S]*)>$/, '$1');\n      out += this.outputLink(cap, {\n        href: InlineLexer.escapes(href),\n        title: InlineLexer.escapes(title)\n      });\n      this.inLink = false;\n      continue;\n    }\n\n    // reflink, nolink\n    if ((cap = this.rules.reflink.exec(src))\n        || (cap = this.rules.nolink.exec(src))) {\n      src = src.substring(cap[0].length);\n      link = (cap[2] || cap[1]).replace(/\\s+/g, ' ');\n      link = this.links[link.toLowerCase()];\n      if (!link || !link.href) {\n        out += cap[0].charAt(0);\n        src = cap[0].substring(1) + src;\n        continue;\n      }\n      this.inLink = true;\n      out += this.outputLink(cap, link);\n      this.inLink = false;\n      continue;\n    }\n\n    // strong\n    if (cap = this.rules.strong.exec(src)) {\n      src = src.substring(cap[0].length);\n      out += this.renderer.strong(this.output(cap[4] || cap[3] || cap[2] || cap[1]));\n      continue;\n    }\n\n    // em\n    if (cap = this.rules.em.exec(src)) {\n      src = src.substring(cap[0].length);\n      out += this.renderer.em(this.output(cap[6] || cap[5] || cap[4] || cap[3] || cap[2] || cap[1]));\n      continue;\n    }\n\n    // code\n    if (cap = this.rules.code.exec(src)) {\n      src = src.substring(cap[0].length);\n      out += this.renderer.codespan(escape(cap[2].trim(), true));\n      continue;\n    }\n\n    // br\n    if (cap = this.rules.br.exec(src)) {\n      src = src.substring(cap[0].length);\n      out += this.renderer.br();\n      continue;\n    }\n\n    // del (gfm)\n    if (cap = this.rules.del.exec(src)) {\n      src = src.substring(cap[0].length);\n      out += this.renderer.del(this.output(cap[1]));\n      continue;\n    }\n\n    // autolink\n    if (cap = this.rules.autolink.exec(src)) {\n      src = src.substring(cap[0].length);\n      if (cap[2] === '@') {\n        text = escape(this.mangle(cap[1]));\n        href = 'mailto:' + text;\n      } else {\n        text = escape(cap[1]);\n        href = text;\n      }\n      out += this.renderer.link(href, null, text);\n      continue;\n    }\n\n    // url (gfm)\n    if (!this.inLink && (cap = this.rules.url.exec(src))) {\n      if (cap[2] === '@') {\n        text = escape(cap[0]);\n        href = 'mailto:' + text;\n      } else {\n        // do extended autolink path validation\n        do {\n          prevCapZero = cap[0];\n          cap[0] = this.rules._backpedal.exec(cap[0])[0];\n        } while (prevCapZero !== cap[0]);\n        text = escape(cap[0]);\n        if (cap[1] === 'www.') {\n          href = 'http://' + text;\n        } else {\n          href = text;\n        }\n      }\n      src = src.substring(cap[0].length);\n      out += this.renderer.link(href, null, text);\n      continue;\n    }\n\n    // text\n    if (cap = this.rules.text.exec(src)) {\n      src = src.substring(cap[0].length);\n      if (this.inRawBlock) {\n        out += this.renderer.text(cap[0]);\n      } else {\n        out += this.renderer.text(escape(this.smartypants(cap[0])));\n      }\n      continue;\n    }\n\n    if (src) {\n      throw new Error('Infinite loop on byte: ' + src.charCodeAt(0));\n    }\n  }\n\n  return out;\n};\n\nInlineLexer.escapes = function(text) {\n  return text ? text.replace(InlineLexer.rules._escapes, '$1') : text;\n};\n\n/**\n * Compile Link\n */\n\nInlineLexer.prototype.outputLink = function(cap, link) {\n  var href = link.href,\n      title = link.title ? escape(link.title) : null;\n\n  return cap[0].charAt(0) !== '!'\n    ? this.renderer.link(href, title, this.output(cap[1]))\n    : this.renderer.image(href, title, escape(cap[1]));\n};\n\n/**\n * Smartypants Transformations\n */\n\nInlineLexer.prototype.smartypants = function(text) {\n  if (!this.options.smartypants) return text;\n  return text\n    // em-dashes\n    .replace(/---/g, '\\u2014')\n    // en-dashes\n    .replace(/--/g, '\\u2013')\n    // opening singles\n    .replace(/(^|[-\\u2014/(\\[{\"\\s])'/g, '$1\\u2018')\n    // closing singles & apostrophes\n    .replace(/'/g, '\\u2019')\n    // opening doubles\n    .replace(/(^|[-\\u2014/(\\[{\\u2018\\s])\"/g, '$1\\u201c')\n    // closing doubles\n    .replace(/\"/g, '\\u201d')\n    // ellipses\n    .replace(/\\.{3}/g, '\\u2026');\n};\n\n/**\n * Mangle Links\n */\n\nInlineLexer.prototype.mangle = function(text) {\n  if (!this.options.mangle) return text;\n  var out = '',\n      l = text.length,\n      i = 0,\n      ch;\n\n  for (; i < l; i++) {\n    ch = text.charCodeAt(i);\n    if (Math.random() > 0.5) {\n      ch = 'x' + ch.toString(16);\n    }\n    out += '&#' + ch + ';';\n  }\n\n  return out;\n};\n\n/**\n * Renderer\n */\n\nfunction Renderer(options) {\n  this.options = options || marked.defaults;\n}\n\nRenderer.prototype.code = function(code, infostring, escaped) {\n  var lang = (infostring || '').match(/\\S*/)[0];\n  if (this.options.highlight) {\n    var out = this.options.highlight(code, lang);\n    if (out != null && out !== code) {\n      escaped = true;\n      code = out;\n    }\n  }\n\n  if (!lang) {\n    return '<pre><code>'\n      + (escaped ? code : escape(code, true))\n      + '</code></pre>';\n  }\n\n  return '<pre><code class=\"'\n    + this.options.langPrefix\n    + escape(lang, true)\n    + '\">'\n    + (escaped ? code : escape(code, true))\n    + '</code></pre>\\n';\n};\n\nRenderer.prototype.blockquote = function(quote) {\n  return '<blockquote>\\n' + quote + '</blockquote>\\n';\n};\n\nRenderer.prototype.html = function(html) {\n  return html;\n};\n\nRenderer.prototype.heading = function(text, level, raw, slugger) {\n  if (this.options.headerIds) {\n    return '<h'\n      + level\n      + ' id=\"'\n      + this.options.headerPrefix\n      + slugger.slug(raw)\n      + '\">'\n      + text\n      + '</h'\n      + level\n      + '>\\n';\n  }\n  // ignore IDs\n  return '<h' + level + '>' + text + '</h' + level + '>\\n';\n};\n\nRenderer.prototype.hr = function() {\n  return this.options.xhtml ? '<hr/>\\n' : '<hr>\\n';\n};\n\nRenderer.prototype.list = function(body, ordered, start) {\n  var type = ordered ? 'ol' : 'ul',\n      startatt = (ordered && start !== 1) ? (' start=\"' + start + '\"') : '';\n  return '<' + type + startatt + '>\\n' + body + '</' + type + '>\\n';\n};\n\nRenderer.prototype.listitem = function(text) {\n  return '<li>' + text + '</li>\\n';\n};\n\nRenderer.prototype.checkbox = function(checked) {\n  return '<input '\n    + (checked ? 'checked=\"\" ' : '')\n    + 'disabled=\"\" type=\"checkbox\"'\n    + (this.options.xhtml ? ' /' : '')\n    + '> ';\n};\n\nRenderer.prototype.paragraph = function(text) {\n  return '<p>' + text + '</p>\\n';\n};\n\nRenderer.prototype.table = function(header, body) {\n  if (body) body = '<tbody>' + body + '</tbody>';\n\n  return '<table>\\n'\n    + '<thead>\\n'\n    + header\n    + '</thead>\\n'\n    + body\n    + '</table>\\n';\n};\n\nRenderer.prototype.tablerow = function(content) {\n  return '<tr>\\n' + content + '</tr>\\n';\n};\n\nRenderer.prototype.tablecell = function(content, flags) {\n  var type = flags.header ? 'th' : 'td';\n  var tag = flags.align\n    ? '<' + type + ' align=\"' + flags.align + '\">'\n    : '<' + type + '>';\n  return tag + content + '</' + type + '>\\n';\n};\n\n// span level renderer\nRenderer.prototype.strong = function(text) {\n  return '<strong>' + text + '</strong>';\n};\n\nRenderer.prototype.em = function(text) {\n  return '<em>' + text + '</em>';\n};\n\nRenderer.prototype.codespan = function(text) {\n  return '<code>' + text + '</code>';\n};\n\nRenderer.prototype.br = function() {\n  return this.options.xhtml ? '<br/>' : '<br>';\n};\n\nRenderer.prototype.del = function(text) {\n  return '<del>' + text + '</del>';\n};\n\nRenderer.prototype.link = function(href, title, text) {\n  href = cleanUrl(this.options.sanitize, this.options.baseUrl, href);\n  if (href === null) {\n    return text;\n  }\n  var out = '<a href=\"' + escape(href) + '\"';\n  if (title) {\n    out += ' title=\"' + title + '\"';\n  }\n  out += '>' + text + '</a>';\n  return out;\n};\n\nRenderer.prototype.image = function(href, title, text) {\n  href = cleanUrl(this.options.sanitize, this.options.baseUrl, href);\n  if (href === null) {\n    return text;\n  }\n\n  var out = '<img src=\"' + href + '\" alt=\"' + text + '\"';\n  if (title) {\n    out += ' title=\"' + title + '\"';\n  }\n  out += this.options.xhtml ? '/>' : '>';\n  return out;\n};\n\nRenderer.prototype.text = function(text) {\n  return text;\n};\n\n/**\n * TextRenderer\n * returns only the textual part of the token\n */\n\nfunction TextRenderer() {}\n\n// no need for block level renderers\n\nTextRenderer.prototype.strong =\nTextRenderer.prototype.em =\nTextRenderer.prototype.codespan =\nTextRenderer.prototype.del =\nTextRenderer.prototype.text = function(text) {\n  return text;\n};\n\nTextRenderer.prototype.link =\nTextRenderer.prototype.image = function(href, title, text) {\n  return '' + text;\n};\n\nTextRenderer.prototype.br = function() {\n  return '';\n};\n\n/**\n * Parsing & Compiling\n */\n\nfunction Parser(options) {\n  this.tokens = [];\n  this.token = null;\n  this.options = options || marked.defaults;\n  this.options.renderer = this.options.renderer || new Renderer();\n  this.renderer = this.options.renderer;\n  this.renderer.options = this.options;\n  this.slugger = new Slugger();\n}\n\n/**\n * Static Parse Method\n */\n\nParser.parse = function(src, options) {\n  var parser = new Parser(options);\n  return parser.parse(src);\n};\n\n/**\n * Parse Loop\n */\n\nParser.prototype.parse = function(src) {\n  this.inline = new InlineLexer(src.links, this.options);\n  // use an InlineLexer with a TextRenderer to extract pure text\n  this.inlineText = new InlineLexer(\n    src.links,\n    merge({}, this.options, { renderer: new TextRenderer() })\n  );\n  this.tokens = src.reverse();\n\n  var out = '';\n  while (this.next()) {\n    out += this.tok();\n  }\n\n  return out;\n};\n\n/**\n * Next Token\n */\n\nParser.prototype.next = function() {\n  this.token = this.tokens.pop();\n  return this.token;\n};\n\n/**\n * Preview Next Token\n */\n\nParser.prototype.peek = function() {\n  return this.tokens[this.tokens.length - 1] || 0;\n};\n\n/**\n * Parse Text Tokens\n */\n\nParser.prototype.parseText = function() {\n  var body = this.token.text;\n\n  while (this.peek().type === 'text') {\n    body += '\\n' + this.next().text;\n  }\n\n  return this.inline.output(body);\n};\n\n/**\n * Parse Current Token\n */\n\nParser.prototype.tok = function() {\n  switch (this.token.type) {\n    case 'space': {\n      return '';\n    }\n    case 'hr': {\n      return this.renderer.hr();\n    }\n    case 'heading': {\n      return this.renderer.heading(\n        this.inline.output(this.token.text),\n        this.token.depth,\n        unescape(this.inlineText.output(this.token.text)),\n        this.slugger);\n    }\n    case 'code': {\n      return this.renderer.code(this.token.text,\n        this.token.lang,\n        this.token.escaped);\n    }\n    case 'table': {\n      var header = '',\n          body = '',\n          i,\n          row,\n          cell,\n          j;\n\n      // header\n      cell = '';\n      for (i = 0; i < this.token.header.length; i++) {\n        cell += this.renderer.tablecell(\n          this.inline.output(this.token.header[i]),\n          { header: true, align: this.token.align[i] }\n        );\n      }\n      header += this.renderer.tablerow(cell);\n\n      for (i = 0; i < this.token.cells.length; i++) {\n        row = this.token.cells[i];\n\n        cell = '';\n        for (j = 0; j < row.length; j++) {\n          cell += this.renderer.tablecell(\n            this.inline.output(row[j]),\n            { header: false, align: this.token.align[j] }\n          );\n        }\n\n        body += this.renderer.tablerow(cell);\n      }\n      return this.renderer.table(header, body);\n    }\n    case 'blockquote_start': {\n      body = '';\n\n      while (this.next().type !== 'blockquote_end') {\n        body += this.tok();\n      }\n\n      return this.renderer.blockquote(body);\n    }\n    case 'list_start': {\n      body = '';\n      var ordered = this.token.ordered,\n          start = this.token.start;\n\n      while (this.next().type !== 'list_end') {\n        body += this.tok();\n      }\n\n      return this.renderer.list(body, ordered, start);\n    }\n    case 'list_item_start': {\n      body = '';\n      var loose = this.token.loose;\n      var checked = this.token.checked;\n      var task = this.token.task;\n\n      if (this.token.task) {\n        body += this.renderer.checkbox(checked);\n      }\n\n      while (this.next().type !== 'list_item_end') {\n        body += !loose && this.token.type === 'text'\n          ? this.parseText()\n          : this.tok();\n      }\n      return this.renderer.listitem(body, task, checked);\n    }\n    case 'html': {\n      // TODO parse inline content if parameter markdown=1\n      return this.renderer.html(this.token.text);\n    }\n    case 'paragraph': {\n      return this.renderer.paragraph(this.inline.output(this.token.text));\n    }\n    case 'text': {\n      return this.renderer.paragraph(this.parseText());\n    }\n    default: {\n      var errMsg = 'Token with \"' + this.token.type + '\" type was not found.';\n      if (this.options.silent) {\n        console.log(errMsg);\n      } else {\n        throw new Error(errMsg);\n      }\n    }\n  }\n};\n\n/**\n * Slugger generates header id\n */\n\nfunction Slugger() {\n  this.seen = {};\n}\n\n/**\n * Convert string to unique id\n */\n\nSlugger.prototype.slug = function(value) {\n  var slug = value\n    .toLowerCase()\n    .trim()\n    .replace(/[\\u2000-\\u206F\\u2E00-\\u2E7F\\\\'!\"#$%&()*+,./:;<=>?@[\\]^`{|}~]/g, '')\n    .replace(/\\s/g, '-');\n\n  if (this.seen.hasOwnProperty(slug)) {\n    var originalSlug = slug;\n    do {\n      this.seen[originalSlug]++;\n      slug = originalSlug + '-' + this.seen[originalSlug];\n    } while (this.seen.hasOwnProperty(slug));\n  }\n  this.seen[slug] = 0;\n\n  return slug;\n};\n\n/**\n * Helpers\n */\n\nfunction escape(html, encode) {\n  if (encode) {\n    if (escape.escapeTest.test(html)) {\n      return html.replace(escape.escapeReplace, function(ch) { return escape.replacements[ch]; });\n    }\n  } else {\n    if (escape.escapeTestNoEncode.test(html)) {\n      return html.replace(escape.escapeReplaceNoEncode, function(ch) { return escape.replacements[ch]; });\n    }\n  }\n\n  return html;\n}\n\nescape.escapeTest = /[&<>\"']/;\nescape.escapeReplace = /[&<>\"']/g;\nescape.replacements = {\n  '&': '&amp;',\n  '<': '&lt;',\n  '>': '&gt;',\n  '\"': '&quot;',\n  \"'\": '&#39;'\n};\n\nescape.escapeTestNoEncode = /[<>\"']|&(?!#?\\w+;)/;\nescape.escapeReplaceNoEncode = /[<>\"']|&(?!#?\\w+;)/g;\n\nfunction unescape(html) {\n  // explicitly match decimal, hex, and named HTML entities\n  return html.replace(/&(#(?:\\d+)|(?:#x[0-9A-Fa-f]+)|(?:\\w+));?/ig, function(_, n) {\n    n = n.toLowerCase();\n    if (n === 'colon') return ':';\n    if (n.charAt(0) === '#') {\n      return n.charAt(1) === 'x'\n        ? String.fromCharCode(parseInt(n.substring(2), 16))\n        : String.fromCharCode(+n.substring(1));\n    }\n    return '';\n  });\n}\n\nfunction edit(regex, opt) {\n  regex = regex.source || regex;\n  opt = opt || '';\n  return {\n    replace: function(name, val) {\n      val = val.source || val;\n      val = val.replace(/(^|[^\\[])\\^/g, '$1');\n      regex = regex.replace(name, val);\n      return this;\n    },\n    getRegex: function() {\n      return new RegExp(regex, opt);\n    }\n  };\n}\n\nfunction cleanUrl(sanitize, base, href) {\n  if (sanitize) {\n    try {\n      var prot = decodeURIComponent(unescape(href))\n        .replace(/[^\\w:]/g, '')\n        .toLowerCase();\n    } catch (e) {\n      return null;\n    }\n    if (prot.indexOf('javascript:') === 0 || prot.indexOf('vbscript:') === 0 || prot.indexOf('data:') === 0) {\n      return null;\n    }\n  }\n  if (base && !originIndependentUrl.test(href)) {\n    href = resolveUrl(base, href);\n  }\n  try {\n    href = encodeURI(href).replace(/%25/g, '%');\n  } catch (e) {\n    return null;\n  }\n  return href;\n}\n\nfunction resolveUrl(base, href) {\n  if (!baseUrls[' ' + base]) {\n    // we can ignore everything in base after the last slash of its path component,\n    // but we might need to add _that_\n    // https://tools.ietf.org/html/rfc3986#section-3\n    if (/^[^:]+:\\/*[^/]*$/.test(base)) {\n      baseUrls[' ' + base] = base + '/';\n    } else {\n      baseUrls[' ' + base] = rtrim(base, '/', true);\n    }\n  }\n  base = baseUrls[' ' + base];\n\n  if (href.slice(0, 2) === '//') {\n    return base.replace(/:[\\s\\S]*/, ':') + href;\n  } else if (href.charAt(0) === '/') {\n    return base.replace(/(:\\/*[^/]*)[\\s\\S]*/, '$1') + href;\n  } else {\n    return base + href;\n  }\n}\nvar baseUrls = {};\nvar originIndependentUrl = /^$|^[a-z][a-z0-9+.-]*:|^[?#]/i;\n\nfunction noop() {}\nnoop.exec = noop;\n\nfunction merge(obj) {\n  var i = 1,\n      target,\n      key;\n\n  for (; i < arguments.length; i++) {\n    target = arguments[i];\n    for (key in target) {\n      if (Object.prototype.hasOwnProperty.call(target, key)) {\n        obj[key] = target[key];\n      }\n    }\n  }\n\n  return obj;\n}\n\nfunction splitCells(tableRow, count) {\n  // ensure that every cell-delimiting pipe has a space\n  // before it to distinguish it from an escaped pipe\n  var row = tableRow.replace(/\\|/g, function(match, offset, str) {\n        var escaped = false,\n            curr = offset;\n        while (--curr >= 0 && str[curr] === '\\\\') escaped = !escaped;\n        if (escaped) {\n          // odd number of slashes means | is escaped\n          // so we leave it alone\n          return '|';\n        } else {\n          // add space before unescaped |\n          return ' |';\n        }\n      }),\n      cells = row.split(/ \\|/),\n      i = 0;\n\n  if (cells.length > count) {\n    cells.splice(count);\n  } else {\n    while (cells.length < count) cells.push('');\n  }\n\n  for (; i < cells.length; i++) {\n    // leading or trailing whitespace is ignored per the gfm spec\n    cells[i] = cells[i].trim().replace(/\\\\\\|/g, '|');\n  }\n  return cells;\n}\n\n// Remove trailing 'c's. Equivalent to str.replace(/c*$/, '').\n// /c*$/ is vulnerable to REDOS.\n// invert: Remove suffix of non-c chars instead. Default falsey.\nfunction rtrim(str, c, invert) {\n  if (str.length === 0) {\n    return '';\n  }\n\n  // Length of suffix matching the invert condition.\n  var suffLen = 0;\n\n  // Step left until we fail to match the invert condition.\n  while (suffLen < str.length) {\n    var currChar = str.charAt(str.length - suffLen - 1);\n    if (currChar === c && !invert) {\n      suffLen++;\n    } else if (currChar !== c && invert) {\n      suffLen++;\n    } else {\n      break;\n    }\n  }\n\n  return str.substr(0, str.length - suffLen);\n}\n\nfunction findClosingBracket(str, b) {\n  if (str.indexOf(b[1]) === -1) {\n    return -1;\n  }\n  var level = 0;\n  for (var i = 0; i < str.length; i++) {\n    if (str[i] === '\\\\') {\n      i++;\n    } else if (str[i] === b[0]) {\n      level++;\n    } else if (str[i] === b[1]) {\n      level--;\n      if (level < 0) {\n        return i;\n      }\n    }\n  }\n  return -1;\n}\n\n/**\n * Marked\n */\n\nfunction marked(src, opt, callback) {\n  // throw error in case of non string input\n  if (typeof src === 'undefined' || src === null) {\n    throw new Error('marked(): input parameter is undefined or null');\n  }\n  if (typeof src !== 'string') {\n    throw new Error('marked(): input parameter is of type '\n      + Object.prototype.toString.call(src) + ', string expected');\n  }\n\n  if (callback || typeof opt === 'function') {\n    if (!callback) {\n      callback = opt;\n      opt = null;\n    }\n\n    opt = merge({}, marked.defaults, opt || {});\n\n    var highlight = opt.highlight,\n        tokens,\n        pending,\n        i = 0;\n\n    try {\n      tokens = Lexer.lex(src, opt);\n    } catch (e) {\n      return callback(e);\n    }\n\n    pending = tokens.length;\n\n    var done = function(err) {\n      if (err) {\n        opt.highlight = highlight;\n        return callback(err);\n      }\n\n      var out;\n\n      try {\n        out = Parser.parse(tokens, opt);\n      } catch (e) {\n        err = e;\n      }\n\n      opt.highlight = highlight;\n\n      return err\n        ? callback(err)\n        : callback(null, out);\n    };\n\n    if (!highlight || highlight.length < 3) {\n      return done();\n    }\n\n    delete opt.highlight;\n\n    if (!pending) return done();\n\n    for (; i < tokens.length; i++) {\n      (function(token) {\n        if (token.type !== 'code') {\n          return --pending || done();\n        }\n        return highlight(token.text, token.lang, function(err, code) {\n          if (err) return done(err);\n          if (code == null || code === token.text) {\n            return --pending || done();\n          }\n          token.text = code;\n          token.escaped = true;\n          --pending || done();\n        });\n      })(tokens[i]);\n    }\n\n    return;\n  }\n  try {\n    if (opt) opt = merge({}, marked.defaults, opt);\n    return Parser.parse(Lexer.lex(src, opt), opt);\n  } catch (e) {\n    e.message += '\\nPlease report this to https://github.com/markedjs/marked.';\n    if ((opt || marked.defaults).silent) {\n      return '<p>An error occurred:</p><pre>'\n        + escape(e.message + '', true)\n        + '</pre>';\n    }\n    throw e;\n  }\n}\n\n/**\n * Options\n */\n\nmarked.options =\nmarked.setOptions = function(opt) {\n  merge(marked.defaults, opt);\n  return marked;\n};\n\nmarked.getDefaults = function() {\n  return {\n    baseUrl: null,\n    breaks: false,\n    gfm: true,\n    headerIds: true,\n    headerPrefix: '',\n    highlight: null,\n    langPrefix: 'language-',\n    mangle: true,\n    pedantic: false,\n    renderer: new Renderer(),\n    sanitize: false,\n    sanitizer: null,\n    silent: false,\n    smartLists: false,\n    smartypants: false,\n    tables: true,\n    xhtml: false\n  };\n};\n\nmarked.defaults = marked.getDefaults();\n\n/**\n * Expose\n */\n\nmarked.Parser = Parser;\nmarked.parser = Parser.parse;\n\nmarked.Renderer = Renderer;\nmarked.TextRenderer = TextRenderer;\n\nmarked.Lexer = Lexer;\nmarked.lexer = Lexer.lex;\n\nmarked.InlineLexer = InlineLexer;\nmarked.inlineLexer = InlineLexer.output;\n\nmarked.Slugger = Slugger;\n\nmarked.parse = marked;\n\n{\n  module.exports = marked;\n}\n})();\n});\n\n/* src/routes/article/_ArticleMeta.svelte generated by Svelte v3.23.2 */\n\nfunction create_if_block(ctx) {\n\tlet span;\n\tlet a;\n\tlet i0;\n\tlet t0;\n\tlet a_href_value;\n\tlet t1;\n\tlet button;\n\tlet i1;\n\tlet t2;\n\tlet mounted;\n\tlet dispose;\n\n\treturn {\n\t\tc() {\n\t\t\tspan = element(\"span\");\n\t\t\ta = element(\"a\");\n\t\t\ti0 = element(\"i\");\n\t\t\tt0 = text(\" Edit Article\");\n\t\t\tt1 = space();\n\t\t\tbutton = element(\"button\");\n\t\t\ti1 = element(\"i\");\n\t\t\tt2 = text(\" Delete Article\");\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tspan = claim_element(nodes, \"SPAN\", {});\n\t\t\tvar span_nodes = children(span);\n\t\t\ta = claim_element(span_nodes, \"A\", { href: true, class: true });\n\t\t\tvar a_nodes = children(a);\n\t\t\ti0 = claim_element(a_nodes, \"I\", { class: true });\n\t\t\tchildren(i0).forEach(detach);\n\t\t\tt0 = claim_text(a_nodes, \" Edit Article\");\n\t\t\ta_nodes.forEach(detach);\n\t\t\tt1 = claim_space(span_nodes);\n\t\t\tbutton = claim_element(span_nodes, \"BUTTON\", { class: true });\n\t\t\tvar button_nodes = children(button);\n\t\t\ti1 = claim_element(button_nodes, \"I\", { class: true });\n\t\t\tchildren(i1).forEach(detach);\n\t\t\tt2 = claim_text(button_nodes, \" Delete Article\");\n\t\t\tbutton_nodes.forEach(detach);\n\t\t\tspan_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(i0, \"class\", \"ion-edit\");\n\t\t\tattr(a, \"href\", a_href_value = \"/editor/\" + /*article*/ ctx[0].slug);\n\t\t\tattr(a, \"class\", \"btn btn-outline-secondary btn-sm\");\n\t\t\tattr(i1, \"class\", \"ion-trash-a\");\n\t\t\tattr(button, \"class\", \"btn btn-outline-danger btn-sm\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, span, anchor);\n\t\t\tappend(span, a);\n\t\t\tappend(a, i0);\n\t\t\tappend(a, t0);\n\t\t\tappend(span, t1);\n\t\t\tappend(span, button);\n\t\t\tappend(button, i1);\n\t\t\tappend(button, t2);\n\n\t\t\tif (!mounted) {\n\t\t\t\tdispose = listen(button, \"click\", /*remove*/ ctx[2]);\n\t\t\t\tmounted = true;\n\t\t\t}\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tif (dirty & /*article*/ 1 && a_href_value !== (a_href_value = \"/editor/\" + /*article*/ ctx[0].slug)) {\n\t\t\t\tattr(a, \"href\", a_href_value);\n\t\t\t}\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(span);\n\t\t\tmounted = false;\n\t\t\tdispose();\n\t\t}\n\t};\n}\n\nfunction create_fragment(ctx) {\n\tlet div1;\n\tlet a0;\n\tlet img;\n\tlet img_src_value;\n\tlet img_alt_value;\n\tlet a0_href_value;\n\tlet t0;\n\tlet div0;\n\tlet a1;\n\tlet t1_value = /*article*/ ctx[0].author.username + \"\";\n\tlet t1;\n\tlet a1_href_value;\n\tlet t2;\n\tlet span;\n\tlet t3_value = new Date(/*article*/ ctx[0].createdAt).toDateString() + \"\";\n\tlet t3;\n\tlet t4;\n\tlet if_block = /*canModify*/ ctx[1] && create_if_block(ctx);\n\n\treturn {\n\t\tc() {\n\t\t\tdiv1 = element(\"div\");\n\t\t\ta0 = element(\"a\");\n\t\t\timg = element(\"img\");\n\t\t\tt0 = space();\n\t\t\tdiv0 = element(\"div\");\n\t\t\ta1 = element(\"a\");\n\t\t\tt1 = text(t1_value);\n\t\t\tt2 = space();\n\t\t\tspan = element(\"span\");\n\t\t\tt3 = text(t3_value);\n\t\t\tt4 = space();\n\t\t\tif (if_block) if_block.c();\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tdiv1 = claim_element(nodes, \"DIV\", { class: true });\n\t\t\tvar div1_nodes = children(div1);\n\t\t\ta0 = claim_element(div1_nodes, \"A\", { href: true });\n\t\t\tvar a0_nodes = children(a0);\n\t\t\timg = claim_element(a0_nodes, \"IMG\", { src: true, alt: true });\n\t\t\ta0_nodes.forEach(detach);\n\t\t\tt0 = claim_space(div1_nodes);\n\t\t\tdiv0 = claim_element(div1_nodes, \"DIV\", { class: true });\n\t\t\tvar div0_nodes = children(div0);\n\t\t\ta1 = claim_element(div0_nodes, \"A\", { href: true, class: true });\n\t\t\tvar a1_nodes = children(a1);\n\t\t\tt1 = claim_text(a1_nodes, t1_value);\n\t\t\ta1_nodes.forEach(detach);\n\t\t\tt2 = claim_space(div0_nodes);\n\t\t\tspan = claim_element(div0_nodes, \"SPAN\", { class: true });\n\t\t\tvar span_nodes = children(span);\n\t\t\tt3 = claim_text(span_nodes, t3_value);\n\t\t\tspan_nodes.forEach(detach);\n\t\t\tdiv0_nodes.forEach(detach);\n\t\t\tt4 = claim_space(div1_nodes);\n\t\t\tif (if_block) if_block.l(div1_nodes);\n\t\t\tdiv1_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tif (img.src !== (img_src_value = /*article*/ ctx[0].author.image)) attr(img, \"src\", img_src_value);\n\t\t\tattr(img, \"alt\", img_alt_value = /*article*/ ctx[0].author.username);\n\t\t\tattr(a0, \"href\", a0_href_value = \"/profile/@\" + /*article*/ ctx[0].author.username);\n\t\t\tattr(a1, \"href\", a1_href_value = \"/profile/@\" + /*article*/ ctx[0].author.username);\n\t\t\tattr(a1, \"class\", \"author\");\n\t\t\tattr(span, \"class\", \"date\");\n\t\t\tattr(div0, \"class\", \"info\");\n\t\t\tattr(div1, \"class\", \"article-meta\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, div1, anchor);\n\t\t\tappend(div1, a0);\n\t\t\tappend(a0, img);\n\t\t\tappend(div1, t0);\n\t\t\tappend(div1, div0);\n\t\t\tappend(div0, a1);\n\t\t\tappend(a1, t1);\n\t\t\tappend(div0, t2);\n\t\t\tappend(div0, span);\n\t\t\tappend(span, t3);\n\t\t\tappend(div1, t4);\n\t\t\tif (if_block) if_block.m(div1, null);\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tif (dirty & /*article*/ 1 && img.src !== (img_src_value = /*article*/ ctx[0].author.image)) {\n\t\t\t\tattr(img, \"src\", img_src_value);\n\t\t\t}\n\n\t\t\tif (dirty & /*article*/ 1 && img_alt_value !== (img_alt_value = /*article*/ ctx[0].author.username)) {\n\t\t\t\tattr(img, \"alt\", img_alt_value);\n\t\t\t}\n\n\t\t\tif (dirty & /*article*/ 1 && a0_href_value !== (a0_href_value = \"/profile/@\" + /*article*/ ctx[0].author.username)) {\n\t\t\t\tattr(a0, \"href\", a0_href_value);\n\t\t\t}\n\n\t\t\tif (dirty & /*article*/ 1 && t1_value !== (t1_value = /*article*/ ctx[0].author.username + \"\")) set_data(t1, t1_value);\n\n\t\t\tif (dirty & /*article*/ 1 && a1_href_value !== (a1_href_value = \"/profile/@\" + /*article*/ ctx[0].author.username)) {\n\t\t\t\tattr(a1, \"href\", a1_href_value);\n\t\t\t}\n\n\t\t\tif (dirty & /*article*/ 1 && t3_value !== (t3_value = new Date(/*article*/ ctx[0].createdAt).toDateString() + \"\")) set_data(t3, t3_value);\n\n\t\t\tif (/*canModify*/ ctx[1]) {\n\t\t\t\tif (if_block) {\n\t\t\t\t\tif_block.p(ctx, dirty);\n\t\t\t\t} else {\n\t\t\t\t\tif_block = create_if_block(ctx);\n\t\t\t\t\tif_block.c();\n\t\t\t\t\tif_block.m(div1, null);\n\t\t\t\t}\n\t\t\t} else if (if_block) {\n\t\t\t\tif_block.d(1);\n\t\t\t\tif_block = null;\n\t\t\t}\n\t\t},\n\t\ti: noop,\n\t\to: noop,\n\t\td(detaching) {\n\t\t\tif (detaching) detach(div1);\n\t\t\tif (if_block) if_block.d();\n\t\t}\n\t};\n}\n\nfunction instance($$self, $$props, $$invalidate) {\n\tlet { article } = $$props;\n\tlet { user } = $$props;\n\n\tasync function remove() {\n\t\tawait del(`/articles/${article.slug}`, user && user.token);\n\t\tgoto(\"/\");\n\t}\n\n\t$$self.$set = $$props => {\n\t\tif (\"article\" in $$props) $$invalidate(0, article = $$props.article);\n\t\tif (\"user\" in $$props) $$invalidate(3, user = $$props.user);\n\t};\n\n\tlet canModify;\n\n\t$$self.$$.update = () => {\n\t\tif ($$self.$$.dirty & /*user, article*/ 9) {\n\t\t\t $$invalidate(1, canModify = user && article.author.username === user.username);\n\t\t}\n\t};\n\n\treturn [article, canModify, remove, user];\n}\n\nclass ArticleMeta extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance, create_fragment, safe_not_equal, { article: 0, user: 3 });\n\t}\n}\n\n/* src/routes/article/_CommentInput.svelte generated by Svelte v3.23.2 */\n\nfunction create_fragment$1(ctx) {\n\tlet form;\n\tlet div0;\n\tlet textarea;\n\tlet t0;\n\tlet div1;\n\tlet img;\n\tlet img_src_value;\n\tlet img_alt_value;\n\tlet t1;\n\tlet button;\n\tlet t2;\n\tlet mounted;\n\tlet dispose;\n\n\treturn {\n\t\tc() {\n\t\t\tform = element(\"form\");\n\t\t\tdiv0 = element(\"div\");\n\t\t\ttextarea = element(\"textarea\");\n\t\t\tt0 = space();\n\t\t\tdiv1 = element(\"div\");\n\t\t\timg = element(\"img\");\n\t\t\tt1 = space();\n\t\t\tbutton = element(\"button\");\n\t\t\tt2 = text(\"Post Comment\");\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tform = claim_element(nodes, \"FORM\", { class: true });\n\t\t\tvar form_nodes = children(form);\n\t\t\tdiv0 = claim_element(form_nodes, \"DIV\", { class: true });\n\t\t\tvar div0_nodes = children(div0);\n\n\t\t\ttextarea = claim_element(div0_nodes, \"TEXTAREA\", {\n\t\t\t\tclass: true,\n\t\t\t\tplaceholder: true,\n\t\t\t\trows: true\n\t\t\t});\n\n\t\t\tchildren(textarea).forEach(detach);\n\t\t\tdiv0_nodes.forEach(detach);\n\t\t\tt0 = claim_space(form_nodes);\n\t\t\tdiv1 = claim_element(form_nodes, \"DIV\", { class: true });\n\t\t\tvar div1_nodes = children(div1);\n\t\t\timg = claim_element(div1_nodes, \"IMG\", { src: true, class: true, alt: true });\n\t\t\tt1 = claim_space(div1_nodes);\n\t\t\tbutton = claim_element(div1_nodes, \"BUTTON\", { class: true, type: true });\n\t\t\tvar button_nodes = children(button);\n\t\t\tt2 = claim_text(button_nodes, \"Post Comment\");\n\t\t\tbutton_nodes.forEach(detach);\n\t\t\tdiv1_nodes.forEach(detach);\n\t\t\tform_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(textarea, \"class\", \"form-control\");\n\t\t\tattr(textarea, \"placeholder\", \"Write a comment...\");\n\t\t\tattr(textarea, \"rows\", \"3\");\n\t\t\tattr(div0, \"class\", \"card-block\");\n\t\t\tif (img.src !== (img_src_value = /*user*/ ctx[0].image)) attr(img, \"src\", img_src_value);\n\t\t\tattr(img, \"class\", \"comment-author-img\");\n\t\t\tattr(img, \"alt\", img_alt_value = /*user*/ ctx[0].username);\n\t\t\tattr(button, \"class\", \"btn btn-sm btn-primary\");\n\t\t\tattr(button, \"type\", \"submit\");\n\t\t\tattr(div1, \"class\", \"card-footer\");\n\t\t\tattr(form, \"class\", \"card comment-form\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, form, anchor);\n\t\t\tappend(form, div0);\n\t\t\tappend(div0, textarea);\n\t\t\tset_input_value(textarea, /*body*/ ctx[1]);\n\t\t\tappend(form, t0);\n\t\t\tappend(form, div1);\n\t\t\tappend(div1, img);\n\t\t\tappend(div1, t1);\n\t\t\tappend(div1, button);\n\t\t\tappend(button, t2);\n\n\t\t\tif (!mounted) {\n\t\t\t\tdispose = [\n\t\t\t\t\tlisten(textarea, \"input\", /*textarea_input_handler*/ ctx[4]),\n\t\t\t\t\tlisten(form, \"submit\", prevent_default(/*submit*/ ctx[2]))\n\t\t\t\t];\n\n\t\t\t\tmounted = true;\n\t\t\t}\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tif (dirty & /*body*/ 2) {\n\t\t\t\tset_input_value(textarea, /*body*/ ctx[1]);\n\t\t\t}\n\n\t\t\tif (dirty & /*user*/ 1 && img.src !== (img_src_value = /*user*/ ctx[0].image)) {\n\t\t\t\tattr(img, \"src\", img_src_value);\n\t\t\t}\n\n\t\t\tif (dirty & /*user*/ 1 && img_alt_value !== (img_alt_value = /*user*/ ctx[0].username)) {\n\t\t\t\tattr(img, \"alt\", img_alt_value);\n\t\t\t}\n\t\t},\n\t\ti: noop,\n\t\to: noop,\n\t\td(detaching) {\n\t\t\tif (detaching) detach(form);\n\t\t\tmounted = false;\n\t\t\trun_all(dispose);\n\t\t}\n\t};\n}\n\nfunction instance$1($$self, $$props, $$invalidate) {\n\tlet { slug } = $$props;\n\tlet { user } = $$props;\n\tconst dispatch = createEventDispatcher();\n\tlet body = \"\";\n\n\tasync function submit(event) {\n\t\tconst response = await post(`articles/${slug}/comments`, { comment: { body } }, user && user.token);\n\n\t\tif (response.comment) {\n\t\t\tdispatch(\"commented\", response);\n\t\t\t$$invalidate(1, body = \"\");\n\t\t}\n\t}\n\n\tfunction textarea_input_handler() {\n\t\tbody = this.value;\n\t\t$$invalidate(1, body);\n\t}\n\n\t$$self.$set = $$props => {\n\t\tif (\"slug\" in $$props) $$invalidate(3, slug = $$props.slug);\n\t\tif (\"user\" in $$props) $$invalidate(0, user = $$props.user);\n\t};\n\n\treturn [user, body, submit, slug, textarea_input_handler];\n}\n\nclass CommentInput extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance$1, create_fragment$1, safe_not_equal, { slug: 3, user: 0 });\n\t}\n}\n\n/* src/routes/article/_Comment.svelte generated by Svelte v3.23.2 */\n\nfunction create_if_block$1(ctx) {\n\tlet span;\n\tlet i;\n\tlet mounted;\n\tlet dispose;\n\n\treturn {\n\t\tc() {\n\t\t\tspan = element(\"span\");\n\t\t\ti = element(\"i\");\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tspan = claim_element(nodes, \"SPAN\", { class: true });\n\t\t\tvar span_nodes = children(span);\n\t\t\ti = claim_element(span_nodes, \"I\", { class: true });\n\t\t\tchildren(i).forEach(detach);\n\t\t\tspan_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(i, \"class\", \"ion-trash-a\");\n\t\t\tattr(span, \"class\", \"mod-options\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, span, anchor);\n\t\t\tappend(span, i);\n\n\t\t\tif (!mounted) {\n\t\t\t\tdispose = listen(i, \"click\", /*remove*/ ctx[2]);\n\t\t\t\tmounted = true;\n\t\t\t}\n\t\t},\n\t\tp: noop,\n\t\td(detaching) {\n\t\t\tif (detaching) detach(span);\n\t\t\tmounted = false;\n\t\t\tdispose();\n\t\t}\n\t};\n}\n\nfunction create_fragment$2(ctx) {\n\tlet div2;\n\tlet div0;\n\tlet p;\n\tlet t0_value = /*comment*/ ctx[0].body + \"\";\n\tlet t0;\n\tlet t1;\n\tlet div1;\n\tlet a0;\n\tlet img;\n\tlet img_src_value;\n\tlet img_alt_value;\n\tlet a0_href_value;\n\tlet t2;\n\tlet a1;\n\tlet t3_value = /*comment*/ ctx[0].author.username + \"\";\n\tlet t3;\n\tlet a1_href_value;\n\tlet t4;\n\tlet span;\n\tlet t5_value = new Date(/*comment*/ ctx[0].createdAt).toDateString() + \"\";\n\tlet t5;\n\tlet t6;\n\tlet if_block = /*user*/ ctx[1] && /*comment*/ ctx[0].author.username === /*user*/ ctx[1].username && create_if_block$1(ctx);\n\n\treturn {\n\t\tc() {\n\t\t\tdiv2 = element(\"div\");\n\t\t\tdiv0 = element(\"div\");\n\t\t\tp = element(\"p\");\n\t\t\tt0 = text(t0_value);\n\t\t\tt1 = space();\n\t\t\tdiv1 = element(\"div\");\n\t\t\ta0 = element(\"a\");\n\t\t\timg = element(\"img\");\n\t\t\tt2 = space();\n\t\t\ta1 = element(\"a\");\n\t\t\tt3 = text(t3_value);\n\t\t\tt4 = space();\n\t\t\tspan = element(\"span\");\n\t\t\tt5 = text(t5_value);\n\t\t\tt6 = space();\n\t\t\tif (if_block) if_block.c();\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tdiv2 = claim_element(nodes, \"DIV\", { class: true });\n\t\t\tvar div2_nodes = children(div2);\n\t\t\tdiv0 = claim_element(div2_nodes, \"DIV\", { class: true });\n\t\t\tvar div0_nodes = children(div0);\n\t\t\tp = claim_element(div0_nodes, \"P\", { class: true });\n\t\t\tvar p_nodes = children(p);\n\t\t\tt0 = claim_text(p_nodes, t0_value);\n\t\t\tp_nodes.forEach(detach);\n\t\t\tdiv0_nodes.forEach(detach);\n\t\t\tt1 = claim_space(div2_nodes);\n\t\t\tdiv1 = claim_element(div2_nodes, \"DIV\", { class: true });\n\t\t\tvar div1_nodes = children(div1);\n\t\t\ta0 = claim_element(div1_nodes, \"A\", { href: true, class: true });\n\t\t\tvar a0_nodes = children(a0);\n\t\t\timg = claim_element(a0_nodes, \"IMG\", { src: true, class: true, alt: true });\n\t\t\ta0_nodes.forEach(detach);\n\t\t\tt2 = claim_space(div1_nodes);\n\t\t\ta1 = claim_element(div1_nodes, \"A\", { href: true, class: true });\n\t\t\tvar a1_nodes = children(a1);\n\t\t\tt3 = claim_text(a1_nodes, t3_value);\n\t\t\ta1_nodes.forEach(detach);\n\t\t\tt4 = claim_space(div1_nodes);\n\t\t\tspan = claim_element(div1_nodes, \"SPAN\", { class: true });\n\t\t\tvar span_nodes = children(span);\n\t\t\tt5 = claim_text(span_nodes, t5_value);\n\t\t\tspan_nodes.forEach(detach);\n\t\t\tt6 = claim_space(div1_nodes);\n\t\t\tif (if_block) if_block.l(div1_nodes);\n\t\t\tdiv1_nodes.forEach(detach);\n\t\t\tdiv2_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(p, \"class\", \"card-text\");\n\t\t\tattr(div0, \"class\", \"card-block\");\n\t\t\tif (img.src !== (img_src_value = /*comment*/ ctx[0].author.image)) attr(img, \"src\", img_src_value);\n\t\t\tattr(img, \"class\", \"comment-author-img\");\n\t\t\tattr(img, \"alt\", img_alt_value = /*comment*/ ctx[0].author.username);\n\t\t\tattr(a0, \"href\", a0_href_value = \"/profile/@\" + /*comment*/ ctx[0].author.username);\n\t\t\tattr(a0, \"class\", \"comment-author\");\n\t\t\tattr(a1, \"href\", a1_href_value = \"/profile/@\" + /*comment*/ ctx[0].author.username);\n\t\t\tattr(a1, \"class\", \"comment-author\");\n\t\t\tattr(span, \"class\", \"date-posted\");\n\t\t\tattr(div1, \"class\", \"card-footer\");\n\t\t\tattr(div2, \"class\", \"card\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, div2, anchor);\n\t\t\tappend(div2, div0);\n\t\t\tappend(div0, p);\n\t\t\tappend(p, t0);\n\t\t\tappend(div2, t1);\n\t\t\tappend(div2, div1);\n\t\t\tappend(div1, a0);\n\t\t\tappend(a0, img);\n\t\t\tappend(div1, t2);\n\t\t\tappend(div1, a1);\n\t\t\tappend(a1, t3);\n\t\t\tappend(div1, t4);\n\t\t\tappend(div1, span);\n\t\t\tappend(span, t5);\n\t\t\tappend(div1, t6);\n\t\t\tif (if_block) if_block.m(div1, null);\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tif (dirty & /*comment*/ 1 && t0_value !== (t0_value = /*comment*/ ctx[0].body + \"\")) set_data(t0, t0_value);\n\n\t\t\tif (dirty & /*comment*/ 1 && img.src !== (img_src_value = /*comment*/ ctx[0].author.image)) {\n\t\t\t\tattr(img, \"src\", img_src_value);\n\t\t\t}\n\n\t\t\tif (dirty & /*comment*/ 1 && img_alt_value !== (img_alt_value = /*comment*/ ctx[0].author.username)) {\n\t\t\t\tattr(img, \"alt\", img_alt_value);\n\t\t\t}\n\n\t\t\tif (dirty & /*comment*/ 1 && a0_href_value !== (a0_href_value = \"/profile/@\" + /*comment*/ ctx[0].author.username)) {\n\t\t\t\tattr(a0, \"href\", a0_href_value);\n\t\t\t}\n\n\t\t\tif (dirty & /*comment*/ 1 && t3_value !== (t3_value = /*comment*/ ctx[0].author.username + \"\")) set_data(t3, t3_value);\n\n\t\t\tif (dirty & /*comment*/ 1 && a1_href_value !== (a1_href_value = \"/profile/@\" + /*comment*/ ctx[0].author.username)) {\n\t\t\t\tattr(a1, \"href\", a1_href_value);\n\t\t\t}\n\n\t\t\tif (dirty & /*comment*/ 1 && t5_value !== (t5_value = new Date(/*comment*/ ctx[0].createdAt).toDateString() + \"\")) set_data(t5, t5_value);\n\n\t\t\tif (/*user*/ ctx[1] && /*comment*/ ctx[0].author.username === /*user*/ ctx[1].username) {\n\t\t\t\tif (if_block) {\n\t\t\t\t\tif_block.p(ctx, dirty);\n\t\t\t\t} else {\n\t\t\t\t\tif_block = create_if_block$1(ctx);\n\t\t\t\t\tif_block.c();\n\t\t\t\t\tif_block.m(div1, null);\n\t\t\t\t}\n\t\t\t} else if (if_block) {\n\t\t\t\tif_block.d(1);\n\t\t\t\tif_block = null;\n\t\t\t}\n\t\t},\n\t\ti: noop,\n\t\to: noop,\n\t\td(detaching) {\n\t\t\tif (detaching) detach(div2);\n\t\t\tif (if_block) if_block.d();\n\t\t}\n\t};\n}\n\nfunction instance$2($$self, $$props, $$invalidate) {\n\tlet { comment } = $$props;\n\tlet { slug } = $$props;\n\tlet { user } = $$props;\n\tconst dispatch = createEventDispatcher();\n\n\tasync function remove() {\n\t\tawait del(`articles/${slug}/comments/${comment.id}`, user && user.token);\n\t\tdispatch(\"deleted\");\n\t}\n\n\t$$self.$set = $$props => {\n\t\tif (\"comment\" in $$props) $$invalidate(0, comment = $$props.comment);\n\t\tif (\"slug\" in $$props) $$invalidate(3, slug = $$props.slug);\n\t\tif (\"user\" in $$props) $$invalidate(1, user = $$props.user);\n\t};\n\n\treturn [comment, user, remove, slug];\n}\n\nclass Comment extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance$2, create_fragment$2, safe_not_equal, { comment: 0, slug: 3, user: 1 });\n\t}\n}\n\n/* src/routes/article/_CommentContainer.svelte generated by Svelte v3.23.2 */\n\nfunction get_each_context(ctx, list, i) {\n\tconst child_ctx = ctx.slice();\n\tchild_ctx[6] = list[i];\n\tchild_ctx[8] = i;\n\treturn child_ctx;\n}\n\n// (18:1) {:else}\nfunction create_else_block(ctx) {\n\tlet p;\n\tlet a0;\n\tlet t0;\n\tlet t1;\n\tlet a1;\n\tlet t2;\n\tlet t3;\n\n\treturn {\n\t\tc() {\n\t\t\tp = element(\"p\");\n\t\t\ta0 = element(\"a\");\n\t\t\tt0 = text(\"Sign in\");\n\t\t\tt1 = text(\" or \");\n\t\t\ta1 = element(\"a\");\n\t\t\tt2 = text(\"sign up\");\n\t\t\tt3 = text(\" to add comments on this article.\");\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tp = claim_element(nodes, \"P\", {});\n\t\t\tvar p_nodes = children(p);\n\t\t\ta0 = claim_element(p_nodes, \"A\", { href: true });\n\t\t\tvar a0_nodes = children(a0);\n\t\t\tt0 = claim_text(a0_nodes, \"Sign in\");\n\t\t\ta0_nodes.forEach(detach);\n\t\t\tt1 = claim_text(p_nodes, \" or \");\n\t\t\ta1 = claim_element(p_nodes, \"A\", { href: true });\n\t\t\tvar a1_nodes = children(a1);\n\t\t\tt2 = claim_text(a1_nodes, \"sign up\");\n\t\t\ta1_nodes.forEach(detach);\n\t\t\tt3 = claim_text(p_nodes, \" to add comments on this article.\");\n\t\t\tp_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(a0, \"href\", \"/login\");\n\t\t\tattr(a1, \"href\", \"/register\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, p, anchor);\n\t\t\tappend(p, a0);\n\t\t\tappend(a0, t0);\n\t\t\tappend(p, t1);\n\t\t\tappend(p, a1);\n\t\t\tappend(a1, t2);\n\t\t\tappend(p, t3);\n\t\t},\n\t\tp: noop,\n\t\ti: noop,\n\t\to: noop,\n\t\td(detaching) {\n\t\t\tif (detaching) detach(p);\n\t\t}\n\t};\n}\n\n// (13:1) {#if user}\nfunction create_if_block$2(ctx) {\n\tlet div;\n\tlet listerrors;\n\tlet t;\n\tlet commentinput;\n\tlet current;\n\tlisterrors = new ListErrors({ props: { errors: /*errors*/ ctx[1] } });\n\n\tcommentinput = new CommentInput({\n\t\t\tprops: {\n\t\t\t\tslug: /*slug*/ ctx[2],\n\t\t\t\tuser: /*user*/ ctx[3]\n\t\t\t}\n\t\t});\n\n\tcommentinput.$on(\"commented\", /*commented_handler*/ ctx[4]);\n\n\treturn {\n\t\tc() {\n\t\t\tdiv = element(\"div\");\n\t\t\tcreate_component(listerrors.$$.fragment);\n\t\t\tt = space();\n\t\t\tcreate_component(commentinput.$$.fragment);\n\t\t},\n\t\tl(nodes) {\n\t\t\tdiv = claim_element(nodes, \"DIV\", {});\n\t\t\tvar div_nodes = children(div);\n\t\t\tclaim_component(listerrors.$$.fragment, div_nodes);\n\t\t\tt = claim_space(div_nodes);\n\t\t\tclaim_component(commentinput.$$.fragment, div_nodes);\n\t\t\tdiv_nodes.forEach(detach);\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, div, anchor);\n\t\t\tmount_component(listerrors, div, null);\n\t\t\tappend(div, t);\n\t\t\tmount_component(commentinput, div, null);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tconst listerrors_changes = {};\n\t\t\tif (dirty & /*errors*/ 2) listerrors_changes.errors = /*errors*/ ctx[1];\n\t\t\tlisterrors.$set(listerrors_changes);\n\t\t\tconst commentinput_changes = {};\n\t\t\tif (dirty & /*slug*/ 4) commentinput_changes.slug = /*slug*/ ctx[2];\n\t\t\tif (dirty & /*user*/ 8) commentinput_changes.user = /*user*/ ctx[3];\n\t\t\tcommentinput.$set(commentinput_changes);\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(listerrors.$$.fragment, local);\n\t\t\ttransition_in(commentinput.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(listerrors.$$.fragment, local);\n\t\t\ttransition_out(commentinput.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(div);\n\t\t\tdestroy_component(listerrors);\n\t\t\tdestroy_component(commentinput);\n\t\t}\n\t};\n}\n\n// (24:1) {#each comments as comment, i (comment.id)}\nfunction create_each_block(key_1, ctx) {\n\tlet first;\n\tlet comment;\n\tlet current;\n\n\tfunction deleted_handler(...args) {\n\t\treturn /*deleted_handler*/ ctx[5](/*i*/ ctx[8], ...args);\n\t}\n\n\tcomment = new Comment({\n\t\t\tprops: {\n\t\t\t\tcomment: /*comment*/ ctx[6],\n\t\t\t\tslug: /*slug*/ ctx[2],\n\t\t\t\tuser: /*user*/ ctx[3]\n\t\t\t}\n\t\t});\n\n\tcomment.$on(\"deleted\", deleted_handler);\n\n\treturn {\n\t\tkey: key_1,\n\t\tfirst: null,\n\t\tc() {\n\t\t\tfirst = empty();\n\t\t\tcreate_component(comment.$$.fragment);\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tfirst = empty();\n\t\t\tclaim_component(comment.$$.fragment, nodes);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tthis.first = first;\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, first, anchor);\n\t\t\tmount_component(comment, target, anchor);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(new_ctx, dirty) {\n\t\t\tctx = new_ctx;\n\t\t\tconst comment_changes = {};\n\t\t\tif (dirty & /*comments*/ 1) comment_changes.comment = /*comment*/ ctx[6];\n\t\t\tif (dirty & /*slug*/ 4) comment_changes.slug = /*slug*/ ctx[2];\n\t\t\tif (dirty & /*user*/ 8) comment_changes.user = /*user*/ ctx[3];\n\t\t\tcomment.$set(comment_changes);\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(comment.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(comment.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(first);\n\t\t\tdestroy_component(comment, detaching);\n\t\t}\n\t};\n}\n\nfunction create_fragment$3(ctx) {\n\tlet div;\n\tlet current_block_type_index;\n\tlet if_block;\n\tlet t;\n\tlet each_blocks = [];\n\tlet each_1_lookup = new Map();\n\tlet current;\n\tconst if_block_creators = [create_if_block$2, create_else_block];\n\tconst if_blocks = [];\n\n\tfunction select_block_type(ctx, dirty) {\n\t\tif (/*user*/ ctx[3]) return 0;\n\t\treturn 1;\n\t}\n\n\tcurrent_block_type_index = select_block_type(ctx);\n\tif_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);\n\tlet each_value = /*comments*/ ctx[0];\n\tconst get_key = ctx => /*comment*/ ctx[6].id;\n\n\tfor (let i = 0; i < each_value.length; i += 1) {\n\t\tlet child_ctx = get_each_context(ctx, each_value, i);\n\t\tlet key = get_key(child_ctx);\n\t\teach_1_lookup.set(key, each_blocks[i] = create_each_block(key, child_ctx));\n\t}\n\n\treturn {\n\t\tc() {\n\t\t\tdiv = element(\"div\");\n\t\t\tif_block.c();\n\t\t\tt = space();\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].c();\n\t\t\t}\n\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tdiv = claim_element(nodes, \"DIV\", { class: true });\n\t\t\tvar div_nodes = children(div);\n\t\t\tif_block.l(div_nodes);\n\t\t\tt = claim_space(div_nodes);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].l(div_nodes);\n\t\t\t}\n\n\t\t\tdiv_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(div, \"class\", \"col-xs-12 col-md-8 offset-md-2\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, div, anchor);\n\t\t\tif_blocks[current_block_type_index].m(div, null);\n\t\t\tappend(div, t);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].m(div, null);\n\t\t\t}\n\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tlet previous_block_index = current_block_type_index;\n\t\t\tcurrent_block_type_index = select_block_type(ctx);\n\n\t\t\tif (current_block_type_index === previous_block_index) {\n\t\t\t\tif_blocks[current_block_type_index].p(ctx, dirty);\n\t\t\t} else {\n\t\t\t\tgroup_outros();\n\n\t\t\t\ttransition_out(if_blocks[previous_block_index], 1, 1, () => {\n\t\t\t\t\tif_blocks[previous_block_index] = null;\n\t\t\t\t});\n\n\t\t\t\tcheck_outros();\n\t\t\t\tif_block = if_blocks[current_block_type_index];\n\n\t\t\t\tif (!if_block) {\n\t\t\t\t\tif_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);\n\t\t\t\t\tif_block.c();\n\t\t\t\t}\n\n\t\t\t\ttransition_in(if_block, 1);\n\t\t\t\tif_block.m(div, t);\n\t\t\t}\n\n\t\t\tif (dirty & /*comments, slug, user*/ 13) {\n\t\t\t\tconst each_value = /*comments*/ ctx[0];\n\t\t\t\tgroup_outros();\n\t\t\t\teach_blocks = update_keyed_each(each_blocks, dirty, get_key, 1, ctx, each_value, each_1_lookup, div, outro_and_destroy_block, create_each_block, null, get_each_context);\n\t\t\t\tcheck_outros();\n\t\t\t}\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(if_block);\n\n\t\t\tfor (let i = 0; i < each_value.length; i += 1) {\n\t\t\t\ttransition_in(each_blocks[i]);\n\t\t\t}\n\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(if_block);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\ttransition_out(each_blocks[i]);\n\t\t\t}\n\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(div);\n\t\t\tif_blocks[current_block_type_index].d();\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].d();\n\t\t\t}\n\t\t}\n\t};\n}\n\nfunction instance$3($$self, $$props, $$invalidate) {\n\tlet { comments } = $$props;\n\tlet { errors } = $$props;\n\tlet { slug } = $$props;\n\tlet { user } = $$props;\n\tconst commented_handler = ({ detail }) => $$invalidate(0, comments = [detail.comment, ...comments]);\n\tconst deleted_handler = i => $$invalidate(0, comments = comments.filter((_, index) => i !== index));\n\n\t$$self.$set = $$props => {\n\t\tif (\"comments\" in $$props) $$invalidate(0, comments = $$props.comments);\n\t\tif (\"errors\" in $$props) $$invalidate(1, errors = $$props.errors);\n\t\tif (\"slug\" in $$props) $$invalidate(2, slug = $$props.slug);\n\t\tif (\"user\" in $$props) $$invalidate(3, user = $$props.user);\n\t};\n\n\treturn [comments, errors, slug, user, commented_handler, deleted_handler];\n}\n\nclass CommentContainer extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance$3, create_fragment$3, safe_not_equal, { comments: 0, errors: 1, slug: 2, user: 3 });\n\t}\n}\n\n/* src/routes/article/[slug].svelte generated by Svelte v3.23.2 */\n\nfunction get_each_context$1(ctx, list, i) {\n\tconst child_ctx = ctx.slice();\n\tchild_ctx[7] = list[i];\n\treturn child_ctx;\n}\n\n// (54:5) {#each article.tagList as tag}\nfunction create_each_block$1(ctx) {\n\tlet li;\n\tlet t0_value = /*tag*/ ctx[7] + \"\";\n\tlet t0;\n\tlet t1;\n\n\treturn {\n\t\tc() {\n\t\t\tli = element(\"li\");\n\t\t\tt0 = text(t0_value);\n\t\t\tt1 = space();\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tli = claim_element(nodes, \"LI\", { class: true });\n\t\t\tvar li_nodes = children(li);\n\t\t\tt0 = claim_text(li_nodes, t0_value);\n\t\t\tt1 = claim_space(li_nodes);\n\t\t\tli_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(li, \"class\", \"tag-default tag-pill tag-outline\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, li, anchor);\n\t\t\tappend(li, t0);\n\t\t\tappend(li, t1);\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tif (dirty & /*article*/ 1 && t0_value !== (t0_value = /*tag*/ ctx[7] + \"\")) set_data(t0, t0_value);\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(li);\n\t\t}\n\t};\n}\n\nfunction create_fragment$4(ctx) {\n\tlet title_value;\n\tlet t0;\n\tlet div8;\n\tlet div1;\n\tlet div0;\n\tlet h1;\n\tlet t1_value = /*article*/ ctx[0].title + \"\";\n\tlet t1;\n\tlet t2;\n\tlet articlemeta;\n\tlet t3;\n\tlet div7;\n\tlet div4;\n\tlet div3;\n\tlet div2;\n\tlet t4;\n\tlet ul;\n\tlet t5;\n\tlet hr;\n\tlet t6;\n\tlet div5;\n\tlet t7;\n\tlet div6;\n\tlet commentcontainer;\n\tlet current;\n\tdocument.title = title_value = /*article*/ ctx[0].title;\n\n\tarticlemeta = new ArticleMeta({\n\t\t\tprops: {\n\t\t\t\tarticle: /*article*/ ctx[0],\n\t\t\t\tuser: /*$session*/ ctx[4].user\n\t\t\t}\n\t\t});\n\n\tlet each_value = /*article*/ ctx[0].tagList;\n\tlet each_blocks = [];\n\n\tfor (let i = 0; i < each_value.length; i += 1) {\n\t\teach_blocks[i] = create_each_block$1(get_each_context$1(ctx, each_value, i));\n\t}\n\n\tcommentcontainer = new CommentContainer({\n\t\t\tprops: {\n\t\t\t\tslug: /*slug*/ ctx[1],\n\t\t\t\tcomments: /*comments*/ ctx[2],\n\t\t\t\tuser: /*$session*/ ctx[4].user,\n\t\t\t\terrors: /*commentErrors*/ ctx[6]\n\t\t\t}\n\t\t});\n\n\treturn {\n\t\tc() {\n\t\t\tt0 = space();\n\t\t\tdiv8 = element(\"div\");\n\t\t\tdiv1 = element(\"div\");\n\t\t\tdiv0 = element(\"div\");\n\t\t\th1 = element(\"h1\");\n\t\t\tt1 = text(t1_value);\n\t\t\tt2 = space();\n\t\t\tcreate_component(articlemeta.$$.fragment);\n\t\t\tt3 = space();\n\t\t\tdiv7 = element(\"div\");\n\t\t\tdiv4 = element(\"div\");\n\t\t\tdiv3 = element(\"div\");\n\t\t\tdiv2 = element(\"div\");\n\t\t\tt4 = space();\n\t\t\tul = element(\"ul\");\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].c();\n\t\t\t}\n\n\t\t\tt5 = space();\n\t\t\thr = element(\"hr\");\n\t\t\tt6 = space();\n\t\t\tdiv5 = element(\"div\");\n\t\t\tt7 = space();\n\t\t\tdiv6 = element(\"div\");\n\t\t\tcreate_component(commentcontainer.$$.fragment);\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tconst head_nodes = query_selector_all(\"[data-svelte=\\\"svelte-3256wk\\\"]\", document.head);\n\t\t\thead_nodes.forEach(detach);\n\t\t\tt0 = claim_space(nodes);\n\t\t\tdiv8 = claim_element(nodes, \"DIV\", { class: true });\n\t\t\tvar div8_nodes = children(div8);\n\t\t\tdiv1 = claim_element(div8_nodes, \"DIV\", { class: true });\n\t\t\tvar div1_nodes = children(div1);\n\t\t\tdiv0 = claim_element(div1_nodes, \"DIV\", { class: true });\n\t\t\tvar div0_nodes = children(div0);\n\t\t\th1 = claim_element(div0_nodes, \"H1\", {});\n\t\t\tvar h1_nodes = children(h1);\n\t\t\tt1 = claim_text(h1_nodes, t1_value);\n\t\t\th1_nodes.forEach(detach);\n\t\t\tt2 = claim_space(div0_nodes);\n\t\t\tclaim_component(articlemeta.$$.fragment, div0_nodes);\n\t\t\tdiv0_nodes.forEach(detach);\n\t\t\tdiv1_nodes.forEach(detach);\n\t\t\tt3 = claim_space(div8_nodes);\n\t\t\tdiv7 = claim_element(div8_nodes, \"DIV\", { class: true });\n\t\t\tvar div7_nodes = children(div7);\n\t\t\tdiv4 = claim_element(div7_nodes, \"DIV\", { class: true });\n\t\t\tvar div4_nodes = children(div4);\n\t\t\tdiv3 = claim_element(div4_nodes, \"DIV\", { class: true });\n\t\t\tvar div3_nodes = children(div3);\n\t\t\tdiv2 = claim_element(div3_nodes, \"DIV\", {});\n\t\t\tvar div2_nodes = children(div2);\n\t\t\tdiv2_nodes.forEach(detach);\n\t\t\tt4 = claim_space(div3_nodes);\n\t\t\tul = claim_element(div3_nodes, \"UL\", { class: true });\n\t\t\tvar ul_nodes = children(ul);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].l(ul_nodes);\n\t\t\t}\n\n\t\t\tul_nodes.forEach(detach);\n\t\t\tdiv3_nodes.forEach(detach);\n\t\t\tdiv4_nodes.forEach(detach);\n\t\t\tt5 = claim_space(div7_nodes);\n\t\t\thr = claim_element(div7_nodes, \"HR\", {});\n\t\t\tt6 = claim_space(div7_nodes);\n\t\t\tdiv5 = claim_element(div7_nodes, \"DIV\", { class: true });\n\t\t\tchildren(div5).forEach(detach);\n\t\t\tt7 = claim_space(div7_nodes);\n\t\t\tdiv6 = claim_element(div7_nodes, \"DIV\", { class: true });\n\t\t\tvar div6_nodes = children(div6);\n\t\t\tclaim_component(commentcontainer.$$.fragment, div6_nodes);\n\t\t\tdiv6_nodes.forEach(detach);\n\t\t\tdiv7_nodes.forEach(detach);\n\t\t\tdiv8_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(div0, \"class\", \"container\");\n\t\t\tattr(div1, \"class\", \"banner\");\n\t\t\tattr(ul, \"class\", \"tag-list\");\n\t\t\tattr(div3, \"class\", \"col-xs-12\");\n\t\t\tattr(div4, \"class\", \"row article-content\");\n\t\t\tattr(div5, \"class\", \"article-actions\");\n\t\t\tattr(div6, \"class\", \"row\");\n\t\t\tattr(div7, \"class\", \"container page\");\n\t\t\tattr(div8, \"class\", \"article-page\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, t0, anchor);\n\t\t\tinsert(target, div8, anchor);\n\t\t\tappend(div8, div1);\n\t\t\tappend(div1, div0);\n\t\t\tappend(div0, h1);\n\t\t\tappend(h1, t1);\n\t\t\tappend(div0, t2);\n\t\t\tmount_component(articlemeta, div0, null);\n\t\t\tappend(div8, t3);\n\t\t\tappend(div8, div7);\n\t\t\tappend(div7, div4);\n\t\t\tappend(div4, div3);\n\t\t\tappend(div3, div2);\n\t\t\tdiv2.innerHTML = /*markup*/ ctx[3];\n\t\t\tappend(div3, t4);\n\t\t\tappend(div3, ul);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].m(ul, null);\n\t\t\t}\n\n\t\t\tappend(div7, t5);\n\t\t\tappend(div7, hr);\n\t\t\tappend(div7, t6);\n\t\t\tappend(div7, div5);\n\t\t\tappend(div7, t7);\n\t\t\tappend(div7, div6);\n\t\t\tmount_component(commentcontainer, div6, null);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tif ((!current || dirty & /*article*/ 1) && title_value !== (title_value = /*article*/ ctx[0].title)) {\n\t\t\t\tdocument.title = title_value;\n\t\t\t}\n\n\t\t\tif ((!current || dirty & /*article*/ 1) && t1_value !== (t1_value = /*article*/ ctx[0].title + \"\")) set_data(t1, t1_value);\n\t\t\tconst articlemeta_changes = {};\n\t\t\tif (dirty & /*article*/ 1) articlemeta_changes.article = /*article*/ ctx[0];\n\t\t\tif (dirty & /*$session*/ 16) articlemeta_changes.user = /*$session*/ ctx[4].user;\n\t\t\tarticlemeta.$set(articlemeta_changes);\n\t\t\tif (!current || dirty & /*markup*/ 8) div2.innerHTML = /*markup*/ ctx[3];\n\t\t\tif (dirty & /*article*/ 1) {\n\t\t\t\teach_value = /*article*/ ctx[0].tagList;\n\t\t\t\tlet i;\n\n\t\t\t\tfor (i = 0; i < each_value.length; i += 1) {\n\t\t\t\t\tconst child_ctx = get_each_context$1(ctx, each_value, i);\n\n\t\t\t\t\tif (each_blocks[i]) {\n\t\t\t\t\t\teach_blocks[i].p(child_ctx, dirty);\n\t\t\t\t\t} else {\n\t\t\t\t\t\teach_blocks[i] = create_each_block$1(child_ctx);\n\t\t\t\t\t\teach_blocks[i].c();\n\t\t\t\t\t\teach_blocks[i].m(ul, null);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor (; i < each_blocks.length; i += 1) {\n\t\t\t\t\teach_blocks[i].d(1);\n\t\t\t\t}\n\n\t\t\t\teach_blocks.length = each_value.length;\n\t\t\t}\n\n\t\t\tconst commentcontainer_changes = {};\n\t\t\tif (dirty & /*slug*/ 2) commentcontainer_changes.slug = /*slug*/ ctx[1];\n\t\t\tif (dirty & /*comments*/ 4) commentcontainer_changes.comments = /*comments*/ ctx[2];\n\t\t\tif (dirty & /*$session*/ 16) commentcontainer_changes.user = /*$session*/ ctx[4].user;\n\t\t\tcommentcontainer.$set(commentcontainer_changes);\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(articlemeta.$$.fragment, local);\n\t\t\ttransition_in(commentcontainer.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(articlemeta.$$.fragment, local);\n\t\t\ttransition_out(commentcontainer.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(t0);\n\t\t\tif (detaching) detach(div8);\n\t\t\tdestroy_component(articlemeta);\n\t\t\tdestroy_each(each_blocks, detaching);\n\t\t\tdestroy_component(commentcontainer);\n\t\t}\n\t};\n}\n\nasync function preload({ params }) {\n\tconst { slug } = params;\n\tconst { article } = await get(`articles/${params.slug}`, null);\n\treturn { article, slug };\n}\n\nfunction instance$4($$self, $$props, $$invalidate) {\n\tlet $session;\n\tlet { article } = $$props;\n\tlet { slug } = $$props;\n\tconst { session } = stores$1();\n\tcomponent_subscribe($$self, session, value => $$invalidate(4, $session = value));\n\tlet commentErrors, comments = []; // we'll lazy-load these in onMount\n\n\tonMount(() => {\n\t\tget(`articles/${slug}/comments`).then(res => {\n\t\t\t$$invalidate(2, comments = res.comments);\n\t\t});\n\t});\n\n\t$$self.$set = $$props => {\n\t\tif (\"article\" in $$props) $$invalidate(0, article = $$props.article);\n\t\tif (\"slug\" in $$props) $$invalidate(1, slug = $$props.slug);\n\t};\n\n\tlet markup;\n\n\t$$self.$$.update = () => {\n\t\tif ($$self.$$.dirty & /*article*/ 1) {\n\t\t\t $$invalidate(3, markup = marked(article.body));\n\t\t}\n\t};\n\n\treturn [article, slug, comments, markup, $session, session, commentErrors];\n}\n\nclass U5Bslugu5D extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance$4, create_fragment$4, safe_not_equal, { article: 0, slug: 1 });\n\t}\n}\n\nexport default U5Bslugu5D;\nexport { preload };\n",
      "dynamicImports":[

      ],
      "exports":[
         "default",
         "preload"
      ],
      "facadeModuleId":"/home/bmccann/src/svelte-realworld/src/routes/article/[slug].svelte",
      "fileName":"[slug].52def5ad.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[
         "client.9f4f62db.js",
         "api.5c9dd840.js",
         "ListErrors.ab5b20bd.js"
      ],
      "isDynamicEntry":true,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "\u0000commonjsHelpers.js":{
            "originalLength":858,
            "removedExports":[
               "commonjsGlobal",
               "unwrapExports",
               "getCjsExportFromNamespace"
            ],
            "renderedExports":[
               "createCommonjsModule",
               "commonjsRequire"
            ],
            "renderedLength":419
         },
         "/home/bmccann/src/svelte-realworld/node_modules/marked/lib/marked.js":{
            "originalLength":42415,
            "removedExports":[

            ],
            "renderedExports":[
               "default",
               "__moduleExports"
            ],
            "renderedLength":42071
         },
         "/home/bmccann/src/svelte-realworld/src/routes/article/_ArticleMeta.svelte":{
            "originalLength":961,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":6587
         },
         "/home/bmccann/src/svelte-realworld/src/routes/article/_CommentInput.svelte":{
            "originalLength":814,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":3888
         },
         "/home/bmccann/src/svelte-realworld/src/routes/article/_Comment.svelte":{
            "originalLength":998,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":6384
         },
         "/home/bmccann/src/svelte-realworld/src/routes/article/_CommentContainer.svelte":{
            "originalLength":763,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":8737
         },
         "/home/bmccann/src/svelte-realworld/src/routes/article/[slug].svelte":{
            "originalLength":1486,
            "removedExports":[

            ],
            "renderedExports":[
               "default",
               "preload"
            ],
            "renderedLength":8875
         }
      },
      "name":"[slug]",
      "type":"chunk"
   },
   {
      "code":"import { S as SvelteComponent, i as init, s as safe_not_equal } from './client.9f4f62db.js';\n\n/* src/routes/profile/index.svelte generated by Svelte v3.23.2 */\n\nfunction preload({ params }, { user }) {\n\tif (user) {\n\t\tthis.redirect(302, `/profile/@${user.username}`);\n\t} else {\n\t\tthis.redirect(302, `/`);\n\t}\n}\n\nclass Profile extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, null, null, safe_not_equal, {});\n\t}\n}\n\nexport default Profile;\nexport { preload };\n",
      "dynamicImports":[

      ],
      "exports":[
         "default",
         "preload"
      ],
      "facadeModuleId":"/home/bmccann/src/svelte-realworld/src/routes/profile/index.svelte",
      "fileName":"index.c18e65a8.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[
         "client.9f4f62db.js"
      ],
      "isDynamicEntry":true,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/src/routes/profile/index.svelte":{
            "originalLength":198,
            "removedExports":[

            ],
            "renderedExports":[
               "default",
               "preload"
            ],
            "renderedLength":350
         }
      },
      "name":"index",
      "type":"chunk"
   },
   {
      "code":"import { S as SvelteComponent, i as init, s as safe_not_equal, f as space, c as create_component, D as query_selector_all, k as detach, l as claim_space, a as claim_component, q as insert, m as mount_component, t as transition_in, b as transition_out, d as destroy_component, w as stores$1, x as component_subscribe } from './client.9f4f62db.js';\nimport { g as get } from './api.5c9dd840.js';\nimport './index.dccd3ebe.js';\nimport { P as Profile } from './_Profile.0512f37a.js';\n\n/* src/routes/profile/[user]/index.svelte generated by Svelte v3.23.2 */\n\nfunction create_fragment(ctx) {\n\tlet title_value;\n\tlet t;\n\tlet profile_1;\n\tlet current;\n\tdocument.title = title_value = \"\" + (/*profile*/ ctx[0].username + \" • Conduit\");\n\n\tprofile_1 = new Profile({\n\t\t\tprops: {\n\t\t\t\tprofile: /*profile*/ ctx[0],\n\t\t\t\tfavorites: /*favorites*/ ctx[1],\n\t\t\t\tuser: /*$session*/ ctx[2].user\n\t\t\t}\n\t\t});\n\n\treturn {\n\t\tc() {\n\t\t\tt = space();\n\t\t\tcreate_component(profile_1.$$.fragment);\n\t\t},\n\t\tl(nodes) {\n\t\t\tconst head_nodes = query_selector_all(\"[data-svelte=\\\"svelte-1f42o3r\\\"]\", document.head);\n\t\t\thead_nodes.forEach(detach);\n\t\t\tt = claim_space(nodes);\n\t\t\tclaim_component(profile_1.$$.fragment, nodes);\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, t, anchor);\n\t\t\tmount_component(profile_1, target, anchor);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tif ((!current || dirty & /*profile*/ 1) && title_value !== (title_value = \"\" + (/*profile*/ ctx[0].username + \" • Conduit\"))) {\n\t\t\t\tdocument.title = title_value;\n\t\t\t}\n\n\t\t\tconst profile_1_changes = {};\n\t\t\tif (dirty & /*profile*/ 1) profile_1_changes.profile = /*profile*/ ctx[0];\n\t\t\tif (dirty & /*favorites*/ 2) profile_1_changes.favorites = /*favorites*/ ctx[1];\n\t\t\tif (dirty & /*$session*/ 4) profile_1_changes.user = /*$session*/ ctx[2].user;\n\t\t\tprofile_1.$set(profile_1_changes);\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(profile_1.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(profile_1.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(t);\n\t\t\tdestroy_component(profile_1, detaching);\n\t\t}\n\t};\n}\n\nasync function preload({ params }, { user }) {\n\tconst username = params.user.slice(1);\n\tconst { profile } = await get(`profiles/${username}`, user && user.token);\n\n\treturn {\n\t\tprofile,\n\t\tfavorites: params.view === \"favorites\"\n\t};\n}\n\nfunction instance($$self, $$props, $$invalidate) {\n\tlet $session;\n\tlet { profile } = $$props;\n\tlet { favorites } = $$props;\n\tconst { session } = stores$1();\n\tcomponent_subscribe($$self, session, value => $$invalidate(2, $session = value));\n\n\t$$self.$set = $$props => {\n\t\tif (\"profile\" in $$props) $$invalidate(0, profile = $$props.profile);\n\t\tif (\"favorites\" in $$props) $$invalidate(1, favorites = $$props.favorites);\n\t};\n\n\treturn [profile, favorites, $session, session];\n}\n\nclass U5Buseru5D extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance, create_fragment, safe_not_equal, { profile: 0, favorites: 1 });\n\t}\n}\n\nexport default U5Buseru5D;\nexport { preload };\n",
      "dynamicImports":[

      ],
      "exports":[
         "default",
         "preload"
      ],
      "facadeModuleId":"/home/bmccann/src/svelte-realworld/src/routes/profile/[user]/index.svelte",
      "fileName":"index.18706821.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[
         "client.9f4f62db.js",
         "api.5c9dd840.js",
         "index.dccd3ebe.js",
         "_Profile.0512f37a.js"
      ],
      "isDynamicEntry":true,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/src/routes/profile/[user]/index.svelte":{
            "originalLength":619,
            "removedExports":[

            ],
            "renderedExports":[
               "default",
               "preload"
            ],
            "renderedLength":2522
         }
      },
      "name":"index",
      "type":"chunk"
   },
   {
      "code":"import { S as SvelteComponent, i as init, s as safe_not_equal, f as space, e as element, g as text, c as create_component, D as query_selector_all, k as detach, l as claim_space, h as claim_element, j as children, o as claim_text, a as claim_component, p as attr, q as insert, r as append, m as mount_component, v as set_data, t as transition_in, b as transition_out, d as destroy_component, O as goto, u as listen, n as noop } from './client.9f4f62db.js';\nimport { p as post, d as del } from './api.5c9dd840.js';\nimport { A as ArticleList } from './index.dccd3ebe.js';\n\n/* src/routes/profile/[user]/_Profile.svelte generated by Svelte v3.23.2 */\n\nfunction create_else_block(ctx) {\n\tlet button;\n\tlet i;\n\tlet t0;\n\tlet t1_value = (/*profile*/ ctx[0].following ? \"Unfollow\" : \"Follow\") + \"\";\n\tlet t1;\n\tlet t2;\n\tlet t3_value = /*profile*/ ctx[0].username + \"\";\n\tlet t3;\n\tlet button_class_value;\n\tlet mounted;\n\tlet dispose;\n\n\treturn {\n\t\tc() {\n\t\t\tbutton = element(\"button\");\n\t\t\ti = element(\"i\");\n\t\t\tt0 = space();\n\t\t\tt1 = text(t1_value);\n\t\t\tt2 = space();\n\t\t\tt3 = text(t3_value);\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tbutton = claim_element(nodes, \"BUTTON\", { class: true });\n\t\t\tvar button_nodes = children(button);\n\t\t\ti = claim_element(button_nodes, \"I\", { class: true });\n\t\t\tchildren(i).forEach(detach);\n\t\t\tt0 = claim_space(button_nodes);\n\t\t\tt1 = claim_text(button_nodes, t1_value);\n\t\t\tt2 = claim_space(button_nodes);\n\t\t\tt3 = claim_text(button_nodes, t3_value);\n\t\t\tbutton_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(i, \"class\", \"ion-plus-round\");\n\n\t\t\tattr(button, \"class\", button_class_value = \"btn btn-sm action-btn \" + (/*profile*/ ctx[0].following\n\t\t\t? \"btn-secondary\"\n\t\t\t: \"btn-outline-secondary\"));\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, button, anchor);\n\t\t\tappend(button, i);\n\t\t\tappend(button, t0);\n\t\t\tappend(button, t1);\n\t\t\tappend(button, t2);\n\t\t\tappend(button, t3);\n\n\t\t\tif (!mounted) {\n\t\t\t\tdispose = listen(button, \"click\", /*toggleFollowing*/ ctx[3]);\n\t\t\t\tmounted = true;\n\t\t\t}\n\t\t},\n\t\tp(ctx, dirty) {\n\t\t\tif (dirty & /*profile*/ 1 && t1_value !== (t1_value = (/*profile*/ ctx[0].following ? \"Unfollow\" : \"Follow\") + \"\")) set_data(t1, t1_value);\n\t\t\tif (dirty & /*profile*/ 1 && t3_value !== (t3_value = /*profile*/ ctx[0].username + \"\")) set_data(t3, t3_value);\n\n\t\t\tif (dirty & /*profile*/ 1 && button_class_value !== (button_class_value = \"btn btn-sm action-btn \" + (/*profile*/ ctx[0].following\n\t\t\t? \"btn-secondary\"\n\t\t\t: \"btn-outline-secondary\"))) {\n\t\t\t\tattr(button, \"class\", button_class_value);\n\t\t\t}\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(button);\n\t\t\tmounted = false;\n\t\t\tdispose();\n\t\t}\n\t};\n}\n\n// (37:5) {#if isUser}\nfunction create_if_block(ctx) {\n\tlet a;\n\tlet i;\n\tlet t;\n\n\treturn {\n\t\tc() {\n\t\t\ta = element(\"a\");\n\t\t\ti = element(\"i\");\n\t\t\tt = text(\" Edit Profile Settings\");\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\ta = claim_element(nodes, \"A\", { href: true, class: true });\n\t\t\tvar a_nodes = children(a);\n\t\t\ti = claim_element(a_nodes, \"I\", { class: true });\n\t\t\tchildren(i).forEach(detach);\n\t\t\tt = claim_text(a_nodes, \" Edit Profile Settings\");\n\t\t\ta_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(i, \"class\", \"ion-gear-a\");\n\t\t\tattr(a, \"href\", \"/settings\");\n\t\t\tattr(a, \"class\", \"btn btn-sm btn-outline-secondary action-btn\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, a, anchor);\n\t\t\tappend(a, i);\n\t\t\tappend(a, t);\n\t\t},\n\t\tp: noop,\n\t\td(detaching) {\n\t\t\tif (detaching) detach(a);\n\t\t}\n\t};\n}\n\nfunction create_fragment(ctx) {\n\tlet title_value;\n\tlet t0;\n\tlet div8;\n\tlet div3;\n\tlet div2;\n\tlet div1;\n\tlet div0;\n\tlet img;\n\tlet img_src_value;\n\tlet img_alt_value;\n\tlet t1;\n\tlet h4;\n\tlet t2_value = /*profile*/ ctx[0].username + \"\";\n\tlet t2;\n\tlet t3;\n\tlet p;\n\tlet t4_value = /*profile*/ ctx[0].bio + \"\";\n\tlet t4;\n\tlet t5;\n\tlet t6;\n\tlet div7;\n\tlet div6;\n\tlet div5;\n\tlet div4;\n\tlet ul;\n\tlet li0;\n\tlet a0;\n\tlet t7;\n\tlet a0_href_value;\n\tlet a0_class_value;\n\tlet t8;\n\tlet li1;\n\tlet a1;\n\tlet t9;\n\tlet a1_class_value;\n\tlet a1_href_value;\n\tlet t10;\n\tlet articlelist;\n\tlet current;\n\tdocument.title = title_value = \"\" + (/*profile*/ ctx[0].username + \" • Conduit\");\n\n\tfunction select_block_type(ctx, dirty) {\n\t\tif (/*isUser*/ ctx[2]) return create_if_block;\n\t\treturn create_else_block;\n\t}\n\n\tlet current_block_type = select_block_type(ctx);\n\tlet if_block = current_block_type(ctx);\n\n\tarticlelist = new ArticleList({\n\t\t\tprops: {\n\t\t\t\ttab: \"profile\",\n\t\t\t\tusername: /*profile*/ ctx[0].username,\n\t\t\t\tfavorites: /*favorites*/ ctx[1]\n\t\t\t}\n\t\t});\n\n\treturn {\n\t\tc() {\n\t\t\tt0 = space();\n\t\t\tdiv8 = element(\"div\");\n\t\t\tdiv3 = element(\"div\");\n\t\t\tdiv2 = element(\"div\");\n\t\t\tdiv1 = element(\"div\");\n\t\t\tdiv0 = element(\"div\");\n\t\t\timg = element(\"img\");\n\t\t\tt1 = space();\n\t\t\th4 = element(\"h4\");\n\t\t\tt2 = text(t2_value);\n\t\t\tt3 = space();\n\t\t\tp = element(\"p\");\n\t\t\tt4 = text(t4_value);\n\t\t\tt5 = space();\n\t\t\tif_block.c();\n\t\t\tt6 = space();\n\t\t\tdiv7 = element(\"div\");\n\t\t\tdiv6 = element(\"div\");\n\t\t\tdiv5 = element(\"div\");\n\t\t\tdiv4 = element(\"div\");\n\t\t\tul = element(\"ul\");\n\t\t\tli0 = element(\"li\");\n\t\t\ta0 = element(\"a\");\n\t\t\tt7 = text(\"My Articles\");\n\t\t\tt8 = space();\n\t\t\tli1 = element(\"li\");\n\t\t\ta1 = element(\"a\");\n\t\t\tt9 = text(\"Favorited Articles\");\n\t\t\tt10 = space();\n\t\t\tcreate_component(articlelist.$$.fragment);\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tconst head_nodes = query_selector_all(\"[data-svelte=\\\"svelte-1f42o3r\\\"]\", document.head);\n\t\t\thead_nodes.forEach(detach);\n\t\t\tt0 = claim_space(nodes);\n\t\t\tdiv8 = claim_element(nodes, \"DIV\", { class: true });\n\t\t\tvar div8_nodes = children(div8);\n\t\t\tdiv3 = claim_element(div8_nodes, \"DIV\", { class: true });\n\t\t\tvar div3_nodes = children(div3);\n\t\t\tdiv2 = claim_element(div3_nodes, \"DIV\", { class: true });\n\t\t\tvar div2_nodes = children(div2);\n\t\t\tdiv1 = claim_element(div2_nodes, \"DIV\", { class: true });\n\t\t\tvar div1_nodes = children(div1);\n\t\t\tdiv0 = claim_element(div1_nodes, \"DIV\", { class: true });\n\t\t\tvar div0_nodes = children(div0);\n\t\t\timg = claim_element(div0_nodes, \"IMG\", { src: true, class: true, alt: true });\n\t\t\tt1 = claim_space(div0_nodes);\n\t\t\th4 = claim_element(div0_nodes, \"H4\", {});\n\t\t\tvar h4_nodes = children(h4);\n\t\t\tt2 = claim_text(h4_nodes, t2_value);\n\t\t\th4_nodes.forEach(detach);\n\t\t\tt3 = claim_space(div0_nodes);\n\t\t\tp = claim_element(div0_nodes, \"P\", {});\n\t\t\tvar p_nodes = children(p);\n\t\t\tt4 = claim_text(p_nodes, t4_value);\n\t\t\tp_nodes.forEach(detach);\n\t\t\tt5 = claim_space(div0_nodes);\n\t\t\tif_block.l(div0_nodes);\n\t\t\tdiv0_nodes.forEach(detach);\n\t\t\tdiv1_nodes.forEach(detach);\n\t\t\tdiv2_nodes.forEach(detach);\n\t\t\tdiv3_nodes.forEach(detach);\n\t\t\tt6 = claim_space(div8_nodes);\n\t\t\tdiv7 = claim_element(div8_nodes, \"DIV\", { class: true });\n\t\t\tvar div7_nodes = children(div7);\n\t\t\tdiv6 = claim_element(div7_nodes, \"DIV\", { class: true });\n\t\t\tvar div6_nodes = children(div6);\n\t\t\tdiv5 = claim_element(div6_nodes, \"DIV\", { class: true });\n\t\t\tvar div5_nodes = children(div5);\n\t\t\tdiv4 = claim_element(div5_nodes, \"DIV\", { class: true });\n\t\t\tvar div4_nodes = children(div4);\n\t\t\tul = claim_element(div4_nodes, \"UL\", { class: true });\n\t\t\tvar ul_nodes = children(ul);\n\t\t\tli0 = claim_element(ul_nodes, \"LI\", { class: true });\n\t\t\tvar li0_nodes = children(li0);\n\t\t\ta0 = claim_element(li0_nodes, \"A\", { href: true, class: true });\n\t\t\tvar a0_nodes = children(a0);\n\t\t\tt7 = claim_text(a0_nodes, \"My Articles\");\n\t\t\ta0_nodes.forEach(detach);\n\t\t\tli0_nodes.forEach(detach);\n\t\t\tt8 = claim_space(ul_nodes);\n\t\t\tli1 = claim_element(ul_nodes, \"LI\", { class: true });\n\t\t\tvar li1_nodes = children(li1);\n\t\t\ta1 = claim_element(li1_nodes, \"A\", { class: true, href: true });\n\t\t\tvar a1_nodes = children(a1);\n\t\t\tt9 = claim_text(a1_nodes, \"Favorited Articles\");\n\t\t\ta1_nodes.forEach(detach);\n\t\t\tli1_nodes.forEach(detach);\n\t\t\tul_nodes.forEach(detach);\n\t\t\tdiv4_nodes.forEach(detach);\n\t\t\tt10 = claim_space(div5_nodes);\n\t\t\tclaim_component(articlelist.$$.fragment, div5_nodes);\n\t\t\tdiv5_nodes.forEach(detach);\n\t\t\tdiv6_nodes.forEach(detach);\n\t\t\tdiv7_nodes.forEach(detach);\n\t\t\tdiv8_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tif (img.src !== (img_src_value = /*profile*/ ctx[0].image)) attr(img, \"src\", img_src_value);\n\t\t\tattr(img, \"class\", \"user-img\");\n\t\t\tattr(img, \"alt\", img_alt_value = /*profile*/ ctx[0].username);\n\t\t\tattr(div0, \"class\", \"col-xs-12 col-md-10 offset-md-1\");\n\t\t\tattr(div1, \"class\", \"row\");\n\t\t\tattr(div2, \"class\", \"container\");\n\t\t\tattr(div3, \"class\", \"user-info\");\n\t\t\tattr(a0, \"href\", a0_href_value = \"/profile/@\" + /*profile*/ ctx[0].username);\n\t\t\tattr(a0, \"class\", a0_class_value = \"nav-link \" + (/*favorites*/ ctx[1] ? \"\" : \"active\"));\n\t\t\tattr(li0, \"class\", \"nav-item\");\n\t\t\tattr(a1, \"class\", a1_class_value = \"nav-link \" + (/*favorites*/ ctx[1] ? \"active\" : \"\"));\n\t\t\tattr(a1, \"href\", a1_href_value = \"/profile/@\" + /*profile*/ ctx[0].username + \"/favorites\");\n\t\t\tattr(li1, \"class\", \"nav-item\");\n\t\t\tattr(ul, \"class\", \"nav nav-pills outline-active\");\n\t\t\tattr(div4, \"class\", \"articles-toggle\");\n\t\t\tattr(div5, \"class\", \"col-xs-12 col-md-10 offset-md-1\");\n\t\t\tattr(div6, \"class\", \"row\");\n\t\t\tattr(div7, \"class\", \"container\");\n\t\t\tattr(div8, \"class\", \"profile-page\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, t0, anchor);\n\t\t\tinsert(target, div8, anchor);\n\t\t\tappend(div8, div3);\n\t\t\tappend(div3, div2);\n\t\t\tappend(div2, div1);\n\t\t\tappend(div1, div0);\n\t\t\tappend(div0, img);\n\t\t\tappend(div0, t1);\n\t\t\tappend(div0, h4);\n\t\t\tappend(h4, t2);\n\t\t\tappend(div0, t3);\n\t\t\tappend(div0, p);\n\t\t\tappend(p, t4);\n\t\t\tappend(div0, t5);\n\t\t\tif_block.m(div0, null);\n\t\t\tappend(div8, t6);\n\t\t\tappend(div8, div7);\n\t\t\tappend(div7, div6);\n\t\t\tappend(div6, div5);\n\t\t\tappend(div5, div4);\n\t\t\tappend(div4, ul);\n\t\t\tappend(ul, li0);\n\t\t\tappend(li0, a0);\n\t\t\tappend(a0, t7);\n\t\t\tappend(ul, t8);\n\t\t\tappend(ul, li1);\n\t\t\tappend(li1, a1);\n\t\t\tappend(a1, t9);\n\t\t\tappend(div5, t10);\n\t\t\tmount_component(articlelist, div5, null);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tif ((!current || dirty & /*profile*/ 1) && title_value !== (title_value = \"\" + (/*profile*/ ctx[0].username + \" • Conduit\"))) {\n\t\t\t\tdocument.title = title_value;\n\t\t\t}\n\n\t\t\tif (!current || dirty & /*profile*/ 1 && img.src !== (img_src_value = /*profile*/ ctx[0].image)) {\n\t\t\t\tattr(img, \"src\", img_src_value);\n\t\t\t}\n\n\t\t\tif (!current || dirty & /*profile*/ 1 && img_alt_value !== (img_alt_value = /*profile*/ ctx[0].username)) {\n\t\t\t\tattr(img, \"alt\", img_alt_value);\n\t\t\t}\n\n\t\t\tif ((!current || dirty & /*profile*/ 1) && t2_value !== (t2_value = /*profile*/ ctx[0].username + \"\")) set_data(t2, t2_value);\n\t\t\tif ((!current || dirty & /*profile*/ 1) && t4_value !== (t4_value = /*profile*/ ctx[0].bio + \"\")) set_data(t4, t4_value);\n\n\t\t\tif (current_block_type === (current_block_type = select_block_type(ctx)) && if_block) {\n\t\t\t\tif_block.p(ctx, dirty);\n\t\t\t} else {\n\t\t\t\tif_block.d(1);\n\t\t\t\tif_block = current_block_type(ctx);\n\n\t\t\t\tif (if_block) {\n\t\t\t\t\tif_block.c();\n\t\t\t\t\tif_block.m(div0, null);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (!current || dirty & /*profile*/ 1 && a0_href_value !== (a0_href_value = \"/profile/@\" + /*profile*/ ctx[0].username)) {\n\t\t\t\tattr(a0, \"href\", a0_href_value);\n\t\t\t}\n\n\t\t\tif (!current || dirty & /*favorites*/ 2 && a0_class_value !== (a0_class_value = \"nav-link \" + (/*favorites*/ ctx[1] ? \"\" : \"active\"))) {\n\t\t\t\tattr(a0, \"class\", a0_class_value);\n\t\t\t}\n\n\t\t\tif (!current || dirty & /*favorites*/ 2 && a1_class_value !== (a1_class_value = \"nav-link \" + (/*favorites*/ ctx[1] ? \"active\" : \"\"))) {\n\t\t\t\tattr(a1, \"class\", a1_class_value);\n\t\t\t}\n\n\t\t\tif (!current || dirty & /*profile*/ 1 && a1_href_value !== (a1_href_value = \"/profile/@\" + /*profile*/ ctx[0].username + \"/favorites\")) {\n\t\t\t\tattr(a1, \"href\", a1_href_value);\n\t\t\t}\n\n\t\t\tconst articlelist_changes = {};\n\t\t\tif (dirty & /*profile*/ 1) articlelist_changes.username = /*profile*/ ctx[0].username;\n\t\t\tif (dirty & /*favorites*/ 2) articlelist_changes.favorites = /*favorites*/ ctx[1];\n\t\t\tarticlelist.$set(articlelist_changes);\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(articlelist.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(articlelist.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(t0);\n\t\t\tif (detaching) detach(div8);\n\t\t\tif_block.d();\n\t\t\tdestroy_component(articlelist);\n\t\t}\n\t};\n}\n\nfunction instance($$self, $$props, $$invalidate) {\n\tlet { profile } = $$props;\n\tlet { favorites } = $$props;\n\tlet { user } = $$props;\n\n\tasync function toggleFollowing() {\n\t\tif (!user) return goto(\"/login\");\n\n\t\t// optimistic UI\n\t\t$$invalidate(0, profile.following = !profile.following, profile);\n\n\t\t$$invalidate(\n\t\t\t0,\n\t\t\t{ profile, favorites } = await (profile.following\n\t\t\t? post(`profiles/${profile.username}/follow`, null, user && user.token)\n\t\t\t: del(`profiles/${profile.username}/follow`, user && user.token)),\n\t\t\tprofile,\n\t\t\t$$invalidate(1, favorites)\n\t\t);\n\t}\n\n\t$$self.$set = $$props => {\n\t\tif (\"profile\" in $$props) $$invalidate(0, profile = $$props.profile);\n\t\tif (\"favorites\" in $$props) $$invalidate(1, favorites = $$props.favorites);\n\t\tif (\"user\" in $$props) $$invalidate(4, user = $$props.user);\n\t};\n\n\tlet isUser;\n\n\t$$self.$$.update = () => {\n\t\tif ($$self.$$.dirty & /*user, profile*/ 17) {\n\t\t\t $$invalidate(2, isUser = user && profile.username === user.username);\n\t\t}\n\t};\n\n\treturn [profile, favorites, isUser, toggleFollowing, user];\n}\n\nclass Profile extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance, create_fragment, safe_not_equal, { profile: 0, favorites: 1, user: 4 });\n\t}\n}\n\nexport { Profile as P };\n",
      "dynamicImports":[

      ],
      "exports":[
         "P"
      ],
      "facadeModuleId":null,
      "fileName":"_Profile.0512f37a.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[
         "client.9f4f62db.js",
         "api.5c9dd840.js",
         "index.dccd3ebe.js"
      ],
      "isDynamicEntry":false,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/src/routes/profile/[user]/_Profile.svelte":{
            "originalLength":2114,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":12692
         }
      },
      "name":"_Profile",
      "type":"chunk"
   },
   {
      "code":"import { S as SvelteComponent, i as init, s as safe_not_equal, f as space, c as create_component, D as query_selector_all, k as detach, l as claim_space, a as claim_component, q as insert, m as mount_component, t as transition_in, b as transition_out, d as destroy_component, w as stores$1, x as component_subscribe } from './client.9f4f62db.js';\nimport { g as get } from './api.5c9dd840.js';\nimport './index.dccd3ebe.js';\nimport { P as Profile } from './_Profile.0512f37a.js';\n\n/* src/routes/profile/[user]/[view].svelte generated by Svelte v3.23.2 */\n\nfunction create_fragment(ctx) {\n\tlet title_value;\n\tlet t;\n\tlet profile_1;\n\tlet current;\n\tdocument.title = title_value = \"\" + (/*profile*/ ctx[0].username + \" • Conduit\");\n\n\tprofile_1 = new Profile({\n\t\t\tprops: {\n\t\t\t\tprofile: /*profile*/ ctx[0],\n\t\t\t\tfavorites: /*favorites*/ ctx[1],\n\t\t\t\tuser: /*$session*/ ctx[2].user\n\t\t\t}\n\t\t});\n\n\treturn {\n\t\tc() {\n\t\t\tt = space();\n\t\t\tcreate_component(profile_1.$$.fragment);\n\t\t},\n\t\tl(nodes) {\n\t\t\tconst head_nodes = query_selector_all(\"[data-svelte=\\\"svelte-1f42o3r\\\"]\", document.head);\n\t\t\thead_nodes.forEach(detach);\n\t\t\tt = claim_space(nodes);\n\t\t\tclaim_component(profile_1.$$.fragment, nodes);\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, t, anchor);\n\t\t\tmount_component(profile_1, target, anchor);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tif ((!current || dirty & /*profile*/ 1) && title_value !== (title_value = \"\" + (/*profile*/ ctx[0].username + \" • Conduit\"))) {\n\t\t\t\tdocument.title = title_value;\n\t\t\t}\n\n\t\t\tconst profile_1_changes = {};\n\t\t\tif (dirty & /*profile*/ 1) profile_1_changes.profile = /*profile*/ ctx[0];\n\t\t\tif (dirty & /*favorites*/ 2) profile_1_changes.favorites = /*favorites*/ ctx[1];\n\t\t\tif (dirty & /*$session*/ 4) profile_1_changes.user = /*$session*/ ctx[2].user;\n\t\t\tprofile_1.$set(profile_1_changes);\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(profile_1.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(profile_1.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(t);\n\t\t\tdestroy_component(profile_1, detaching);\n\t\t}\n\t};\n}\n\nasync function preload({ params }, { user }) {\n\tconst username = params.user.slice(1);\n\tconst { profile } = await get(`profiles/${username}`, user && user.token);\n\n\treturn {\n\t\tprofile,\n\t\tfavorites: params.view === \"favorites\"\n\t};\n}\n\nfunction instance($$self, $$props, $$invalidate) {\n\tlet $session;\n\tlet { profile } = $$props, { favorites } = $$props;\n\tconst { session } = stores$1();\n\tcomponent_subscribe($$self, session, value => $$invalidate(2, $session = value));\n\n\t$$self.$set = $$props => {\n\t\tif (\"profile\" in $$props) $$invalidate(0, profile = $$props.profile);\n\t\tif (\"favorites\" in $$props) $$invalidate(1, favorites = $$props.favorites);\n\t};\n\n\treturn [profile, favorites, $session, session];\n}\n\nclass U5Bviewu5D extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance, create_fragment, safe_not_equal, { profile: 0, favorites: 1 });\n\t}\n}\n\nexport default U5Bviewu5D;\nexport { preload };\n",
      "dynamicImports":[

      ],
      "exports":[
         "default",
         "preload"
      ],
      "facadeModuleId":"/home/bmccann/src/svelte-realworld/src/routes/profile/[user]/[view].svelte",
      "fileName":"[view].fb1d7ebc.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[
         "client.9f4f62db.js",
         "api.5c9dd840.js",
         "index.dccd3ebe.js",
         "_Profile.0512f37a.js"
      ],
      "isDynamicEntry":true,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/src/routes/profile/[user]/[view].svelte":{
            "originalLength":612,
            "removedExports":[

            ],
            "renderedExports":[
               "default",
               "preload"
            ],
            "renderedLength":2518
         }
      },
      "name":"[view]",
      "type":"chunk"
   },
   {
      "code":"import { S as SvelteComponent, i as init, s as safe_not_equal, c as create_component, a as claim_component, m as mount_component, n as noop, t as transition_in, b as transition_out, d as destroy_component } from './client.9f4f62db.js';\nimport './api.5c9dd840.js';\nimport './ListErrors.ab5b20bd.js';\nimport { E as Editor } from './_Editor.9d4f6b99.js';\n\n/* src/routes/editor/index.svelte generated by Svelte v3.23.2 */\n\nfunction create_fragment(ctx) {\n\tlet editor;\n\tlet current;\n\teditor = new Editor({ props: { article: /*article*/ ctx[0] } });\n\n\treturn {\n\t\tc() {\n\t\t\tcreate_component(editor.$$.fragment);\n\t\t},\n\t\tl(nodes) {\n\t\t\tclaim_component(editor.$$.fragment, nodes);\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tmount_component(editor, target, anchor);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp: noop,\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(editor.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(editor.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tdestroy_component(editor, detaching);\n\t\t}\n\t};\n}\n\nfunction instance($$self) {\n\tlet article = {\n\t\ttitle: \"\",\n\t\tdescription: \"\",\n\t\tbody: \"\",\n\t\ttagList: []\n\t};\n\n\treturn [article];\n}\n\nclass Editor_1 extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance, create_fragment, safe_not_equal, {});\n\t}\n}\n\nexport default Editor_1;\n",
      "dynamicImports":[

      ],
      "exports":[
         "default"
      ],
      "facadeModuleId":"/home/bmccann/src/svelte-realworld/src/routes/editor/index.svelte",
      "fileName":"index.31aa2bf1.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[
         "client.9f4f62db.js",
         "api.5c9dd840.js",
         "ListErrors.ab5b20bd.js",
         "_Editor.9d4f6b99.js"
      ],
      "isDynamicEntry":true,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/src/routes/editor/index.svelte":{
            "originalLength":149,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":961
         }
      },
      "name":"index",
      "type":"chunk"
   },
   {
      "code":"import { S as SvelteComponent, i as init, s as safe_not_equal, e as element, f as space, g as text, h as claim_element, j as children, k as detach, l as claim_space, o as claim_text, p as attr, q as insert, r as append, u as listen, v as set_data, c as create_component, a as claim_component, m as mount_component, K as set_input_value, T as action_destroyer, t as transition_in, b as transition_out, d as destroy_component, A as destroy_each, M as run_all, w as stores$1, x as component_subscribe, O as goto } from './client.9f4f62db.js';\nimport { a as put, p as post } from './api.5c9dd840.js';\nimport { L as ListErrors } from './ListErrors.ab5b20bd.js';\n\n/* src/routes/editor/_Editor.svelte generated by Svelte v3.23.2 */\n\nfunction get_each_context(ctx, list, i) {\n\tconst child_ctx = ctx.slice();\n\tchild_ctx[13] = list[i];\n\tchild_ctx[15] = i;\n\treturn child_ctx;\n}\n\n// (76:8) {#each article.tagList as tag, i}\nfunction create_each_block(ctx) {\n\tlet span;\n\tlet i_1;\n\tlet t0;\n\tlet t1_value = /*tag*/ ctx[13] + \"\";\n\tlet t1;\n\tlet t2;\n\tlet mounted;\n\tlet dispose;\n\n\tfunction click_handler(...args) {\n\t\treturn /*click_handler*/ ctx[11](/*i*/ ctx[15], ...args);\n\t}\n\n\treturn {\n\t\tc() {\n\t\t\tspan = element(\"span\");\n\t\t\ti_1 = element(\"i\");\n\t\t\tt0 = space();\n\t\t\tt1 = text(t1_value);\n\t\t\tt2 = space();\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tspan = claim_element(nodes, \"SPAN\", { class: true });\n\t\t\tvar span_nodes = children(span);\n\t\t\ti_1 = claim_element(span_nodes, \"I\", { class: true });\n\t\t\tchildren(i_1).forEach(detach);\n\t\t\tt0 = claim_space(span_nodes);\n\t\t\tt1 = claim_text(span_nodes, t1_value);\n\t\t\tt2 = claim_space(span_nodes);\n\t\t\tspan_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(i_1, \"class\", \"ion-close-round\");\n\t\t\tattr(span, \"class\", \"tag-default tag-pill\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, span, anchor);\n\t\t\tappend(span, i_1);\n\t\t\tappend(span, t0);\n\t\t\tappend(span, t1);\n\t\t\tappend(span, t2);\n\n\t\t\tif (!mounted) {\n\t\t\t\tdispose = listen(i_1, \"click\", click_handler);\n\t\t\t\tmounted = true;\n\t\t\t}\n\t\t},\n\t\tp(new_ctx, dirty) {\n\t\t\tctx = new_ctx;\n\t\t\tif (dirty & /*article*/ 1 && t1_value !== (t1_value = /*tag*/ ctx[13] + \"\")) set_data(t1, t1_value);\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(span);\n\t\t\tmounted = false;\n\t\t\tdispose();\n\t\t}\n\t};\n}\n\nfunction create_fragment(ctx) {\n\tlet div4;\n\tlet div3;\n\tlet div2;\n\tlet div1;\n\tlet listerrors;\n\tlet t0;\n\tlet form;\n\tlet fieldset4;\n\tlet fieldset0;\n\tlet input0;\n\tlet t1;\n\tlet fieldset1;\n\tlet input1;\n\tlet t2;\n\tlet fieldset2;\n\tlet textarea;\n\tlet t3;\n\tlet fieldset3;\n\tlet input2;\n\tlet enter_action;\n\tlet t4;\n\tlet div0;\n\tlet t5;\n\tlet button;\n\tlet t6;\n\tlet current;\n\tlet mounted;\n\tlet dispose;\n\tlisterrors = new ListErrors({ props: { errors: /*errors*/ ctx[2] } });\n\tlet each_value = /*article*/ ctx[0].tagList;\n\tlet each_blocks = [];\n\n\tfor (let i = 0; i < each_value.length; i += 1) {\n\t\teach_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));\n\t}\n\n\treturn {\n\t\tc() {\n\t\t\tdiv4 = element(\"div\");\n\t\t\tdiv3 = element(\"div\");\n\t\t\tdiv2 = element(\"div\");\n\t\t\tdiv1 = element(\"div\");\n\t\t\tcreate_component(listerrors.$$.fragment);\n\t\t\tt0 = space();\n\t\t\tform = element(\"form\");\n\t\t\tfieldset4 = element(\"fieldset\");\n\t\t\tfieldset0 = element(\"fieldset\");\n\t\t\tinput0 = element(\"input\");\n\t\t\tt1 = space();\n\t\t\tfieldset1 = element(\"fieldset\");\n\t\t\tinput1 = element(\"input\");\n\t\t\tt2 = space();\n\t\t\tfieldset2 = element(\"fieldset\");\n\t\t\ttextarea = element(\"textarea\");\n\t\t\tt3 = space();\n\t\t\tfieldset3 = element(\"fieldset\");\n\t\t\tinput2 = element(\"input\");\n\t\t\tt4 = space();\n\t\t\tdiv0 = element(\"div\");\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].c();\n\t\t\t}\n\n\t\t\tt5 = space();\n\t\t\tbutton = element(\"button\");\n\t\t\tt6 = text(\"Publish Article\");\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tdiv4 = claim_element(nodes, \"DIV\", { class: true });\n\t\t\tvar div4_nodes = children(div4);\n\t\t\tdiv3 = claim_element(div4_nodes, \"DIV\", { class: true });\n\t\t\tvar div3_nodes = children(div3);\n\t\t\tdiv2 = claim_element(div3_nodes, \"DIV\", { class: true });\n\t\t\tvar div2_nodes = children(div2);\n\t\t\tdiv1 = claim_element(div2_nodes, \"DIV\", { class: true });\n\t\t\tvar div1_nodes = children(div1);\n\t\t\tclaim_component(listerrors.$$.fragment, div1_nodes);\n\t\t\tt0 = claim_space(div1_nodes);\n\t\t\tform = claim_element(div1_nodes, \"FORM\", {});\n\t\t\tvar form_nodes = children(form);\n\t\t\tfieldset4 = claim_element(form_nodes, \"FIELDSET\", {});\n\t\t\tvar fieldset4_nodes = children(fieldset4);\n\t\t\tfieldset0 = claim_element(fieldset4_nodes, \"FIELDSET\", { class: true });\n\t\t\tvar fieldset0_nodes = children(fieldset0);\n\n\t\t\tinput0 = claim_element(fieldset0_nodes, \"INPUT\", {\n\t\t\t\tclass: true,\n\t\t\t\ttype: true,\n\t\t\t\tplaceholder: true\n\t\t\t});\n\n\t\t\tfieldset0_nodes.forEach(detach);\n\t\t\tt1 = claim_space(fieldset4_nodes);\n\t\t\tfieldset1 = claim_element(fieldset4_nodes, \"FIELDSET\", { class: true });\n\t\t\tvar fieldset1_nodes = children(fieldset1);\n\n\t\t\tinput1 = claim_element(fieldset1_nodes, \"INPUT\", {\n\t\t\t\tclass: true,\n\t\t\t\ttype: true,\n\t\t\t\tplaceholder: true\n\t\t\t});\n\n\t\t\tfieldset1_nodes.forEach(detach);\n\t\t\tt2 = claim_space(fieldset4_nodes);\n\t\t\tfieldset2 = claim_element(fieldset4_nodes, \"FIELDSET\", { class: true });\n\t\t\tvar fieldset2_nodes = children(fieldset2);\n\n\t\t\ttextarea = claim_element(fieldset2_nodes, \"TEXTAREA\", {\n\t\t\t\tclass: true,\n\t\t\t\trows: true,\n\t\t\t\tplaceholder: true\n\t\t\t});\n\n\t\t\tchildren(textarea).forEach(detach);\n\t\t\tfieldset2_nodes.forEach(detach);\n\t\t\tt3 = claim_space(fieldset4_nodes);\n\t\t\tfieldset3 = claim_element(fieldset4_nodes, \"FIELDSET\", { class: true });\n\t\t\tvar fieldset3_nodes = children(fieldset3);\n\n\t\t\tinput2 = claim_element(fieldset3_nodes, \"INPUT\", {\n\t\t\t\tclass: true,\n\t\t\t\ttype: true,\n\t\t\t\tplaceholder: true\n\t\t\t});\n\n\t\t\tt4 = claim_space(fieldset3_nodes);\n\t\t\tdiv0 = claim_element(fieldset3_nodes, \"DIV\", { class: true });\n\t\t\tvar div0_nodes = children(div0);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].l(div0_nodes);\n\t\t\t}\n\n\t\t\tdiv0_nodes.forEach(detach);\n\t\t\tfieldset3_nodes.forEach(detach);\n\t\t\tt5 = claim_space(fieldset4_nodes);\n\t\t\tbutton = claim_element(fieldset4_nodes, \"BUTTON\", { class: true, type: true, disabled: true });\n\t\t\tvar button_nodes = children(button);\n\t\t\tt6 = claim_text(button_nodes, \"Publish Article\");\n\t\t\tbutton_nodes.forEach(detach);\n\t\t\tfieldset4_nodes.forEach(detach);\n\t\t\tform_nodes.forEach(detach);\n\t\t\tdiv1_nodes.forEach(detach);\n\t\t\tdiv2_nodes.forEach(detach);\n\t\t\tdiv3_nodes.forEach(detach);\n\t\t\tdiv4_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tattr(input0, \"class\", \"form-control form-control-lg\");\n\t\t\tattr(input0, \"type\", \"text\");\n\t\t\tattr(input0, \"placeholder\", \"Article Title\");\n\t\t\tattr(fieldset0, \"class\", \"form-group\");\n\t\t\tattr(input1, \"class\", \"form-control\");\n\t\t\tattr(input1, \"type\", \"text\");\n\t\t\tattr(input1, \"placeholder\", \"What's this article about?\");\n\t\t\tattr(fieldset1, \"class\", \"form-group\");\n\t\t\tattr(textarea, \"class\", \"form-control\");\n\t\t\tattr(textarea, \"rows\", \"8\");\n\t\t\tattr(textarea, \"placeholder\", \"Write your article (in markdown)\");\n\t\t\tattr(fieldset2, \"class\", \"form-group\");\n\t\t\tattr(input2, \"class\", \"form-control\");\n\t\t\tattr(input2, \"type\", \"text\");\n\t\t\tattr(input2, \"placeholder\", \"Enter tags\");\n\t\t\tattr(div0, \"class\", \"tag-list\");\n\t\t\tattr(fieldset3, \"class\", \"form-group\");\n\t\t\tattr(button, \"class\", \"btn btn-lg pull-xs-right btn-primary\");\n\t\t\tattr(button, \"type\", \"button\");\n\t\t\tbutton.disabled = /*inProgress*/ ctx[1];\n\t\t\tattr(div1, \"class\", \"col-md-10 offset-md-1 col-xs-12\");\n\t\t\tattr(div2, \"class\", \"row\");\n\t\t\tattr(div3, \"class\", \"container page\");\n\t\t\tattr(div4, \"class\", \"editor-page\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, div4, anchor);\n\t\t\tappend(div4, div3);\n\t\t\tappend(div3, div2);\n\t\t\tappend(div2, div1);\n\t\t\tmount_component(listerrors, div1, null);\n\t\t\tappend(div1, t0);\n\t\t\tappend(div1, form);\n\t\t\tappend(form, fieldset4);\n\t\t\tappend(fieldset4, fieldset0);\n\t\t\tappend(fieldset0, input0);\n\t\t\tset_input_value(input0, /*article*/ ctx[0].title);\n\t\t\tappend(fieldset4, t1);\n\t\t\tappend(fieldset4, fieldset1);\n\t\t\tappend(fieldset1, input1);\n\t\t\tset_input_value(input1, /*article*/ ctx[0].description);\n\t\t\tappend(fieldset4, t2);\n\t\t\tappend(fieldset4, fieldset2);\n\t\t\tappend(fieldset2, textarea);\n\t\t\tset_input_value(textarea, /*article*/ ctx[0].body);\n\t\t\tappend(fieldset4, t3);\n\t\t\tappend(fieldset4, fieldset3);\n\t\t\tappend(fieldset3, input2);\n\t\t\tappend(fieldset3, t4);\n\t\t\tappend(fieldset3, div0);\n\n\t\t\tfor (let i = 0; i < each_blocks.length; i += 1) {\n\t\t\t\teach_blocks[i].m(div0, null);\n\t\t\t}\n\n\t\t\tappend(fieldset4, t5);\n\t\t\tappend(fieldset4, button);\n\t\t\tappend(button, t6);\n\t\t\tcurrent = true;\n\n\t\t\tif (!mounted) {\n\t\t\t\tdispose = [\n\t\t\t\t\tlisten(input0, \"input\", /*input0_input_handler*/ ctx[8]),\n\t\t\t\t\tlisten(input1, \"input\", /*input1_input_handler*/ ctx[9]),\n\t\t\t\t\tlisten(textarea, \"input\", /*textarea_input_handler*/ ctx[10]),\n\t\t\t\t\taction_destroyer(enter_action = enter.call(null, input2, /*addTag*/ ctx[4])),\n\t\t\t\t\tlisten(button, \"click\", /*publish*/ ctx[6])\n\t\t\t\t];\n\n\t\t\t\tmounted = true;\n\t\t\t}\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tif (dirty & /*article*/ 1 && input0.value !== /*article*/ ctx[0].title) {\n\t\t\t\tset_input_value(input0, /*article*/ ctx[0].title);\n\t\t\t}\n\n\t\t\tif (dirty & /*article*/ 1 && input1.value !== /*article*/ ctx[0].description) {\n\t\t\t\tset_input_value(input1, /*article*/ ctx[0].description);\n\t\t\t}\n\n\t\t\tif (dirty & /*article*/ 1) {\n\t\t\t\tset_input_value(textarea, /*article*/ ctx[0].body);\n\t\t\t}\n\n\t\t\tif (dirty & /*article, remove*/ 33) {\n\t\t\t\teach_value = /*article*/ ctx[0].tagList;\n\t\t\t\tlet i;\n\n\t\t\t\tfor (i = 0; i < each_value.length; i += 1) {\n\t\t\t\t\tconst child_ctx = get_each_context(ctx, each_value, i);\n\n\t\t\t\t\tif (each_blocks[i]) {\n\t\t\t\t\t\teach_blocks[i].p(child_ctx, dirty);\n\t\t\t\t\t} else {\n\t\t\t\t\t\teach_blocks[i] = create_each_block(child_ctx);\n\t\t\t\t\t\teach_blocks[i].c();\n\t\t\t\t\t\teach_blocks[i].m(div0, null);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor (; i < each_blocks.length; i += 1) {\n\t\t\t\t\teach_blocks[i].d(1);\n\t\t\t\t}\n\n\t\t\t\teach_blocks.length = each_value.length;\n\t\t\t}\n\n\t\t\tif (!current || dirty & /*inProgress*/ 2) {\n\t\t\t\tbutton.disabled = /*inProgress*/ ctx[1];\n\t\t\t}\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(listerrors.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(listerrors.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(div4);\n\t\t\tdestroy_component(listerrors);\n\t\t\tdestroy_each(each_blocks, detaching);\n\t\t\tmounted = false;\n\t\t\trun_all(dispose);\n\t\t}\n\t};\n}\n\nfunction enter(node, callback) {\n\tfunction onkeydown(event) {\n\t\tif (event.which === 13) callback(node);\n\t}\n\n\tnode.addEventListener(\"keydown\", onkeydown);\n\n\treturn {\n\t\tdestroy() {\n\t\t\tnode.removeEventListener(\"keydown\", onkeydown);\n\t\t}\n\t};\n}\n\nfunction instance($$self, $$props, $$invalidate) {\n\tlet $session;\n\tlet { article } = $$props;\n\tlet { slug } = $$props;\n\tlet inProgress = false;\n\tlet errors;\n\tconst { session } = stores$1();\n\tcomponent_subscribe($$self, session, value => $$invalidate(12, $session = value));\n\n\tfunction addTag(input) {\n\t\t$$invalidate(0, article.tagList = [...article.tagList, input.value], article);\n\t\tinput.value = \"\";\n\t}\n\n\tfunction remove(index) {\n\t\t$$invalidate(0, article.tagList = [...article.tagList.slice(0, index), ...article.tagList.slice(index + 1)], article);\n\t}\n\n\tasync function publish() {\n\t\t$$invalidate(1, inProgress = true);\n\n\t\tconst response = await (slug\n\t\t? put(`articles/${slug}`, { article }, $session.user && $session.user.token)\n\t\t: post(\"articles\", { article }, $session.user && $session.user.token));\n\n\t\tif (response.article) {\n\t\t\tgoto(`/article/${response.article.slug}`);\n\t\t}\n\n\t\t$$invalidate(1, inProgress = false);\n\t}\n\n\tfunction input0_input_handler() {\n\t\tarticle.title = this.value;\n\t\t$$invalidate(0, article);\n\t}\n\n\tfunction input1_input_handler() {\n\t\tarticle.description = this.value;\n\t\t$$invalidate(0, article);\n\t}\n\n\tfunction textarea_input_handler() {\n\t\tarticle.body = this.value;\n\t\t$$invalidate(0, article);\n\t}\n\n\tconst click_handler = i => remove(i);\n\n\t$$self.$set = $$props => {\n\t\tif (\"article\" in $$props) $$invalidate(0, article = $$props.article);\n\t\tif (\"slug\" in $$props) $$invalidate(7, slug = $$props.slug);\n\t};\n\n\treturn [\n\t\tarticle,\n\t\tinProgress,\n\t\terrors,\n\t\tsession,\n\t\taddTag,\n\t\tremove,\n\t\tpublish,\n\t\tslug,\n\t\tinput0_input_handler,\n\t\tinput1_input_handler,\n\t\ttextarea_input_handler,\n\t\tclick_handler\n\t];\n}\n\nclass Editor extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance, create_fragment, safe_not_equal, { article: 0, slug: 7 });\n\t}\n}\n\nexport { Editor as E };\n",
      "dynamicImports":[

      ],
      "exports":[
         "E"
      ],
      "facadeModuleId":null,
      "fileName":"_Editor.9d4f6b99.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[
         "client.9f4f62db.js",
         "api.5c9dd840.js",
         "ListErrors.ab5b20bd.js"
      ],
      "isDynamicEntry":false,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/src/routes/editor/_Editor.svelte":{
            "originalLength":2418,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":11644
         }
      },
      "name":"_Editor",
      "type":"chunk"
   },
   {
      "code":"import { S as SvelteComponent, i as init, s as safe_not_equal, c as create_component, a as claim_component, m as mount_component, t as transition_in, b as transition_out, d as destroy_component } from './client.9f4f62db.js';\nimport { g as get } from './api.5c9dd840.js';\nimport './ListErrors.ab5b20bd.js';\nimport { E as Editor } from './_Editor.9d4f6b99.js';\n\n/* src/routes/editor/[slug].svelte generated by Svelte v3.23.2 */\n\nfunction create_fragment(ctx) {\n\tlet editor;\n\tlet current;\n\n\teditor = new Editor({\n\t\t\tprops: {\n\t\t\t\tarticle: /*article*/ ctx[1],\n\t\t\t\tslug: /*slug*/ ctx[0]\n\t\t\t}\n\t\t});\n\n\treturn {\n\t\tc() {\n\t\t\tcreate_component(editor.$$.fragment);\n\t\t},\n\t\tl(nodes) {\n\t\t\tclaim_component(editor.$$.fragment, nodes);\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tmount_component(editor, target, anchor);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tconst editor_changes = {};\n\t\t\tif (dirty & /*article*/ 2) editor_changes.article = /*article*/ ctx[1];\n\t\t\tif (dirty & /*slug*/ 1) editor_changes.slug = /*slug*/ ctx[0];\n\t\t\teditor.$set(editor_changes);\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(editor.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(editor.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tdestroy_component(editor, detaching);\n\t\t}\n\t};\n}\n\nasync function preload({ params }) {\n\tconst { slug } = params;\n\tconst { article } = await get(`articles/${slug}`, null);\n\treturn { article, slug };\n}\n\nfunction instance($$self, $$props, $$invalidate) {\n\tlet { slug } = $$props;\n\tlet { article } = $$props;\n\n\t$$self.$set = $$props => {\n\t\tif (\"slug\" in $$props) $$invalidate(0, slug = $$props.slug);\n\t\tif (\"article\" in $$props) $$invalidate(1, article = $$props.article);\n\t};\n\n\treturn [slug, article];\n}\n\nclass U5Bslugu5D extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance, create_fragment, safe_not_equal, { slug: 0, article: 1 });\n\t}\n}\n\nexport default U5Bslugu5D;\nexport { preload };\n",
      "dynamicImports":[

      ],
      "exports":[
         "default",
         "preload"
      ],
      "facadeModuleId":"/home/bmccann/src/svelte-realworld/src/routes/editor/[slug].svelte",
      "fileName":"[slug].06001094.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[
         "client.9f4f62db.js",
         "api.5c9dd840.js",
         "ListErrors.ab5b20bd.js",
         "_Editor.9d4f6b99.js"
      ],
      "isDynamicEntry":true,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/src/routes/editor/[slug].svelte":{
            "originalLength":362,
            "removedExports":[

            ],
            "renderedExports":[
               "default",
               "preload"
            ],
            "renderedLength":1564
         }
      },
      "name":"[slug]",
      "type":"chunk"
   },
   {
      "code":"import { S as SvelteComponent, i as init, s as safe_not_equal, f as space, e as element, g as text, c as create_component, D as query_selector_all, k as detach, l as claim_space, h as claim_element, j as children, o as claim_text, a as claim_component, p as attr, q as insert, r as append, m as mount_component, K as set_input_value, u as listen, L as prevent_default, t as transition_in, b as transition_out, d as destroy_component, M as run_all, w as stores$1, x as component_subscribe, N as set_store_value, O as goto } from './client.9f4f62db.js';\nimport { L as ListErrors } from './ListErrors.ab5b20bd.js';\nimport { p as post } from './utils.d5c0e45a.js';\n\n/* src/routes/login/index.svelte generated by Svelte v3.23.2 */\n\nfunction create_fragment(ctx) {\n\tlet t0;\n\tlet div3;\n\tlet div2;\n\tlet div1;\n\tlet div0;\n\tlet h1;\n\tlet t1;\n\tlet t2;\n\tlet p;\n\tlet a;\n\tlet t3;\n\tlet t4;\n\tlet listerrors;\n\tlet t5;\n\tlet form;\n\tlet fieldset0;\n\tlet input0;\n\tlet t6;\n\tlet fieldset1;\n\tlet input1;\n\tlet t7;\n\tlet button;\n\tlet t8;\n\tlet button_disabled_value;\n\tlet current;\n\tlet mounted;\n\tlet dispose;\n\tlisterrors = new ListErrors({ props: { errors: /*errors*/ ctx[2] } });\n\n\treturn {\n\t\tc() {\n\t\t\tt0 = space();\n\t\t\tdiv3 = element(\"div\");\n\t\t\tdiv2 = element(\"div\");\n\t\t\tdiv1 = element(\"div\");\n\t\t\tdiv0 = element(\"div\");\n\t\t\th1 = element(\"h1\");\n\t\t\tt1 = text(\"Sign In\");\n\t\t\tt2 = space();\n\t\t\tp = element(\"p\");\n\t\t\ta = element(\"a\");\n\t\t\tt3 = text(\"Need an account?\");\n\t\t\tt4 = space();\n\t\t\tcreate_component(listerrors.$$.fragment);\n\t\t\tt5 = space();\n\t\t\tform = element(\"form\");\n\t\t\tfieldset0 = element(\"fieldset\");\n\t\t\tinput0 = element(\"input\");\n\t\t\tt6 = space();\n\t\t\tfieldset1 = element(\"fieldset\");\n\t\t\tinput1 = element(\"input\");\n\t\t\tt7 = space();\n\t\t\tbutton = element(\"button\");\n\t\t\tt8 = text(\"Sign in\");\n\t\t\tthis.h();\n\t\t},\n\t\tl(nodes) {\n\t\t\tconst head_nodes = query_selector_all(\"[data-svelte=\\\"svelte-10oct2o\\\"]\", document.head);\n\t\t\thead_nodes.forEach(detach);\n\t\t\tt0 = claim_space(nodes);\n\t\t\tdiv3 = claim_element(nodes, \"DIV\", { class: true });\n\t\t\tvar div3_nodes = children(div3);\n\t\t\tdiv2 = claim_element(div3_nodes, \"DIV\", { class: true });\n\t\t\tvar div2_nodes = children(div2);\n\t\t\tdiv1 = claim_element(div2_nodes, \"DIV\", { class: true });\n\t\t\tvar div1_nodes = children(div1);\n\t\t\tdiv0 = claim_element(div1_nodes, \"DIV\", { class: true });\n\t\t\tvar div0_nodes = children(div0);\n\t\t\th1 = claim_element(div0_nodes, \"H1\", { class: true });\n\t\t\tvar h1_nodes = children(h1);\n\t\t\tt1 = claim_text(h1_nodes, \"Sign In\");\n\t\t\th1_nodes.forEach(detach);\n\t\t\tt2 = claim_space(div0_nodes);\n\t\t\tp = claim_element(div0_nodes, \"P\", { class: true });\n\t\t\tvar p_nodes = children(p);\n\t\t\ta = claim_element(p_nodes, \"A\", { href: true });\n\t\t\tvar a_nodes = children(a);\n\t\t\tt3 = claim_text(a_nodes, \"Need an account?\");\n\t\t\ta_nodes.forEach(detach);\n\t\t\tp_nodes.forEach(detach);\n\t\t\tt4 = claim_space(div0_nodes);\n\t\t\tclaim_component(listerrors.$$.fragment, div0_nodes);\n\t\t\tt5 = claim_space(div0_nodes);\n\t\t\tform = claim_element(div0_nodes, \"FORM\", {});\n\t\t\tvar form_nodes = children(form);\n\t\t\tfieldset0 = claim_element(form_nodes, \"FIELDSET\", { class: true });\n\t\t\tvar fieldset0_nodes = children(fieldset0);\n\n\t\t\tinput0 = claim_element(fieldset0_nodes, \"INPUT\", {\n\t\t\t\tclass: true,\n\t\t\t\ttype: true,\n\t\t\t\tplaceholder: true\n\t\t\t});\n\n\t\t\tfieldset0_nodes.forEach(detach);\n\t\t\tt6 = claim_space(form_nodes);\n\t\t\tfieldset1 = claim_element(form_nodes, \"FIELDSET\", { class: true });\n\t\t\tvar fieldset1_nodes = children(fieldset1);\n\n\t\t\tinput1 = claim_element(fieldset1_nodes, \"INPUT\", {\n\t\t\t\tclass: true,\n\t\t\t\ttype: true,\n\t\t\t\tplaceholder: true\n\t\t\t});\n\n\t\t\tfieldset1_nodes.forEach(detach);\n\t\t\tt7 = claim_space(form_nodes);\n\t\t\tbutton = claim_element(form_nodes, \"BUTTON\", { class: true, type: true, disabled: true });\n\t\t\tvar button_nodes = children(button);\n\t\t\tt8 = claim_text(button_nodes, \"Sign in\");\n\t\t\tbutton_nodes.forEach(detach);\n\t\t\tform_nodes.forEach(detach);\n\t\t\tdiv0_nodes.forEach(detach);\n\t\t\tdiv1_nodes.forEach(detach);\n\t\t\tdiv2_nodes.forEach(detach);\n\t\t\tdiv3_nodes.forEach(detach);\n\t\t\tthis.h();\n\t\t},\n\t\th() {\n\t\t\tdocument.title = \"Sign in • Conduit\";\n\t\t\tattr(h1, \"class\", \"text-xs-center\");\n\t\t\tattr(a, \"href\", \"/register\");\n\t\t\tattr(p, \"class\", \"text-xs-center\");\n\t\t\tattr(input0, \"class\", \"form-control form-control-lg\");\n\t\t\tattr(input0, \"type\", \"email\");\n\t\t\tattr(input0, \"placeholder\", \"Email\");\n\t\t\tattr(fieldset0, \"class\", \"form-group\");\n\t\t\tattr(input1, \"class\", \"form-control form-control-lg\");\n\t\t\tattr(input1, \"type\", \"password\");\n\t\t\tattr(input1, \"placeholder\", \"Password\");\n\t\t\tattr(fieldset1, \"class\", \"form-group\");\n\t\t\tattr(button, \"class\", \"btn btn-lg btn-primary pull-xs-right\");\n\t\t\tattr(button, \"type\", \"submit\");\n\t\t\tbutton.disabled = button_disabled_value = !/*email*/ ctx[0] || !/*password*/ ctx[1];\n\t\t\tattr(div0, \"class\", \"col-md-6 offset-md-3 col-xs-12\");\n\t\t\tattr(div1, \"class\", \"row\");\n\t\t\tattr(div2, \"class\", \"container page\");\n\t\t\tattr(div3, \"class\", \"auth-page\");\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tinsert(target, t0, anchor);\n\t\t\tinsert(target, div3, anchor);\n\t\t\tappend(div3, div2);\n\t\t\tappend(div2, div1);\n\t\t\tappend(div1, div0);\n\t\t\tappend(div0, h1);\n\t\t\tappend(h1, t1);\n\t\t\tappend(div0, t2);\n\t\t\tappend(div0, p);\n\t\t\tappend(p, a);\n\t\t\tappend(a, t3);\n\t\t\tappend(div0, t4);\n\t\t\tmount_component(listerrors, div0, null);\n\t\t\tappend(div0, t5);\n\t\t\tappend(div0, form);\n\t\t\tappend(form, fieldset0);\n\t\t\tappend(fieldset0, input0);\n\t\t\tset_input_value(input0, /*email*/ ctx[0]);\n\t\t\tappend(form, t6);\n\t\t\tappend(form, fieldset1);\n\t\t\tappend(fieldset1, input1);\n\t\t\tset_input_value(input1, /*password*/ ctx[1]);\n\t\t\tappend(form, t7);\n\t\t\tappend(form, button);\n\t\t\tappend(button, t8);\n\t\t\tcurrent = true;\n\n\t\t\tif (!mounted) {\n\t\t\t\tdispose = [\n\t\t\t\t\tlisten(input0, \"input\", /*input0_input_handler*/ ctx[5]),\n\t\t\t\t\tlisten(input1, \"input\", /*input1_input_handler*/ ctx[6]),\n\t\t\t\t\tlisten(form, \"submit\", prevent_default(/*submit*/ ctx[4]))\n\t\t\t\t];\n\n\t\t\t\tmounted = true;\n\t\t\t}\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tconst listerrors_changes = {};\n\t\t\tif (dirty & /*errors*/ 4) listerrors_changes.errors = /*errors*/ ctx[2];\n\t\t\tlisterrors.$set(listerrors_changes);\n\n\t\t\tif (dirty & /*email*/ 1 && input0.value !== /*email*/ ctx[0]) {\n\t\t\t\tset_input_value(input0, /*email*/ ctx[0]);\n\t\t\t}\n\n\t\t\tif (dirty & /*password*/ 2 && input1.value !== /*password*/ ctx[1]) {\n\t\t\t\tset_input_value(input1, /*password*/ ctx[1]);\n\t\t\t}\n\n\t\t\tif (!current || dirty & /*email, password*/ 3 && button_disabled_value !== (button_disabled_value = !/*email*/ ctx[0] || !/*password*/ ctx[1])) {\n\t\t\t\tbutton.disabled = button_disabled_value;\n\t\t\t}\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(listerrors.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(listerrors.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tif (detaching) detach(t0);\n\t\t\tif (detaching) detach(div3);\n\t\t\tdestroy_component(listerrors);\n\t\t\tmounted = false;\n\t\t\trun_all(dispose);\n\t\t}\n\t};\n}\n\nfunction instance($$self, $$props, $$invalidate) {\n\tlet $session;\n\tconst { session } = stores$1();\n\tcomponent_subscribe($$self, session, value => $$invalidate(7, $session = value));\n\tlet email = \"\";\n\tlet password = \"\";\n\tlet errors = null;\n\n\tasync function submit(event) {\n\t\tconst response = await post(`auth/login`, { email, password });\n\n\t\t// TODO handle network errors\n\t\t$$invalidate(2, errors = response.errors);\n\n\t\tif (response.user) {\n\t\t\tset_store_value(session, $session.user = response.user, $session);\n\t\t\tgoto(\"/\");\n\t\t}\n\t}\n\n\tfunction input0_input_handler() {\n\t\temail = this.value;\n\t\t$$invalidate(0, email);\n\t}\n\n\tfunction input1_input_handler() {\n\t\tpassword = this.value;\n\t\t$$invalidate(1, password);\n\t}\n\n\treturn [\n\t\temail,\n\t\tpassword,\n\t\terrors,\n\t\tsession,\n\t\tsubmit,\n\t\tinput0_input_handler,\n\t\tinput1_input_handler\n\t];\n}\n\nclass Login extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance, create_fragment, safe_not_equal, {});\n\t}\n}\n\nexport default Login;\n",
      "dynamicImports":[

      ],
      "exports":[
         "default"
      ],
      "facadeModuleId":"/home/bmccann/src/svelte-realworld/src/routes/login/index.svelte",
      "fileName":"index.54a81c7b.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[
         "client.9f4f62db.js",
         "ListErrors.ab5b20bd.js",
         "utils.d5c0e45a.js"
      ],
      "isDynamicEntry":true,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/src/routes/login/index.svelte":{
            "originalLength":1377,
            "removedExports":[

            ],
            "renderedExports":[
               "default"
            ],
            "renderedLength":7136
         }
      },
      "name":"index",
      "type":"chunk"
   },
   {
      "code":"import { S as SvelteComponent, i as init, s as safe_not_equal, c as create_component, a as claim_component, m as mount_component, t as transition_in, b as transition_out, d as destroy_component } from './client.9f4f62db.js';\nimport './api.5c9dd840.js';\nimport './index.dccd3ebe.js';\nimport { H as Home } from './Home.ba941e4e.js';\n\n/* src/routes/[p].svelte generated by Svelte v3.23.2 */\n\nfunction create_fragment(ctx) {\n\tlet home;\n\tlet current;\n\thome = new Home({ props: { p: /*p*/ ctx[0] } });\n\n\treturn {\n\t\tc() {\n\t\t\tcreate_component(home.$$.fragment);\n\t\t},\n\t\tl(nodes) {\n\t\t\tclaim_component(home.$$.fragment, nodes);\n\t\t},\n\t\tm(target, anchor) {\n\t\t\tmount_component(home, target, anchor);\n\t\t\tcurrent = true;\n\t\t},\n\t\tp(ctx, [dirty]) {\n\t\t\tconst home_changes = {};\n\t\t\tif (dirty & /*p*/ 1) home_changes.p = /*p*/ ctx[0];\n\t\t\thome.$set(home_changes);\n\t\t},\n\t\ti(local) {\n\t\t\tif (current) return;\n\t\t\ttransition_in(home.$$.fragment, local);\n\t\t\tcurrent = true;\n\t\t},\n\t\to(local) {\n\t\t\ttransition_out(home.$$.fragment, local);\n\t\t\tcurrent = false;\n\t\t},\n\t\td(detaching) {\n\t\t\tdestroy_component(home, detaching);\n\t\t}\n\t};\n}\n\nfunction preload({ params }) {\n\treturn { p: +params.p };\n}\n\nfunction instance($$self, $$props, $$invalidate) {\n\tlet { p } = $$props;\n\n\t$$self.$set = $$props => {\n\t\tif (\"p\" in $$props) $$invalidate(0, p = $$props.p);\n\t};\n\n\treturn [p];\n}\n\nclass U5Bpu5D extends SvelteComponent {\n\tconstructor(options) {\n\t\tsuper();\n\t\tinit(this, options, instance, create_fragment, safe_not_equal, { p: 0 });\n\t}\n}\n\nexport default U5Bpu5D;\nexport { preload };\n",
      "dynamicImports":[

      ],
      "exports":[
         "default",
         "preload"
      ],
      "facadeModuleId":"/home/bmccann/src/svelte-realworld/src/routes/[p].svelte",
      "fileName":"[p].449c37dd.js",
      "implicitlyLoadedBefore":[

      ],
      "imports":[
         "client.9f4f62db.js",
         "api.5c9dd840.js",
         "index.dccd3ebe.js",
         "Home.ba941e4e.js"
      ],
      "isDynamicEntry":true,
      "isEntry":false,
      "isImplicitEntry":false,
      "map":null,
      "modules":{
         "/home/bmccann/src/svelte-realworld/src/routes/[p].svelte":{
            "originalLength":204,
            "removedExports":[

            ],
            "renderedExports":[
               "default",
               "preload"
            ],
            "renderedLength":1159
         }
      },
      "name":"[p]",
      "type":"chunk"
   }
]