"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.command = void 0;
const fs_1 = require("fs");
const colors_1 = require("kleur/colors");
const path_1 = __importDefault(require("path"));
const logger_1 = require("../logger");
async function command(commandOptions) {
    const { cwd } = commandOptions;
    logger_1.logger.info(`Creating new project configuration file... ${colors_1.dim('(snowpack.config.js)')}`);
    const templateLoc = path_1.default.join(__dirname, '../../assets/snowpack-init-file.js');
    const destLoc = path_1.default.join(cwd, 'snowpack.config.js');
    if (fs_1.existsSync(destLoc)) {
        logger_1.logger.error(`Error: File already exists, cannot overwrite ${destLoc}`);
        process.exit(1);
    }
    await fs_1.promises.copyFile(templateLoc, destLoc, fs_1.constants.COPYFILE_EXCL);
    logger_1.logger.info(`File created! Open ${colors_1.bold('snowpack.config.js')} to customize your project.`);
}
exports.command = command;
//# sourceMappingURL=init.js.map